/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.dependencies;

import com.android.tools.idea.gradle.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.dependencies.AbstractAddDependenciesDialog;
import com.android.tools.idea.gradle.structure.dependencies.AbstractDependencyScopesPanel;
import com.android.tools.idea.gradle.structure.dependencies.AddLibraryDependencyDialogKt;
import com.android.tools.idea.gradle.structure.dependencies.DependencyScopePanel;
import com.android.tools.idea.gradle.structure.dependencies.LibraryDependenciesForm;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.meta.ParsedValue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u000fH\u0014J\b\u0010\u0013\u001a\u00020\u000fH\u0014J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0015\u001a\u00020\rH\u0014J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u0005H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/gradle/structure/dependencies/AddLibraryDependencyDialog;", "Lcom/android/tools/idea/gradle/structure/dependencies/AbstractAddDependenciesDialog;", "context", "Lcom/android/tools/idea/gradle/structure/configurables/PsContext;", "module", "Lcom/android/tools/idea/gradle/structure/model/PsModule;", "<init>", "(Lcom/android/tools/idea/gradle/structure/configurables/PsContext;Lcom/android/tools/idea/gradle/structure/model/PsModule;)V", "libraryDependenciesForm", "Lcom/android/tools/idea/gradle/structure/dependencies/LibraryDependenciesForm;", "postponeValidation", "", "addNewDependencies", "", "getSplitterProportionKey", "", "getDependencySelectionView", "Ljavax/swing/JComponent;", "getInstructions", "getDimensionServiceKey", "getPreferredFocusedComponent", "dispose", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "createDependencyScopesPanel", "Lcom/android/tools/idea/gradle/structure/dependencies/AbstractDependencyScopesPanel;", "intellij.android.projectSystem.gradle.psd"})
@SourceDebugExtension(value={"SMAP\nAddLibraryDependencyDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddLibraryDependencyDialog.kt\ncom/android/tools/idea/gradle/structure/dependencies/AddLibraryDependencyDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1869#2,2:103\n*S KotlinDebug\n*F\n+ 1 AddLibraryDependencyDialog.kt\ncom/android/tools/idea/gradle/structure/dependencies/AddLibraryDependencyDialog\n*L\n83#1:103,2\n*E\n"})
public final class AddLibraryDependencyDialog
extends AbstractAddDependenciesDialog {
    @NotNull
    private final PsContext context;
    @Nullable
    private LibraryDependenciesForm libraryDependenciesForm;

    public AddLibraryDependencyDialog(@NotNull PsContext context, @NotNull PsModule module) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        super(module);
        this.context = context;
        this.setTitle("Add Library Dependency");
        this.init();
    }

    @Override
    protected boolean postponeValidation() {
        return true;
    }

    @Override
    public void addNewDependencies() {
        LibraryDependenciesForm libraryDependenciesForm = this.libraryDependenciesForm;
        Intrinsics.checkNotNull((Object)libraryDependenciesForm);
        ParsedValue<String> library = libraryDependenciesForm.getSelectedLibrary();
        String scopeName = this.getScopesPanel().getSelectedScopeName();
        if (!(library instanceof ParsedValue.Set.Parsed)) {
            throw new IllegalStateException();
        }
        this.getModule().addLibraryDependency((ParsedValue.Set.Parsed)library, scopeName);
    }

    @Override
    @NotNull
    protected String getSplitterProportionKey() {
        return "psd.add.library.dependency.main.horizontal.splitter.proportion";
    }

    @Override
    @NotNull
    protected JComponent getDependencySelectionView() {
        if (this.libraryDependenciesForm == null) {
            PsModule psModule = this.getModule();
            Intrinsics.checkNotNullExpressionValue((Object)psModule, (String)"getModule(...)");
            this.libraryDependenciesForm = new LibraryDependenciesForm(this.context, psModule);
        }
        LibraryDependenciesForm libraryDependenciesForm = this.libraryDependenciesForm;
        Intrinsics.checkNotNull((Object)libraryDependenciesForm);
        return libraryDependenciesForm.getPanel();
    }

    @Override
    @NotNull
    protected String getInstructions() {
        Object object = this.libraryDependenciesForm;
        return "Use the form below to find the library to add. This form uses the repositories specified in the project's build files (" + (object != null && (object = ((LibraryDependenciesForm)object).getRepositories()) != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)", ", null, null, (int)0, null, AddLibraryDependencyDialog::getInstructions$lambda$0, (int)30, null) : null) + ")";
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "psd.add.library.dependency.panel.dimension";
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent;
        if (this.libraryDependenciesForm != null) {
            LibraryDependenciesForm libraryDependenciesForm = this.libraryDependenciesForm;
            Intrinsics.checkNotNull((Object)libraryDependenciesForm);
            jComponent = libraryDependenciesForm.getPreferredFocusedComponent();
        } else {
            jComponent = null;
        }
        return jComponent;
    }

    @Override
    protected void dispose() {
        super.dispose();
        if (this.libraryDependenciesForm != null) {
            LibraryDependenciesForm libraryDependenciesForm = this.libraryDependenciesForm;
            Intrinsics.checkNotNull((Object)libraryDependenciesForm);
            Disposer.dispose((Disposable)libraryDependenciesForm);
        }
    }

    @Nullable
    protected ValidationInfo doValidate() {
        LibraryDependenciesForm libraryDependenciesForm = this.libraryDependenciesForm;
        Intrinsics.checkNotNull((Object)libraryDependenciesForm);
        ParsedValue<String> selectedLibrary = libraryDependenciesForm.getSelectedLibrary();
        if (!Intrinsics.areEqual(selectedLibrary, (Object)ParsedValue.NotSet.INSTANCE)) {
            return this.getScopesPanel().validateInput();
        }
        LibraryDependenciesForm libraryDependenciesForm2 = this.libraryDependenciesForm;
        Intrinsics.checkNotNull((Object)libraryDependenciesForm2);
        List<Exception> searchErrors = libraryDependenciesForm2.getSearchErrors();
        if (!searchErrors.isEmpty()) {
            StringBuilder stringBuilder;
            StringBuilder $this$doValidate_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            Iterable $this$forEach$iv = searchErrors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Exception it = (Exception)element$iv;
                boolean bl2 = false;
                $this$doValidate_u24lambda_u240.append(AddLibraryDependencyDialogKt.access$getErrorMessage(it));
                $this$doValidate_u24lambda_u240.append("\n");
            }
            String string = stringBuilder.toString();
            LibraryDependenciesForm libraryDependenciesForm3 = this.libraryDependenciesForm;
            Intrinsics.checkNotNull((Object)libraryDependenciesForm3);
            JComponent jComponent = libraryDependenciesForm3.getPreferredFocusedComponent();
            String string2 = string;
            return new ValidationInfo(string2, jComponent);
        }
        LibraryDependenciesForm libraryDependenciesForm4 = this.libraryDependenciesForm;
        Intrinsics.checkNotNull((Object)libraryDependenciesForm4);
        return new ValidationInfo("Please specify the library to add as dependency", libraryDependenciesForm4.getPreferredFocusedComponent());
    }

    @Override
    @NotNull
    protected AbstractDependencyScopesPanel createDependencyScopesPanel(@NotNull PsModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return new DependencyScopePanel(module, PsModule.ImportantFor.LIBRARY);
    }

    private static final CharSequence getInstructions$lambda$0(ArtifactRepository it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }
}

