/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon.analysis;

import com.android.tools.idea.gradle.dsl.android.model.android.AndroidModelUtilsKt;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.api.util.GradleDslContextModel;
import com.android.tools.idea.gradle.structure.configurables.PsPathRenderer;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsMissingBuildTypeFallbackQuickFix;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsMissingBuildTypeQuickFix;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsMissingProductFlavorFallbackQuickFix;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsMissingProductFlavorQuickFix;
import com.android.tools.idea.gradle.structure.model.PsGeneralIssue;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsModulePath;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.android.tools.idea.gradle.structure.model.PsQuickFix;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsBuildType;
import com.android.tools.idea.gradle.structure.model.android.PsDeclaredModuleAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsFlavorDimension;
import com.android.tools.idea.gradle.structure.model.android.PsProductFlavor;
import com.android.tools.idea.gradle.structure.model.meta.ParsedValueKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00012\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"analyzeModuleDependencies", "Lkotlin/sequences/Sequence;", "Lcom/android/tools/idea/gradle/structure/model/PsIssue;", "androidModule", "Lcom/android/tools/idea/gradle/structure/model/android/PsAndroidModule;", "pathRenderer", "Lcom/android/tools/idea/gradle/structure/configurables/PsPathRenderer;", "analyzeModuleDependency", "dependency", "Lcom/android/tools/idea/gradle/structure/model/android/PsDeclaredModuleAndroidDependency;", "analyzeProductFlavors", "Lcom/android/tools/idea/gradle/structure/model/PsGeneralIssue;", "model", "intellij.android.projectSystem.gradle.psd"})
@SourceDebugExtension(value={"SMAP\nPsAndroidModuleVariantsAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsAndroidModuleVariantsAnalyzer.kt\ncom/android/tools/idea/gradle/structure/daemon/analysis/PsAndroidModuleVariantsAnalyzerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,221:1\n1761#2,3:222\n1761#2,3:225\n1788#2,4:228\n1740#2,3:232\n*S KotlinDebug\n*F\n+ 1 PsAndroidModuleVariantsAnalyzer.kt\ncom/android/tools/idea/gradle/structure/daemon/analysis/PsAndroidModuleVariantsAnalyzerKt\n*L\n46#1:222,3\n70#1:225,3\n91#1:228,4\n95#1:232,3\n*E\n"})
public final class PsAndroidModuleVariantsAnalyzerKt {
    @NotNull
    public static final Sequence<PsIssue> analyzeModuleDependencies(@NotNull PsAndroidModule androidModule, @NotNull PsPathRenderer pathRenderer) {
        Intrinsics.checkNotNullParameter((Object)androidModule, (String)"androidModule");
        Intrinsics.checkNotNullParameter((Object)pathRenderer, (String)"pathRenderer");
        return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)androidModule.getDependencies().getModules()), arg_0 -> PsAndroidModuleVariantsAnalyzerKt.analyzeModuleDependencies$lambda$0(pathRenderer, arg_0));
    }

    @NotNull
    public static final Sequence<PsIssue> analyzeModuleDependency(@NotNull PsDeclaredModuleAndroidDependency dependency, @NotNull PsPathRenderer pathRenderer) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)pathRenderer, (String)"pathRenderer");
        PsPathRenderer $this$analyzeModuleDependency_u24lambda_u240 = pathRenderer;
        boolean bl = false;
        PsAndroidModule sourceModule = dependency.getParent();
        PsModule psModule = dependency.getParent().getParent().findModuleByGradlePath(dependency.getGradlePath());
        PsAndroidModule psAndroidModule = psModule instanceof PsAndroidModule ? (PsAndroidModule)psModule : null;
        if (psAndroidModule == null) {
            return SequencesKt.emptySequence();
        }
        PsAndroidModule targetModule = psAndroidModule;
        return SequencesKt.plus((Sequence)SequencesKt.plus(PsAndroidModuleVariantsAnalyzerKt.analyzeModuleDependency$lambda$0$analyzeBuildTypes(sourceModule, $this$analyzeModuleDependency_u24lambda_u240, targetModule, dependency), PsAndroidModuleVariantsAnalyzerKt.analyzeModuleDependency$lambda$0$analyzeProductFlavors(sourceModule, targetModule, $this$analyzeModuleDependency_u24lambda_u240, dependency)), PsAndroidModuleVariantsAnalyzerKt.analyzeModuleDependency$lambda$0$analyzeFlavorDimensions(targetModule, sourceModule, $this$analyzeModuleDependency_u24lambda_u240, dependency));
    }

    @NotNull
    public static final Sequence<PsGeneralIssue> analyzeProductFlavors(@NotNull PsAndroidModule model, @NotNull PsPathRenderer pathRenderer) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)pathRenderer, (String)"pathRenderer");
        PsPathRenderer $this$analyzeProductFlavors_u24lambda_u240 = pathRenderer;
        boolean bl = false;
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)model.getProductFlavors()), PsAndroidModuleVariantsAnalyzerKt::analyzeProductFlavors$lambda$0$0), arg_0 -> PsAndroidModuleVariantsAnalyzerKt.analyzeProductFlavors$lambda$0$1($this$analyzeProductFlavors_u24lambda_u240, arg_0));
    }

    private static final Sequence analyzeModuleDependencies$lambda$0(PsPathRenderer $pathRenderer, PsDeclaredModuleAndroidDependency it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PsAndroidModuleVariantsAnalyzerKt.analyzeModuleDependency(it, $pathRenderer);
    }

    private static final Sequence<PsGeneralIssue> analyzeModuleDependency$lambda$0$analyzeBuildTypes(PsAndroidModule sourceModule, PsPathRenderer $this_with, PsAndroidModule targetModule, PsDeclaredModuleAndroidDependency $dependency) {
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)sourceModule.getBuildTypes().getItems()), arg_0 -> PsAndroidModuleVariantsAnalyzerKt.analyzeModuleDependency$lambda$0$analyzeBuildTypes$0($this_with, targetModule, $dependency, arg_0));
    }

    private static final boolean analyzeModuleDependency$lambda$0$analyzeBuildTypes$targetBuildTypeExists(PsAndroidModule targetModule, String buildTypeName) {
        return targetModule.findBuildType(buildTypeName) != null;
    }

    private static final PsGeneralIssue analyzeModuleDependency$lambda$0$analyzeBuildTypes$0(PsPathRenderer $this_with, PsAndroidModule $targetModule, PsDeclaredModuleAndroidDependency $dependency, PsBuildType sourceBuildType) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)sourceBuildType, (String)"sourceBuildType");
        if (PsAndroidModuleVariantsAnalyzerKt.analyzeModuleDependency$lambda$0$analyzeBuildTypes$targetBuildTypeExists($targetModule, sourceBuildType.getName())) {
            return null;
        }
        List<String> list2 = ParsedValueKt.getMaybeValue(sourceBuildType.getMatchingFallbacks());
        if (list2 != null) {
            boolean bl2;
            block7: {
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String fallback = (String)element$iv;
                        boolean bl3 = false;
                        if (!PsAndroidModuleVariantsAnalyzerKt.analyzeModuleDependency$lambda$0$analyzeBuildTypes$targetBuildTypeExists($targetModule, fallback)) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        if (bl) {
            return null;
        }
        String string = "No build type in module '" + $this_with.renderNavigation((PsPath)$targetModule.getPath(), PsAndroidModuleVariantsAnalyzerKt::analyzeModuleDependency$lambda$0$analyzeBuildTypes$0$1) + "' matches build type '" + PsPathRenderer.renderNavigation$default($this_with, sourceBuildType.getPath(), null, 1, null) + "'.";
        PsPath psPath = $dependency.getPath();
        PsIssueType psIssueType = PsIssueType.PROJECT_ANALYSIS;
        Intrinsics.checkNotNullExpressionValue((Object)psIssueType, (String)"PROJECT_ANALYSIS");
        Object[] objectArray = new PsQuickFix[]{new PsMissingBuildTypeQuickFix($targetModule, sourceBuildType), new PsMissingBuildTypeFallbackQuickFix(sourceBuildType)};
        return new PsGeneralIssue(string, "", psPath, psIssueType, PsIssue.Severity.ERROR, CollectionsKt.listOf((Object[])objectArray), null, 64, null);
    }

    private static final PsPath analyzeModuleDependency$lambda$0$analyzeBuildTypes$0$1(PsModulePath $this$renderNavigation) {
        Intrinsics.checkNotNullParameter((Object)$this$renderNavigation, (String)"$this$renderNavigation");
        return $this$renderNavigation.getBuildTypesPath();
    }

    private static final Sequence<PsIssue> analyzeModuleDependency$lambda$0$analyzeProductFlavors(PsAndroidModule sourceModule, PsAndroidModule targetModule, PsPathRenderer $this_with, PsDeclaredModuleAndroidDependency $dependency) {
        return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)sourceModule.getFlavorDimensions()), arg_0 -> PsAndroidModuleVariantsAnalyzerKt.analyzeModuleDependency$lambda$0$analyzeProductFlavors$1(targetModule, sourceModule, $this_with, $dependency, arg_0));
    }

    private static final Sequence analyzeModuleDependency$lambda$0$analyzeProductFlavors$1(PsAndroidModule $targetModule, PsAndroidModule $sourceModule, PsPathRenderer $this_with, PsDeclaredModuleAndroidDependency $dependency, PsFlavorDimension sourceDimension) {
        Intrinsics.checkNotNullParameter((Object)sourceDimension, (String)"sourceDimension");
        if ($targetModule.findFlavorDimension(sourceDimension.getName()) == null) {
            return SequencesKt.emptySequence();
        }
        return SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$sourceModule.getProductFlavors().getItems()), arg_0 -> PsAndroidModuleVariantsAnalyzerKt.analyzeModuleDependency$lambda$0$analyzeProductFlavors$1$0(sourceDimension, arg_0)), arg_0 -> PsAndroidModuleVariantsAnalyzerKt.analyzeModuleDependency$lambda$0$analyzeProductFlavors$1$1($targetModule, sourceDimension, $this_with, $dependency, arg_0));
    }

    private static final boolean analyzeModuleDependency$lambda$0$analyzeProductFlavors$1$0(PsFlavorDimension $sourceDimension, PsProductFlavor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getEffectiveDimension(), (Object)$sourceDimension.getName());
    }

    private static final PsGeneralIssue analyzeModuleDependency$lambda$0$analyzeProductFlavors$1$1(PsAndroidModule $targetModule, PsFlavorDimension $sourceDimension, PsPathRenderer $this_with, PsDeclaredModuleAndroidDependency $dependency, PsProductFlavor sourceProductFlavor) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)sourceProductFlavor, (String)"sourceProductFlavor");
        if ($targetModule.findProductFlavor($sourceDimension.getName(), sourceProductFlavor.getName()) != null) {
            return null;
        }
        List<String> list2 = ParsedValueKt.getMaybeValue(sourceProductFlavor.getMatchingFallbacks());
        if (list2 != null) {
            boolean bl2;
            block7: {
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String fallback = (String)element$iv;
                        boolean bl3 = false;
                        if (!($targetModule.findProductFlavor($sourceDimension.getName(), fallback) != null)) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        if (bl) {
            return null;
        }
        String string = "No product flavor in module '" + $this_with.renderNavigation((PsPath)$targetModule.getPath(), PsAndroidModuleVariantsAnalyzerKt::analyzeModuleDependency$lambda$0$analyzeProductFlavors$1$1$1) + "' matches product flavor '" + PsPathRenderer.renderNavigation$default($this_with, sourceProductFlavor.getPath(), null, 1, null) + "' in dimension '" + PsPathRenderer.renderNavigation$default($this_with, $sourceDimension.getPath(), null, 1, null) + "'.";
        PsPath psPath = $dependency.getPath();
        PsIssueType psIssueType = PsIssueType.PROJECT_ANALYSIS;
        Intrinsics.checkNotNullExpressionValue((Object)psIssueType, (String)"PROJECT_ANALYSIS");
        Object[] objectArray = new PsQuickFix[]{new PsMissingProductFlavorQuickFix($targetModule, sourceProductFlavor), new PsMissingProductFlavorFallbackQuickFix(sourceProductFlavor)};
        return new PsGeneralIssue(string, "", psPath, psIssueType, PsIssue.Severity.ERROR, CollectionsKt.listOf((Object[])objectArray), null, 64, null);
    }

    private static final PsPath analyzeModuleDependency$lambda$0$analyzeProductFlavors$1$1$1(PsModulePath $this$renderNavigation) {
        Intrinsics.checkNotNullParameter((Object)$this$renderNavigation, (String)"$this$renderNavigation");
        return $this$renderNavigation.getProductFlavorsPath();
    }

    private static final Sequence<PsGeneralIssue> analyzeModuleDependency$lambda$0$analyzeFlavorDimensions(PsAndroidModule targetModule, PsAndroidModule sourceModule, PsPathRenderer $this_with, PsDeclaredModuleAndroidDependency $dependency) {
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)targetModule.getFlavorDimensions().getItems()), arg_0 -> PsAndroidModuleVariantsAnalyzerKt.analyzeModuleDependency$lambda$0$analyzeFlavorDimensions$2(targetModule, arg_0)), arg_0 -> PsAndroidModuleVariantsAnalyzerKt.analyzeModuleDependency$lambda$0$analyzeFlavorDimensions$3(sourceModule, arg_0)), arg_0 -> PsAndroidModuleVariantsAnalyzerKt.analyzeModuleDependency$lambda$0$analyzeFlavorDimensions$4($this_with, sourceModule, targetModule, $dependency, arg_0));
    }

    private static final boolean analyzeModuleDependency$lambda$0$analyzeFlavorDimensions$2(PsAndroidModule $targetModule, PsFlavorDimension targetDimension) {
        int n;
        Intrinsics.checkNotNullParameter((Object)targetDimension, (String)"targetDimension");
        Iterable $this$count$iv = $targetModule.getProductFlavors().getItems();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                PsProductFlavor it = (PsProductFlavor)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getEffectiveDimension(), (Object)targetDimension.getName()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n > 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean analyzeModuleDependency$lambda$0$analyzeFlavorDimensions$3(PsAndroidModule $sourceModule, PsFlavorDimension targetDimension) {
        boolean bl;
        List<ResolvedPropertyModel> list2;
        Intrinsics.checkNotNullParameter((Object)targetDimension, (String)"targetDimension");
        if ($sourceModule.findFlavorDimension(targetDimension.getName()) != null) return false;
        GradleDslContextModel gradleDslContextModel = $sourceModule.getParsedModel();
        if ((gradleDslContextModel != null && (gradleDslContextModel = AndroidModelUtilsKt.android((GradleBuildModel)gradleDslContextModel)) != null && (gradleDslContextModel = gradleDslContextModel.defaultConfig()) != null ? gradleDslContextModel.missingDimensionStrategies() : (list2 = null)) == null) {
            list2 = CollectionsKt.emptyList();
        }
        Iterable $this$all$iv = list2;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            ResolvedPropertyModel strategy = (ResolvedPropertyModel)element$iv;
            boolean bl2 = false;
            List<GradlePropertyModel> list3 = strategy.toList();
            if (Intrinsics.areEqual((Object)(list3 != null && (list3 = (GradlePropertyModel)CollectionsKt.firstOrNull(list3)) != null ? list3.toString() : null), (Object)targetDimension.getName())) return false;
            bl = true;
        } while (bl);
        return false;
    }

    private static final PsGeneralIssue analyzeModuleDependency$lambda$0$analyzeFlavorDimensions$4(PsPathRenderer $this_with, PsAndroidModule $sourceModule, PsAndroidModule $targetModule, PsDeclaredModuleAndroidDependency $dependency, PsFlavorDimension targetDimension) {
        Intrinsics.checkNotNullParameter((Object)targetDimension, (String)"targetDimension");
        String string = "No flavor dimension in module '" + $this_with.renderNavigation((PsPath)$sourceModule.getPath(), PsAndroidModuleVariantsAnalyzerKt::analyzeModuleDependency$lambda$0$analyzeFlavorDimensions$4$0) + "' matches dimension '" + PsPathRenderer.renderNavigation$default($this_with, targetDimension.getPath(), null, 1, null) + "' from module " + $this_with.renderNavigation((PsPath)$targetModule.getPath(), PsAndroidModuleVariantsAnalyzerKt::analyzeModuleDependency$lambda$0$analyzeFlavorDimensions$4$1) + " on which module '" + $this_with.renderNavigation($sourceModule.getPath(), $dependency.getPath()) + "' depends.";
        PsPath psPath = $dependency.getPath();
        PsIssueType psIssueType = PsIssueType.PROJECT_ANALYSIS;
        Intrinsics.checkNotNullExpressionValue((Object)psIssueType, (String)"PROJECT_ANALYSIS");
        return new PsGeneralIssue(string, psPath, psIssueType, PsIssue.Severity.ERROR, null);
    }

    private static final PsPath analyzeModuleDependency$lambda$0$analyzeFlavorDimensions$4$0(PsModulePath $this$renderNavigation) {
        Intrinsics.checkNotNullParameter((Object)$this$renderNavigation, (String)"$this$renderNavigation");
        return $this$renderNavigation.getProductFlavorsPath();
    }

    private static final PsPath analyzeModuleDependency$lambda$0$analyzeFlavorDimensions$4$1(PsModulePath $this$renderNavigation) {
        Intrinsics.checkNotNullParameter((Object)$this$renderNavigation, (String)"$this$renderNavigation");
        return $this$renderNavigation.getProductFlavorsPath();
    }

    private static final boolean analyzeProductFlavors$lambda$0$0(PsProductFlavor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getEffectiveDimension() == null;
    }

    private static final PsGeneralIssue analyzeProductFlavors$lambda$0$1(PsPathRenderer $this_with, PsProductFlavor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String configuredFlavorDimension = ParsedValueKt.getMaybeValue(it.getConfiguredDimension());
        CharSequence charSequence = configuredFlavorDimension;
        String string = charSequence == null || charSequence.length() == 0 ? "Flavor '" + PsPathRenderer.renderNavigation$default($this_with, it.getPath(), null, 1, null) + "' has no flavor dimension." : "Flavor '" + PsPathRenderer.renderNavigation$default($this_with, it.getPath(), null, 1, null) + "' has unknown dimension '" + configuredFlavorDimension + "'.";
        PsPath psPath = it.getPath();
        PsIssueType psIssueType = PsIssueType.PROJECT_ANALYSIS;
        Intrinsics.checkNotNullExpressionValue((Object)psIssueType, (String)"PROJECT_ANALYSIS");
        return new PsGeneralIssue(string, psPath, psIssueType, PsIssue.Severity.ERROR, null);
    }
}

