/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon.analysis;

import com.android.tools.idea.gradle.model.IdeSyncIssue;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssues;
import com.android.tools.idea.gradle.structure.model.PsGeneralIssue;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u001a$\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000f0\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"URL_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "createIssueFrom", "Lcom/android/tools/idea/gradle/structure/model/PsIssue;", "syncIssue", "Lcom/android/tools/idea/gradle/model/IdeSyncIssue;", "path", "Lcom/android/tools/idea/gradle/structure/model/PsPath;", "getSeverity", "Lcom/android/tools/idea/gradle/structure/model/PsIssue$Severity;", "issue", "transferSyncIssues", "", "", "", "syncIssues", "Lcom/android/tools/idea/gradle/project/sync/issues/SyncIssues;", "intellij.android.projectSystem.gradle.psd"})
@SourceDebugExtension(value={"SMAP\nPsAndroidModuleAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsAndroidModuleAnalyzer.kt\ncom/android/tools/idea/gradle/structure/daemon/analysis/PsAndroidModuleAnalyzerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,182:1\n774#2:183\n865#2,2:184\n1491#2:186\n1516#2,3:187\n1519#2,3:197\n382#3,7:190\n*S KotlinDebug\n*F\n+ 1 PsAndroidModuleAnalyzer.kt\ncom/android/tools/idea/gradle/structure/daemon/analysis/PsAndroidModuleAnalyzerKt\n*L\n181#1:183\n181#1:184,2\n181#1:186\n181#1:187,3\n181#1:197,3\n181#1:190,7\n*E\n"})
public final class PsAndroidModuleAnalyzerKt {
    private static final Pattern URL_PATTERN = Pattern.compile("\\(?http://[-A-Za-z0-9+&@#/%?=~_()|!:,.;]*[-A-Za-z0-9+&@#/%=~_()|]");

    @VisibleForTesting
    @NotNull
    public static final PsIssue createIssueFrom(@NotNull IdeSyncIssue syncIssue, @NotNull PsPath path) {
        Intrinsics.checkNotNullParameter((Object)syncIssue, (String)"syncIssue");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String message = XmlStringUtil.escapeString((String)syncIssue.getMessage());
        Matcher matcher = URL_PATTERN.matcher(message);
        boolean result2 = matcher.find();
        while (result2) {
            String url = matcher.group();
            String string = message;
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNull((Object)url);
            message = StringsKt.replace$default((String)string, (String)url, (String)("<a href='" + url + "'>" + url + "</a>"), (boolean)false, (int)4, null);
            result2 = matcher.find();
        }
        String string = message;
        Intrinsics.checkNotNull((Object)string);
        PsIssueType psIssueType = PsIssueType.PROJECT_ANALYSIS;
        Intrinsics.checkNotNullExpressionValue((Object)psIssueType, (String)"PROJECT_ANALYSIS");
        return new PsGeneralIssue(string, path, psIssueType, PsAndroidModuleAnalyzerKt.getSeverity(syncIssue), null, 16, null);
    }

    private static final PsIssue.Severity getSeverity(IdeSyncIssue issue2) {
        switch (issue2.getSeverity()) {
            case 2: {
                return PsIssue.Severity.ERROR;
            }
            case 1: {
                return PsIssue.Severity.WARNING;
            }
        }
        return PsIssue.Severity.INFO;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, List<IdeSyncIssue>> transferSyncIssues(SyncIssues syncIssues) {
        Map map2;
        Object object;
        SyncIssues syncIssues2 = syncIssues;
        if (syncIssues2 != null) {
            void $this$groupByTo$iv$iv;
            IdeSyncIssue it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = syncIssues2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (IdeSyncIssue)element$iv$iv;
                boolean bl = false;
                CharSequence charSequence = it.getData();
                if (!(!(charSequence == null || charSequence.length() == 0))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$groupBy$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$filterTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                String key$iv$iv;
                it = (IdeSyncIssue)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it.getData());
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            object = destination$iv$iv;
        } else {
            object = map2 = null;
        }
        if (object == null) {
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    public static final /* synthetic */ Map access$transferSyncIssues(SyncIssues syncIssues) {
        return PsAndroidModuleAnalyzerKt.transferSyncIssues(syncIssues);
    }
}

