/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon;

import com.android.annotations.concurrency.UiThread;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0004J\u0006\u0010\u0018\u001a\u00020\u0019J!\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u001b\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u0019J!\u0010\u001d\u001a\u00020\u00192\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u001b\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001e\u001a\u00020\u0019H\u0016R\u0014\u0010\u0002\u001a\u00020\u0001X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000e8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u000e8G\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsDaemon;", "Lcom/intellij/openapi/Disposable;", "parentDisposable", "<init>", "(Lcom/intellij/openapi/Disposable;)V", "getParentDisposable", "()Lcom/intellij/openapi/Disposable;", "mainQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getMainQueue", "()Lcom/intellij/util/ui/update/MergingUpdateQueue;", "resultsUpdaterQueue", "getResultsUpdaterQueue", "isStopped", "", "()Z", "isRunning", "stopped", "Ljava/util/concurrent/atomic/AtomicBoolean;", "createQueue", "name", "", "modalityStateComponent", "Ljavax/swing/JComponent;", "reset", "", "queues", "", "([Lcom/intellij/util/ui/update/MergingUpdateQueue;)V", "stop", "dispose", "intellij.android.projectSystem.gradle.psd"})
public abstract class PsDaemon
implements Disposable {
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final AtomicBoolean stopped;

    protected PsDaemon(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.parentDisposable = parentDisposable;
        this.stopped = new AtomicBoolean(false);
        Disposer.register((Disposable)this.parentDisposable, (Disposable)this);
    }

    @NotNull
    protected final Disposable getParentDisposable() {
        return this.parentDisposable;
    }

    @NotNull
    protected abstract MergingUpdateQueue getMainQueue();

    @NotNull
    protected abstract MergingUpdateQueue getResultsUpdaterQueue();

    protected final boolean isStopped() {
        return this.stopped.get();
    }

    @UiThread
    public final boolean isRunning() {
        return !this.getMainQueue().isEmpty() || this.getMainQueue().isFlushing() || !this.getResultsUpdaterQueue().isEmpty();
    }

    @NotNull
    protected final MergingUpdateQueue createQueue(@NotNull String name2, @Nullable JComponent modalityStateComponent) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return new MergingUpdateQueue(name2, 300, false, modalityStateComponent, (Disposable)this, null, modalityStateComponent != null ? Alarm.ThreadToUse.SWING_THREAD : Alarm.ThreadToUse.POOLED_THREAD, null, 128, null);
    }

    public final void reset() {
        MergingUpdateQueue[] mergingUpdateQueueArray = new MergingUpdateQueue[]{this.getMainQueue(), this.getResultsUpdaterQueue()};
        this.reset(mergingUpdateQueueArray);
        this.getMainQueue().queue(new Update(this){
            final /* synthetic */ PsDaemon this$0;
            {
                this.this$0 = $receiver;
                super((Object)"reset", false, 0, 6, null);
            }

            public void run() {
                PsDaemon.access$getStopped$p(this.this$0).set(false);
            }
        });
    }

    private final void reset(MergingUpdateQueue ... queues) {
        for (MergingUpdateQueue queue : queues) {
            queue.activate();
        }
    }

    public final void stop() {
        this.stopped.set(true);
        MergingUpdateQueue[] mergingUpdateQueueArray = new MergingUpdateQueue[]{this.getMainQueue(), this.getResultsUpdaterQueue()};
        this.stop(mergingUpdateQueueArray);
    }

    private final void stop(MergingUpdateQueue ... queues) {
        for (MergingUpdateQueue queue : queues) {
            queue.cancelAllUpdates();
            queue.deactivate();
        }
    }

    public void dispose() {
        this.stop();
    }

    public static final /* synthetic */ AtomicBoolean access$getStopped$p(PsDaemon $this) {
        return $this.stopped;
    }
}

