/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.actions;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.GradleProjectSystem;
import com.android.tools.idea.structure.dialog.ProjectStructureConfigurable;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ShowStructureSettingsAction;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import org.jetbrains.annotations.NotNull;

public class AndroidShowStructureSettingsAction
extends ShowStructureSettingsAction {
    public AndroidShowStructureSettingsAction() {
        Presentation templatePresentation = this.getTemplatePresentation();
        templatePresentation.setIcon(AllIcons.General.ProjectStructure);
        templatePresentation.setText(ActionsBundle.actionText((String)"ShowProjectStructureSettings"));
        templatePresentation.setDescription(ActionsBundle.actionDescription((String)"ShowProjectStructureSettings"));
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        presentation.setEnabledAndVisible(e.getProject() != null);
        if (project == null || !TrustedProjects.isProjectTrusted((Project)project)) {
            presentation.setEnabled(false);
        }
        super.update(e);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null && IdeInfo.getInstance().isAndroidStudio()) {
            project = ProjectManager.getInstance().getDefaultProject();
            AndroidShowStructureSettingsAction.showAndroidProjectStructure(project);
            return;
        }
        if (project != null && ProjectSystemUtil.getProjectSystem(project) instanceof GradleProjectSystem) {
            AndroidShowStructureSettingsAction.showAndroidProjectStructure(project);
            return;
        }
        super.actionPerformed(e);
    }

    private static void showAndroidProjectStructure(@NotNull Project project) {
        ProjectStructureConfigurable.getInstance(project).show();
    }
}

