/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.gradle.structure.ProjectConfigurationError;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.android.tools.sdk.AndroidSdkData;
import com.android.tools.sdk.AndroidSdkPath;
import com.android.tools.sdk.SdkPaths;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeSdksConfigurable
implements Place.Navigator,
Configurable {
    @NonNls
    private static final String SDKS_PLACE = "sdks.place";
    @NonNls
    public static final String IDE_SDKS_LOCATION_VIEW = "IdeSdksView";
    private static final String CHOOSE_VALID_SDK_DIRECTORY_ERR = "Please choose a valid Android SDK directory.";
    @NotNull
    private final BiMap<String, Component> myComponentsById = HashBiMap.create();
    @Nullable
    private String myOriginalSdkHomePath;
    private TextFieldWithBrowseButton mySdkLocationTextField;
    private JPanel myWholePanel;
    private final DetailsComponent myDetailsComponent;
    private History myHistory;
    private String mySelectedComponentId;

    public IdeSdksConfigurable() {
        this.setupUI();
        this.myWholePanel.setPreferredSize((Dimension)JBUI.size((int)700, (int)500));
        this.myWholePanel.setName(IDE_SDKS_LOCATION_VIEW);
        this.myDetailsComponent = new DetailsComponent(false, false);
        this.myDetailsComponent.setContent((JComponent)this.myWholePanel);
        FocusAdapter historyUpdater = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (IdeSdksConfigurable.this.myHistory != null) {
                    String id2;
                    IdeSdksConfigurable.this.mySelectedComponentId = id2 = (String)IdeSdksConfigurable.this.myComponentsById.inverse().get((Object)e.getComponent());
                    if (id2 != null) {
                        IdeSdksConfigurable.this.myHistory.pushQueryPlace();
                    }
                }
            }
        };
        this.addHistoryUpdater("mySdkLocationTextField", this.mySdkLocationTextField.getTextField(), historyUpdater);
    }

    private void addHistoryUpdater(@NotNull String id2, @NotNull Component c, @NotNull FocusListener historyUpdater) {
        this.myComponentsById.put((Object)id2, (Object)c);
        c.addFocusListener(historyUpdater);
    }

    public void reset() {
        this.myOriginalSdkHomePath = IdeSdksConfigurable.getIdeAndroidSdkPath();
        this.mySdkLocationTextField.setText(this.myOriginalSdkHomePath);
    }

    public void apply() throws ConfigurationException {
        if (!this.isModified()) {
            return;
        }
        List<ProjectConfigurationError> errors = this.validateState();
        if (!errors.isEmpty()) {
            throw new ConfigurationException(errors.get(0).getDescription().toString());
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            IdeSdks ideSdks = IdeSdks.getInstance();
            ideSdks.setAndroidSdkPath(this.getSdkLocation());
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                IdeSdks.updateWelcomeRunAndroidSdkAction();
            }
        });
    }

    private void createUIComponents() {
        this.createSdkLocationTextField();
    }

    private void setupUI() {
        this.createUIComponents();
        this.myWholePanel = new JPanel();
        this.myWholePanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(24, 20, 0, 20), 0, 0));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 2));
        this.myWholePanel.add((Component)panel1, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null, 0, false));
        panel1.add((Component)this.mySdkLocationTextField, new GridConstraints(1, 0, 1, 1, 9, 0, 5, 3, new Dimension(518, -1), null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 3, 0, 0), -1, -1));
        panel1.add((Component)panel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        label1.setText("<html><b>Android SDK location</b><br> This location will be used for new projects and for existing projects that do not have a local.properties file with a sdk.dir property.</html>");
        panel2.add((Component)label1, new GridConstraints(0, 0, 1, 1, 9, 0, 5, 3, null, null, null, 0, false));
    }

    private static void copyItemToToolTip(@NotNull JComboBox comboBox2) {
        Object item = comboBox2.getEditor().getItem();
        if (item != null) {
            comboBox2.setToolTipText(item.toString());
        } else {
            comboBox2.setToolTipText("");
        }
    }

    private static void setComboBoxFile(@NotNull JComboBox comboBox2, @NotNull Path file) {
        IdeSdksConfigurable.setComboBoxPath(comboBox2, file.toString());
    }

    private static void setComboBoxPath(@NotNull JComboBox comboBox2, @NotNull String path) {
        comboBox2.setSelectedItem(FileUtilRt.toSystemDependentName((String)path));
    }

    private void createSdkLocationTextField() {
        FileChooserDescriptor descriptor2 = IdeSdksConfigurable.createSingleFolderDescriptor("Choose Android SDK Location", (Function<File, Void>)((Function)file -> {
            SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidSdk(file.toPath(), false);
            if (!validationResult.success) {
                String msg = validationResult.message;
                if (StringUtil.isEmpty((String)msg)) {
                    msg = CHOOSE_VALID_SDK_DIRECTORY_ERR;
                }
                throw new IllegalArgumentException(msg);
            }
            return null;
        }));
        final JTextField textField2 = new JTextField(67);
        this.mySdkLocationTextField = new TextFieldWithBrowseButton(textField2, e -> {
            VirtualFile chosen;
            VirtualFile suggestedDir = null;
            File sdkLocation = this.getSdkLocation();
            if (sdkLocation.isDirectory()) {
                suggestedDir = VfsUtil.findFileByIoFile((File)sdkLocation, (boolean)false);
            }
            if ((chosen = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, null, (VirtualFile)suggestedDir)) != null) {
                File f = VfsUtilCore.virtualToIoFile((VirtualFile)chosen);
                textField2.setText(FileUtilRt.toSystemDependentName((String)f.getPath()));
            }
        });
        textField2.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateToolTip();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateToolTip();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateToolTip();
            }

            private void updateToolTip() {
                textField2.setToolTipText(textField2.getText());
            }
        });
    }

    @NotNull
    private static FileChooserDescriptor createSingleFolderDescriptor(@NotNull String title2, final @NotNull Function<File, Void> validation2) {
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(false, true, false, false, false, false){

            public void validateSelectedFiles(@NotNull @NotNull VirtualFile @NotNull [] files2) {
                for (VirtualFile virtualFile : files2) {
                    File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                    validation2.fun((Object)file);
                }
            }
        };
        if (SystemInfo.isMac) {
            descriptor2.withShowHiddenFiles(true);
        }
        descriptor2.setTitle(title2);
        return descriptor2;
    }

    public String getDisplayName() {
        return "SDK Location";
    }

    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.myDetailsComponent.getComponent();
    }

    public boolean isModified() {
        return !Objects.equals(this.myOriginalSdkHomePath, this.getSdkLocation().getPath());
    }

    @Nullable
    private static Sdk getFirstDefaultAndroidSdk() {
        IdeSdks ideSdks = IdeSdks.getInstance();
        List<Sdk> allAndroidSdks = ideSdks.getEligibleAndroidSdks();
        if (!allAndroidSdks.isEmpty()) {
            return allAndroidSdks.get(0);
        }
        AndroidSdkData sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (sdkData == null) {
            return null;
        }
        List<Sdk> sdks = ideSdks.createAndroidSdkPerAndroidTarget(sdkData.getLocationFile());
        return !sdks.isEmpty() ? sdks.get(0) : null;
    }

    @NotNull
    private static String getIdeAndroidSdkPath() {
        String sdkHome;
        File path = IdeSdks.getInstance().getAndroidSdkPath();
        if (path != null) {
            return path.getPath();
        }
        Sdk sdk = IdeSdksConfigurable.getFirstDefaultAndroidSdk();
        if (sdk != null && (sdkHome = sdk.getHomePath()) != null) {
            return FileUtilRt.toSystemDependentName((String)sdkHome);
        }
        return "";
    }

    @NotNull
    private File getSdkLocation() {
        String sdkLocation = this.mySdkLocationTextField.getText();
        return FilePaths.stringToFile((String)sdkLocation);
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        Component toFocus = (Component)this.myComponentsById.get((Object)this.mySelectedComponentId);
        return toFocus instanceof JComponent ? (JComponent)toFocus : this.mySdkLocationTextField.getTextField();
    }

    public boolean validate() throws ConfigurationException {
        String msg = this.validateAndroidSdkPath();
        if (msg != null) {
            throw new ConfigurationException(msg);
        }
        return true;
    }

    @NotNull
    public List<ProjectConfigurationError> validateState() {
        ArrayList<ProjectConfigurationError> errors = new ArrayList<ProjectConfigurationError>();
        String msg = this.validateAndroidSdkPath();
        if (msg != null) {
            ProjectConfigurationError error = new ProjectConfigurationError(msg, this.mySdkLocationTextField.getTextField());
            errors.add(error);
        }
        return errors;
    }

    @Nullable
    private String validateAndroidSdkPath() {
        Validator.Result result2 = PathValidator.forAndroidSdkLocation().validate(this.getSdkLocation().toPath());
        Validator.Severity severity = result2.getSeverity();
        if (severity == Validator.Severity.ERROR) {
            return result2.getMessage();
        }
        SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidSdk(this.getSdkLocation().toPath(), false);
        if (!validationResult.success) {
            String msg = validationResult.message;
            if (StringUtil.isEmpty((String)msg)) {
                msg = CHOOSE_VALID_SDK_DIRECTORY_ERR;
            }
            return msg;
        }
        return null;
    }

    public static boolean isNeeded() {
        String sdkPath = IdeSdksConfigurable.getIdeAndroidSdkPath();
        boolean validSdk = !sdkPath.isEmpty() && AndroidSdkPath.isValid(new File(sdkPath));
        return !validSdk;
    }

    public void setHistory(History history) {
        this.myHistory = history;
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        Object path;
        if (place != null && (path = place.getPath(SDKS_PLACE)) instanceof String) {
            Component c = (Component)this.myComponentsById.get(path);
            if (requestFocus && c != null) {
                c.requestFocusInWindow();
            }
        }
        return ActionCallback.DONE;
    }

    public void queryPlace(@NotNull Place place) {
        place.putPath(SDKS_PLACE, (Object)this.mySelectedComponentId);
    }
}

