/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification;

import com.android.tools.idea.gradle.project.sync.jdk.GradleJdkValidationManager;
import com.android.tools.idea.gradle.project.sync.jdk.exceptions.base.GradleJdkException;
import com.android.tools.idea.gradle.service.notification.OpenProjectJdkLocationListener;
import com.android.tools.idea.gradle.service.notification.UseJdkAsProjectJdkListener;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.utils.FileUtils;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.notification.GradleNotificationExtension;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/gradle/service/notification/GradleJvmNotificationExtension;", "Lorg/jetbrains/plugins/gradle/service/notification/GradleNotificationExtension;", "<init>", "()V", "customize", "", "notificationData", "Lcom/intellij/openapi/externalSystem/service/notification/NotificationData;", "project", "Lcom/intellij/openapi/project/Project;", "externalProjectPath", "", "error", "", "intellij.android.projectSystem.gradle"})
public final class GradleJvmNotificationExtension
extends GradleNotificationExtension {
    public void customize(@NotNull NotificationData notificationData, @NotNull Project project, @NotNull String externalProjectPath, @Nullable Throwable error) {
        block8: {
            UseJdkAsProjectJdkListener listener2;
            String defaultPath;
            Sdk defaultJdk;
            String absolutePath;
            UseJdkAsProjectJdkListener listener3;
            String expectedJvmInvalidPrefix;
            block7: {
                Intrinsics.checkNotNullParameter((Object)notificationData, (String)"notificationData");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
                super.customize(notificationData, project, externalProjectPath, error);
                expectedJvmInvalidPrefix = GradleBundle.message((String)"gradle.jvm.is.invalid", (Object[])new Object[0]);
                String expectedJvmIsJrePrefix = GradleBundle.message((String)"gradle.jvm.is.jre", (Object[])new Object[0]);
                String string = notificationData.getMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
                Intrinsics.checkNotNull((Object)expectedJvmInvalidPrefix);
                if (StringsKt.startsWith$default((String)string, (String)expectedJvmInvalidPrefix, (boolean)false, (int)2, null)) break block7;
                String string2 = notificationData.getMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMessage(...)");
                Intrinsics.checkNotNull((Object)expectedJvmIsJrePrefix);
                if (!StringsKt.startsWith$default((String)string2, (String)expectedJvmIsJrePrefix, (boolean)false, (int)2, null)) break block8;
            }
            IdeSdks ideSdks = IdeSdks.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)ideSdks, (String)"getInstance(...)");
            IdeSdks ideSdks2 = ideSdks;
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append(expectedJvmInvalidPrefix).append('\n');
            GradleJdkException gradleJdkException = GradleJdkValidationManager.Companion.getInstance(project).validateProjectGradleJvmPath(project, externalProjectPath);
            if (gradleJdkException != null) {
                GradleJdkException exception = gradleJdkException;
                boolean bl = false;
                messageBuilder.append(exception.getMessage()).append('\n');
                File file = exception.getJdkPathLocationFile();
                notificationData.setFilePath(file != null ? file.getAbsolutePath() : null);
            }
            List registeredListeners = notificationData.getRegisteredListenerIds();
            Path path = ideSdks2.getEmbeddedJdkPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getEmbeddedJdkPath(...)");
            Path embeddedJdkPath = path;
            if (ideSdks2.validateJdkPath(embeddedJdkPath) != null && !registeredListeners.contains((listener3 = new UseJdkAsProjectJdkListener(project, absolutePath = ((Object)embeddedJdkPath.toAbsolutePath()).toString(), ".embedded")).getId())) {
                messageBuilder.append("<a href=\"" + listener3.getId() + "\">Use Embedded JDK (" + absolutePath + ")</a>").append('\n');
                notificationData.setListener(listener3.getId(), (NotificationListener)listener3);
                registeredListeners = notificationData.getRegisteredListenerIds();
            }
            Sdk sdk = defaultJdk = ideSdks2.getJdk();
            String string = defaultPath = sdk != null ? sdk.getHomePath() : null;
            if (defaultPath != null && ideSdks2.validateJdkPath(Paths.get(defaultPath, new String[0])) != null && !FileUtils.isSameFile((File)embeddedJdkPath.toFile(), (File)new File(defaultPath)) && !registeredListeners.contains((listener2 = new UseJdkAsProjectJdkListener(project, defaultPath, null, 4, null)).getId())) {
                messageBuilder.append("<a href=\"" + listener2.getId() + "\">Use JDK " + defaultJdk.getName() + " (" + defaultPath + ")</a>").append('\n');
                notificationData.setListener(listener2.getId(), (NotificationListener)listener2);
                registeredListeners = notificationData.getRegisteredListenerIds();
            }
            if (registeredListeners != null && !registeredListeners.contains("open.project.jdk.location")) {
                OpenProjectJdkLocationListener openProjectJdkLocationListener = OpenProjectJdkLocationListener.Companion.create(project, externalProjectPath);
                if (openProjectJdkLocationListener != null) {
                    OpenProjectJdkLocationListener listener4 = openProjectJdkLocationListener;
                    boolean bl = false;
                    messageBuilder.append("<a href=\"open.project.jdk.location\">Change Gradle JDK location</a>").append('\n');
                    notificationData.setListener("open.project.jdk.location", (NotificationListener)listener4);
                }
            }
            String string3 = messageBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            notificationData.setMessage(((Object)StringsKt.trim((CharSequence)string3)).toString());
        }
    }
}

