/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.repositories.search;

import com.android.ide.common.repository.SdkMavenRepository;
import com.android.tools.idea.gradle.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.repositories.search.LocalMavenRepository;
import com.android.tools.idea.sdk.IdeSdks;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidSdkRepositories {
    public static final String ANDROID_REPOSITORY_NAME = "Android Repository";
    public static final String GOOGLE_REPOSITORY_NAME = "Google Repository";

    private AndroidSdkRepositories() {
    }

    @Nullable
    public static ArtifactRepository getAndroidRepository() {
        return AndroidSdkRepositories.getMavenRepository(SdkMavenRepository.ANDROID, ANDROID_REPOSITORY_NAME);
    }

    @Nullable
    public static ArtifactRepository getGoogleRepository() {
        return AndroidSdkRepositories.getMavenRepository(SdkMavenRepository.GOOGLE, GOOGLE_REPOSITORY_NAME);
    }

    @Nullable
    private static ArtifactRepository getMavenRepository(@NotNull SdkMavenRepository repository2, @NotNull String name2) {
        Path location = AndroidSdkRepositories.getRepositoryLocation(repository2);
        return location != null ? new LocalMavenRepository(location.toFile(), name2) : null;
    }

    @Nullable
    private static Path getRepositoryLocation(@NotNull SdkMavenRepository repository2) {
        File androidSdkPath = IdeSdks.getInstance().getAndroidSdkPath();
        if (androidSdkPath == null) {
            return null;
        }
        return repository2.getRepositoryLocation(androidSdkPath.toPath(), true);
    }
}

