/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.upgrade;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.analytics.UsageTrackerUtils;
import com.android.tools.idea.gradle.project.upgrade.DeprecatedAgpUpgradeWarning;
import com.android.tools.idea.gradle.project.upgrade.GradlePluginUpgrade;
import com.android.tools.idea.gradle.project.upgrade.ProjectUpgradeNotificationKt;
import com.android.tools.idea.gradle.project.upgrade.RecommendedUpgradeReminder;
import com.android.tools.idea.gradle.project.upgrade.UpgradeSuggestion;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 !2\u00020\u0001:\u0001!B!\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\nJ\b\u0010 \u001a\u00020\u001bH\u0002R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u0082\u0001\u0002\"#\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/gradle/project/upgrade/ProjectUpgradeNotification;", "Lcom/intellij/notification/Notification;", "title", "", "content", "type", "Lcom/intellij/notification/NotificationType;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/notification/NotificationType;)V", "callToActionDismissed", "", "getCallToActionDismissed", "()Z", "setCallToActionDismissed", "(Z)V", "studioEventSent", "getStudioEventSent", "setStudioEventSent", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "currentAgpVersion", "Lcom/android/ide/common/repository/AgpVersion;", "getCurrentAgpVersion", "()Lcom/android/ide/common/repository/AgpVersion;", "setBalloon", "", "balloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "expire", "dismissed", "maybeFireOldAgpCtaDismissedEvent", "Companion", "Lcom/android/tools/idea/gradle/project/upgrade/DeprecatedAgpUpgradeWarning;", "Lcom/android/tools/idea/gradle/project/upgrade/UpgradeSuggestion;", "intellij.android.projectSystem.gradle.upgrade"})
public abstract sealed class ProjectUpgradeNotification
extends Notification
permits DeprecatedAgpUpgradeWarning, UpgradeSuggestion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean callToActionDismissed;
    private boolean studioEventSent;
    @NotNull
    private static final AgpVersion OLD_AGP_VERSION = AgpVersion.Companion.parse("7.0.0");

    private ProjectUpgradeNotification(String title2, String content2, NotificationType type) {
        super("Android Gradle Upgrade Notification", title2, content2, type);
        this.addAction(new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.expire(false);
                    ProjectUpgradeNotificationKt.access$getLOG$p().info("Starting AGP Upgrade Assistant");
                    Project project = e.getProject();
                    if (project == null) break block0;
                    Project it = project;
                    boolean bl = false;
                    GradlePluginUpgrade.performRecommendedPluginUpgrade$default(it, null, null, 6, null);
                }
            }
        });
        this.addAction(new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.expire(false);
                    ProjectUpgradeNotificationKt.access$getLOG$p().info("AGP Upgrade notification postponed for 24 hours");
                    Project project = e.getProject();
                    if (project == null) break block0;
                    Project it = project;
                    boolean bl = false;
                    new RecommendedUpgradeReminder(it).updateLastTimestamp();
                }
            }
        });
        this.addAction(new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.expire(true);
                    ProjectUpgradeNotificationKt.access$getLOG$p().info("AGP Upgrade notification disabled for this project");
                    Project project = e.getProject();
                    if (project == null) break block0;
                    Project it = project;
                    boolean bl = false;
                    new RecommendedUpgradeReminder(it).setDoNotAskForProject(true);
                }
            }
        });
        this.addAction(new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.expire(true);
                    ProjectUpgradeNotificationKt.access$getLOG$p().info("AGP Upgrade notification disabled application-wide");
                    Project project = e.getProject();
                    if (project == null) break block0;
                    Project it = project;
                    boolean bl = false;
                    new RecommendedUpgradeReminder(it).setDoNotAskForApplication(true);
                }
            }
        });
    }

    public final boolean getCallToActionDismissed() {
        return this.callToActionDismissed;
    }

    public final void setCallToActionDismissed(boolean bl) {
        this.callToActionDismissed = bl;
    }

    public final boolean getStudioEventSent() {
        return this.studioEventSent;
    }

    public final void setStudioEventSent(boolean bl) {
        this.studioEventSent = bl;
    }

    @NotNull
    public abstract Project getProject();

    @NotNull
    public abstract AgpVersion getCurrentAgpVersion();

    public void setBalloon(@NotNull Balloon balloon) {
        Intrinsics.checkNotNullParameter((Object)balloon, (String)"balloon");
        super.setBalloon(balloon);
        balloon.addListener(new JBPopupListener(this){
            final /* synthetic */ ProjectUpgradeNotification this$0;
            {
                this.this$0 = $receiver;
            }

            public void onClosed(LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ProjectUpgradeNotification.access$maybeFireOldAgpCtaDismissedEvent(this.this$0);
            }
        });
    }

    public void expire() {
        if (!this.isExpired()) {
            this.maybeFireOldAgpCtaDismissedEvent();
        }
        super.expire();
    }

    public final void expire(boolean dismissed) {
        this.callToActionDismissed = dismissed;
        this.expire();
    }

    private final void maybeFireOldAgpCtaDismissedEvent() {
        if (this.callToActionDismissed && this.getCurrentAgpVersion().compareTo(OLD_AGP_VERSION) < 0 && !this.studioEventSent) {
            AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PROJECT_SYSTEM).setKind(AndroidStudioEvent.EventKind.UPGRADE_ASSISTANT_CTA_OLD_AGP_DISMISSED);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setKind(...)");
            AndroidStudioEvent.Builder studioEvent = UsageTrackerUtils.withProjectId(builder, this.getProject());
            UsageTracker.log((AndroidStudioEvent.Builder)studioEvent);
            this.studioEventSent = true;
        }
    }

    public /* synthetic */ ProjectUpgradeNotification(String title2, String content2, NotificationType type, DefaultConstructorMarker $constructor_marker) {
        this(title2, content2, type);
    }

    public static final /* synthetic */ void access$maybeFireOldAgpCtaDismissedEvent(ProjectUpgradeNotification $this) {
        $this.maybeFireOldAgpCtaDismissedEvent();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/gradle/project/upgrade/ProjectUpgradeNotification$Companion;", "", "<init>", "()V", "OLD_AGP_VERSION", "Lcom/android/ide/common/repository/AgpVersion;", "getOLD_AGP_VERSION", "()Lcom/android/ide/common/repository/AgpVersion;", "intellij.android.projectSystem.gradle.upgrade"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AgpVersion getOLD_AGP_VERSION() {
            return OLD_AGP_VERSION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

