/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.upgrade;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoryModel;
import com.android.tools.idea.gradle.dsl.api.util.GradleDslContextModel;
import com.android.tools.idea.gradle.dsl.api.util.GradleDslModel;
import com.android.tools.idea.gradle.project.upgrade.AddMavenCentralRepositoryUsageInfo;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeBundle;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeComponentRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.RegionNecessity;
import com.android.tools.idea.gradle.project.upgrade.RemoveRepositoryUsageInfo;
import com.android.tools.idea.gradle.project.upgrade.WrappedPsiElement;
import com.google.wireless.android.sdk.stats.UpgradeAssistantComponentInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0001#B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0015\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011H\u0014\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0014J\u001f\u0010\u001b\u001a\u00020\u001c2\u0010\u0010\u001d\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00120\u0011H\u0014\u00a2\u0006\u0002\u0010\u001eR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u001f\u001a\u00020 X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/gradle/project/upgrade/JCenterToMavenCentralRefactoringProcessor;", "Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeComponentRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "current", "Lcom/android/ide/common/repository/AgpVersion;", "new", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/ide/common/repository/AgpVersion;Lcom/android/ide/common/repository/AgpVersion;)V", "processor", "Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeRefactoringProcessor;", "(Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeRefactoringProcessor;)V", "necessityInfo", "Lcom/android/tools/idea/gradle/project/upgrade/RegionNecessity;", "getNecessityInfo", "()Lcom/android/tools/idea/gradle/project/upgrade/RegionNecessity;", "findComponentUsages", "", "Lcom/intellij/usageView/UsageInfo;", "()[Lcom/intellij/usageView/UsageInfo;", "completeComponentInfo", "Lcom/google/wireless/android/sdk/stats/UpgradeAssistantComponentInfo$Builder;", "builder", "getCommandName", "", "getShortDescription", "getRefactoringId", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "usages", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "readMoreUrlRedirect", "Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeComponentRefactoringProcessor$ReadMoreUrlRedirect;", "getReadMoreUrlRedirect", "()Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeComponentRefactoringProcessor$ReadMoreUrlRedirect;", "Companion", "intellij.android.projectSystem.gradle.upgrade"})
@SourceDebugExtension(value={"SMAP\nJCenterToMavenCentralRefactoringProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JCenterToMavenCentralRefactoringProcessor.kt\ncom/android/tools/idea/gradle/project/upgrade/JCenterToMavenCentralRefactoringProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1869#2,2:125\n1869#2,2:128\n1#3:127\n*S KotlinDebug\n*F\n+ 1 JCenterToMavenCentralRefactoringProcessor.kt\ncom/android/tools/idea/gradle/project/upgrade/JCenterToMavenCentralRefactoringProcessor\n*L\n64#1:125,2\n48#1:128,2\n*E\n"})
public final class JCenterToMavenCentralRefactoringProcessor
extends AgpUpgradeComponentRefactoringProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RegionNecessity necessityInfo;
    @NotNull
    private final AgpUpgradeComponentRefactoringProcessor.ReadMoreUrlRedirect readMoreUrlRedirect;
    @NotNull
    private static final AgpVersion SUPPORTED_FROM = AgpVersion.Companion.parse("3.2.0");
    @NotNull
    private static final AgpVersion GRADLE_SUPPORT_REMOVED = AgpVersion.Companion.parse("9.0.0-alpha01");
    @NotNull
    private static final UsageType REMOVE_JCENTER = new UsageType(AgpUpgradeBundle.Companion.messagePointer("jcenterToMavenCentral.removeJCenter.usageType", new Object[0]));
    @NotNull
    private static final UsageType INSERT_MAVEN_CENTRAL = new UsageType(AgpUpgradeBundle.Companion.messagePointer("jcenterToMavenCentral.insertMavenCentral.usageType", new Object[0]));

    public JCenterToMavenCentralRefactoringProcessor(@NotNull Project project, @NotNull AgpVersion current, @NotNull AgpVersion agpVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"new");
        super(project, current, agpVersion);
        this.necessityInfo = new RegionNecessity(SUPPORTED_FROM, GRADLE_SUPPORT_REMOVED);
        this.readMoreUrlRedirect = new AgpUpgradeComponentRefactoringProcessor.ReadMoreUrlRedirect("jcenter-to-maven-central");
    }

    public JCenterToMavenCentralRefactoringProcessor(@NotNull AgpUpgradeRefactoringProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
        super(processor);
        this.necessityInfo = new RegionNecessity(SUPPORTED_FROM, GRADLE_SUPPORT_REMOVED);
        this.readMoreUrlRedirect = new AgpUpgradeComponentRefactoringProcessor.ReadMoreUrlRedirect("jcenter-to-maven-central");
    }

    @Override
    @NotNull
    public RegionNecessity getNecessityInfo() {
        return this.necessityInfo;
    }

    @Override
    @NotNull
    protected UsageInfo[] findComponentUsages() {
        GradleDslModel gradleDslModel;
        GradleDslModel gradleDslModel2;
        Object p0;
        List usages = new ArrayList();
        List<GradleBuildModel> list2 = this.getProjectBuildModel().getAllIncludedBuildModels();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getAllIncludedBuildModels(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GradleBuildModel model = (GradleBuildModel)element$iv;
            boolean bl = false;
            RepositoriesModel repositoriesModel = model.repositories();
            Intrinsics.checkNotNullExpressionValue((Object)repositoriesModel, (String)"repositories(...)");
            JCenterToMavenCentralRefactoringProcessor.findComponentUsages$process(this, usages, repositoriesModel);
        }
        GradleDslContextModel gradleDslContextModel = this.getProjectBuildModel().getProjectBuildModel();
        if (gradleDslContextModel != null && (gradleDslContextModel = gradleDslContextModel.buildscript()) != null && (gradleDslContextModel = gradleDslContextModel.repositories()) != null) {
            p0 = gradleDslContextModel;
            boolean bl = false;
            JCenterToMavenCentralRefactoringProcessor.findComponentUsages$process(this, usages, (RepositoriesModel)p0);
        }
        if ((gradleDslModel2 = this.getProjectBuildModel().getProjectSettingsModel()) != null && (gradleDslModel2 = gradleDslModel2.dependencyResolutionManagement()) != null && (gradleDslModel2 = gradleDslModel2.repositories()) != null) {
            p0 = gradleDslModel2;
            boolean bl = false;
            JCenterToMavenCentralRefactoringProcessor.findComponentUsages$process(this, usages, (RepositoriesModel)p0);
        }
        if ((gradleDslModel = this.getProjectBuildModel().getProjectSettingsModel()) != null && (gradleDslModel = gradleDslModel.pluginManagement()) != null && (gradleDslModel = gradleDslModel.repositories()) != null) {
            p0 = gradleDslModel;
            boolean bl = false;
            JCenterToMavenCentralRefactoringProcessor.findComponentUsages$process(this, usages, (RepositoriesModel)p0);
        }
        Collection collection2 = usages;
        Intrinsics.checkNotNullExpressionValue((Object)UsageInfo.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return (UsageInfo[])UtilKt.toArray((Collection)collection2, (Object[])UsageInfo.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public UpgradeAssistantComponentInfo.Builder completeComponentInfo(@NotNull UpgradeAssistantComponentInfo.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        UpgradeAssistantComponentInfo.Builder builder2 = builder.setKind(UpgradeAssistantComponentInfo.UpgradeAssistantComponentKind.JCENTER_TO_MAVEN_CENTRAL);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"setKind(...)");
        return builder2;
    }

    @Override
    @NotNull
    public String getCommandName() {
        return AgpUpgradeBundle.Companion.message("jcenterToMavenCentral.commandName", new Object[0]);
    }

    @Override
    @NotNull
    public String getShortDescription() {
        return "As of Gradle 9.0 and the Android Gradle Plugin version 9.0.0, the `jcenter()`\nrepository declaration is no longer supported.  The jcenter repository itself\nhas been in read-only mode since 2021.  This processor removes uses of `jcenter`\nand, if any of those are found, adds a mavenCentral repository declaration if\none is not already present.";
    }

    @NotNull
    protected String getRefactoringId() {
        return "con.android.tools.agp.upgrade.jcenterToMavenCentral";
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        return (UsageViewDescriptor)new UsageViewDescriptorAdapter(){

            public PsiElement[] getElements() {
                Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return AgpUpgradeBundle.Companion.message("jcenterToMavenCentral.usageView.header", new Object[0]);
            }
        };
    }

    @Override
    @NotNull
    protected AgpUpgradeComponentRefactoringProcessor.ReadMoreUrlRedirect getReadMoreUrlRedirect() {
        return this.readMoreUrlRedirect;
    }

    private static final void findComponentUsages$process(JCenterToMavenCentralRefactoringProcessor this$0, List<UsageInfo> usages, RepositoriesModel repositoriesModel) {
        if (!repositoriesModel.containsMethodCall("jcenter")) {
            return;
        }
        boolean foundMavenCentral = false;
        List<RepositoryModel> list2 = repositoriesModel.repositories();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"repositories(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RepositoryModel repositoryModel = (RepositoryModel)element$iv;
            boolean bl = false;
            if (RepositoryModel.RepositoryType.JCENTER_DEFAULT == repositoryModel.getType()) {
                PsiElement psiElement;
                if (repositoryModel.getPsiElement() == null) continue;
                WrappedPsiElement wrappedPsiElement = new WrappedPsiElement(psiElement, this$0, REMOVE_JCENTER, null, 8, null);
                Intrinsics.checkNotNull((Object)repositoryModel);
                usages.add(new RemoveRepositoryUsageInfo(wrappedPsiElement, repositoriesModel, repositoryModel));
            }
            if (RepositoryModel.RepositoryType.MAVEN_CENTRAL != repositoryModel.getType()) continue;
            foundMavenCentral = true;
        }
        if (!foundMavenCentral) {
            PsiElement psiElement = repositoriesModel.getPsiElement();
            if (psiElement == null) {
                return;
            }
            PsiElement psiElement2 = psiElement;
            WrappedPsiElement wrappedPsiElement = new WrappedPsiElement(psiElement2, this$0, INSERT_MAVEN_CENTRAL, null, 8, null);
            usages.add(new AddMavenCentralRepositoryUsageInfo(wrappedPsiElement, repositoriesModel));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/gradle/project/upgrade/JCenterToMavenCentralRefactoringProcessor$Companion;", "", "<init>", "()V", "SUPPORTED_FROM", "Lcom/android/ide/common/repository/AgpVersion;", "getSUPPORTED_FROM", "()Lcom/android/ide/common/repository/AgpVersion;", "GRADLE_SUPPORT_REMOVED", "getGRADLE_SUPPORT_REMOVED", "REMOVE_JCENTER", "Lcom/intellij/usages/impl/rules/UsageType;", "getREMOVE_JCENTER", "()Lcom/intellij/usages/impl/rules/UsageType;", "INSERT_MAVEN_CENTRAL", "getINSERT_MAVEN_CENTRAL", "intellij.android.projectSystem.gradle.upgrade"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AgpVersion getSUPPORTED_FROM() {
            return SUPPORTED_FROM;
        }

        @NotNull
        public final AgpVersion getGRADLE_SUPPORT_REMOVED() {
            return GRADLE_SUPPORT_REMOVED;
        }

        @NotNull
        public final UsageType getREMOVE_JCENTER() {
            return REMOVE_JCENTER;
        }

        @NotNull
        public final UsageType getINSERT_MAVEN_CENTRAL() {
            return INSERT_MAVEN_CENTRAL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

