/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.upgrade;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.extensions.GradleDaemonJvmPropertiesFileExtensionsKt;
import com.android.tools.idea.gradle.extensions.GradleJvmSupportMatrixExtensionsKt;
import com.android.tools.idea.gradle.project.AgpCompatibleJdkVersion;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeBundle;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeComponentRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AlwaysNeeded;
import com.android.tools.idea.gradle.project.upgrade.GradleBuildModelRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.GradleBuildModelUsageInfo;
import com.android.tools.idea.gradle.project.upgrade.WrappedPsiElement;
import com.android.tools.idea.gradle.toolchain.GradleDaemonJvmCriteriaTemplatesManager;
import com.android.tools.idea.gradle.util.CompatibleGradleVersion;
import com.google.wireless.android.sdk.stats.UpgradeAssistantComponentInfo;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.properties.GradleDaemonJvmPropertiesFile;
import org.jetbrains.plugins.gradle.service.execution.GradleDaemonJvmHelper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001+B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0015\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0014\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u001f\u0010 \u001a\u00020!2\u0010\u0010\"\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00180\u0017H\u0014\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020\u001bH\u0014J\u0017\u0010%\u001a\u0004\u0018\u00010&2\u000b\u0010'\u001a\u00070\u001b\u00a2\u0006\u0002\b(H\u0002J\b\u0010)\u001a\u00020*H\u0002R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/gradle/project/upgrade/GradleDaemonJvmCriteriaRefactoringProcessor;", "Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeComponentRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "current", "Lcom/android/ide/common/repository/AgpVersion;", "new", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/ide/common/repository/AgpVersion;Lcom/android/ide/common/repository/AgpVersion;)V", "processor", "Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeRefactoringProcessor;", "(Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeRefactoringProcessor;)V", "recommendedToolchainVersion", "Lcom/intellij/util/lang/JavaVersion;", "getRecommendedToolchainVersion", "()Lcom/intellij/util/lang/JavaVersion;", "recommendedToolchainVersion$delegate", "Lkotlin/Lazy;", "necessityInfo", "Lcom/android/tools/idea/gradle/project/upgrade/AlwaysNeeded;", "getNecessityInfo", "()Lcom/android/tools/idea/gradle/project/upgrade/AlwaysNeeded;", "findComponentUsages", "", "Lcom/intellij/usageView/UsageInfo;", "()[Lcom/intellij/usageView/UsageInfo;", "getCommandName", "", "getShortDescription", "completeComponentInfo", "Lcom/google/wireless/android/sdk/stats/UpgradeAssistantComponentInfo$Builder;", "builder", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "usages", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "getRefactoringId", "getDaemonJvmCriteriaPropertiesFile", "Lcom/intellij/lang/properties/psi/PropertiesFile;", "externalProjectPath", "Lorg/jetbrains/annotations/SystemIndependent;", "getRecommendedGradleVersion", "Lorg/gradle/util/GradleVersion;", "GradleDaemonJvmCriteriaUsageInfo", "intellij.android.projectSystem.gradle.upgrade"})
public final class GradleDaemonJvmCriteriaRefactoringProcessor
extends AgpUpgradeComponentRefactoringProcessor {
    @NotNull
    private final Lazy recommendedToolchainVersion$delegate;
    @NotNull
    private final AlwaysNeeded necessityInfo;

    public GradleDaemonJvmCriteriaRefactoringProcessor(@NotNull Project project, @NotNull AgpVersion current, @NotNull AgpVersion agpVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"new");
        super(project, current, agpVersion);
        this.recommendedToolchainVersion$delegate = LazyKt.lazy(() -> GradleDaemonJvmCriteriaRefactoringProcessor.recommendedToolchainVersion_delegate$lambda$0(this));
        this.necessityInfo = AlwaysNeeded.INSTANCE;
    }

    public GradleDaemonJvmCriteriaRefactoringProcessor(@NotNull AgpUpgradeRefactoringProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
        super(processor);
        this.recommendedToolchainVersion$delegate = LazyKt.lazy(() -> GradleDaemonJvmCriteriaRefactoringProcessor.recommendedToolchainVersion_delegate$lambda$0(this));
        this.necessityInfo = AlwaysNeeded.INSTANCE;
    }

    private final JavaVersion getRecommendedToolchainVersion() {
        Lazy lazy = this.recommendedToolchainVersion$delegate;
        return (JavaVersion)lazy.getValue();
    }

    @Override
    @NotNull
    public AlwaysNeeded getNecessityInfo() {
        return this.necessityInfo;
    }

    @Override
    @NotNull
    protected UsageInfo[] findComponentUsages() {
        JavaVersion javaVersion;
        if (!GradleDaemonJvmHelper.isDaemonJvmCriteriaSupported((GradleVersion)this.getRecommendedGradleVersion())) {
            return new UsageInfo[0];
        }
        String string = this.getProject().getBasePath();
        if (string == null) {
            return new UsageInfo[0];
        }
        String externalProjectPath = string;
        PropertiesFile propertiesFile = this.getDaemonJvmCriteriaPropertiesFile(externalProjectPath);
        if (propertiesFile == null) {
            return new UsageInfo[0];
        }
        PropertiesFile propertiesPsiFile = propertiesFile;
        Path path = Paths.get(externalProjectPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Object object = GradleDaemonJvmPropertiesFile.getProperties((Path)path);
        if (object != null && (object = object.getVersion()) != null && (object = (String)object.getValue()) != null) {
            Object it = object;
            boolean bl = false;
            javaVersion = JavaVersion.Companion.tryParse((String)it);
        } else {
            javaVersion = null;
        }
        JavaVersion currentToolchainVersion = javaVersion;
        JavaVersion requiredToolchainVersion = AgpCompatibleJdkVersion.Companion.getCompatibleJdkVersion(this.getNew()).getLanguageLevel().toJavaVersion();
        if (currentToolchainVersion != null && currentToolchainVersion.compareTo(requiredToolchainVersion) >= 0) {
            return new UsageInfo[0];
        }
        if (!GradleDaemonJvmCriteriaTemplatesManager.INSTANCE.canGeneratePropertiesFile(this.getRecommendedToolchainVersion())) {
            return new UsageInfo[0];
        }
        Object[] objectArray = new Object[]{this.getRecommendedToolchainVersion().feature};
        UsageType usageType = new UsageType(AgpUpgradeBundle.Companion.messagePointer("gradleDaemonJvmCriteria.enable.usageType", objectArray));
        PsiFile psiFile = propertiesPsiFile.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        WrappedPsiElement wrappedPsiElement = new WrappedPsiElement((PsiElement)psiFile, this, usageType, null, 8, null);
        GradleDaemonJvmCriteriaUsageInfo[] gradleDaemonJvmCriteriaUsageInfoArray = new GradleDaemonJvmCriteriaUsageInfo[]{new GradleDaemonJvmCriteriaUsageInfo(wrappedPsiElement, this.getRecommendedToolchainVersion(), externalProjectPath)};
        return gradleDaemonJvmCriteriaUsageInfoArray;
    }

    @Override
    @NotNull
    public String getCommandName() {
        Object[] objectArray = new Object[]{this.getRecommendedToolchainVersion()};
        return AgpUpgradeBundle.Companion.message("gradleDaemonJvmCriteria.commandName", objectArray);
    }

    @Override
    @NotNull
    public String getShortDescription() {
        Object[] objectArray = new Object[]{this.getRecommendedToolchainVersion()};
        return AgpUpgradeBundle.Companion.message("gradleDaemonJvmCriteria.shortDescription", objectArray);
    }

    @Override
    @NotNull
    public UpgradeAssistantComponentInfo.Builder completeComponentInfo(@NotNull UpgradeAssistantComponentInfo.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        UpgradeAssistantComponentInfo.Builder builder2 = builder.setKind(UpgradeAssistantComponentInfo.UpgradeAssistantComponentKind.DAEMON_JVM_CRITERIA);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"setKind(...)");
        return builder2;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        return (UsageViewDescriptor)new UsageViewDescriptorAdapter(this){
            final /* synthetic */ GradleDaemonJvmCriteriaRefactoringProcessor this$0;
            {
                this.this$0 = $receiver;
            }

            public PsiElement[] getElements() {
                Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                Object[] objectArray = new Object[]{GradleDaemonJvmCriteriaRefactoringProcessor.access$getRecommendedToolchainVersion(this.this$0)};
                return AgpUpgradeBundle.Companion.message("gradleDaemonJvmCriteria.usageView.header", objectArray);
            }
        };
    }

    @NotNull
    protected String getRefactoringId() {
        return "com.android.tools.agp.upgrade.daemonJvmCriteria";
    }

    private final PropertiesFile getDaemonJvmCriteriaPropertiesFile(String externalProjectPath) {
        File propertiesFile = GradleDaemonJvmPropertiesFileExtensionsKt.getPropertyPath(GradleDaemonJvmPropertiesFile.INSTANCE, externalProjectPath).toFile();
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)propertiesFile, (boolean)false);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile propertiesVirtualFile = virtualFile;
        if (!propertiesVirtualFile.isValid()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(propertiesVirtualFile);
        return psiFile instanceof PropertiesFile ? (PropertiesFile)psiFile : null;
    }

    private final GradleVersion getRecommendedGradleVersion() {
        return CompatibleGradleVersion.Companion.getCompatibleGradleVersion(this.getNew()).getVersion();
    }

    private static final JavaVersion recommendedToolchainVersion_delegate$lambda$0(GradleDaemonJvmCriteriaRefactoringProcessor this$0) {
        return GradleJvmSupportMatrixExtensionsKt.getRecommendedJavaVersion(GradleJvmSupportMatrix.Companion, this$0.getRecommendedGradleVersion(), true);
    }

    public static final /* synthetic */ JavaVersion access$getRecommendedToolchainVersion(GradleDaemonJvmCriteriaRefactoringProcessor $this) {
        return $this.getRecommendedToolchainVersion();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B$\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/gradle/project/upgrade/GradleDaemonJvmCriteriaRefactoringProcessor$GradleDaemonJvmCriteriaUsageInfo;", "Lcom/android/tools/idea/gradle/project/upgrade/GradleBuildModelUsageInfo;", "element", "Lcom/android/tools/idea/gradle/project/upgrade/WrappedPsiElement;", "javaVersion", "Lcom/intellij/util/lang/JavaVersion;", "externalProjectPath", "", "Lorg/jetbrains/annotations/SystemIndependent;", "<init>", "(Lcom/android/tools/idea/gradle/project/upgrade/WrappedPsiElement;Lcom/intellij/util/lang/JavaVersion;Ljava/lang/String;)V", "getTooltipText", "performBuildModelRefactoring", "", "processor", "Lcom/android/tools/idea/gradle/project/upgrade/GradleBuildModelRefactoringProcessor;", "intellij.android.projectSystem.gradle.upgrade"})
    public static final class GradleDaemonJvmCriteriaUsageInfo
    extends GradleBuildModelUsageInfo {
        @NotNull
        private final JavaVersion javaVersion;
        @NotNull
        private final String externalProjectPath;

        public GradleDaemonJvmCriteriaUsageInfo(@NotNull WrappedPsiElement element, @NotNull JavaVersion javaVersion, @NotNull String externalProjectPath) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)javaVersion, (String)"javaVersion");
            Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
            super(element);
            this.javaVersion = javaVersion;
            this.externalProjectPath = externalProjectPath;
        }

        @Override
        @NotNull
        public String getTooltipText() {
            Object[] objectArray = new Object[]{this.javaVersion.feature};
            return AgpUpgradeBundle.Companion.message("gradleDaemonJvmCriteria.enable.tooltipText", objectArray);
        }

        @Override
        public void performBuildModelRefactoring(@NotNull GradleBuildModelRefactoringProcessor processor) {
            Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
            GradleDaemonJvmCriteriaTemplatesManager.INSTANCE.generatePropertiesFile(this.javaVersion, this.externalProjectPath);
        }
    }
}

