/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.quickFixes;

import com.android.repository.Revision;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.project.sync.issues.processor.FixBuildToolsProcessor;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001c\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/gradle/project/sync/quickFixes/InstallBuildToolsQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "version", "", "buildFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "removeBuildTools", "", "<init>", "(Ljava/lang/String;Ljava/util/List;Z)V", "id", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.android.projectSystem.gradle"})
public final class InstallBuildToolsQuickFix
implements BuildIssueQuickFix {
    @NotNull
    private final String version;
    @NotNull
    private final List<VirtualFile> buildFiles;
    private final boolean removeBuildTools;
    @NotNull
    private final String id;

    public InstallBuildToolsQuickFix(@NotNull String version2, @NotNull List<? extends VirtualFile> buildFiles, boolean removeBuildTools) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter(buildFiles, (String)"buildFiles");
        this.version = version2;
        this.buildFiles = buildFiles;
        this.removeBuildTools = removeBuildTools;
        this.id = "install.build.tools";
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        CompletableFuture future2 = new CompletableFuture();
        ActionsKt.invokeLater$default(null, () -> InstallBuildToolsQuickFix.runQuickFix$lambda$0(this, project, future2), (int)1, null);
        return future2;
    }

    private static final Unit runQuickFix$lambda$0(InstallBuildToolsQuickFix this$0, Project $project, CompletableFuture $future) {
        Revision minBuildToolsVersion = Revision.parseRevision((String)this$0.version);
        ModelWizardDialog dialog2 = SdkQuickfixUtils.createDialogForPaths($project, CollectionsKt.listOf((Object)DetailsTypes.getBuildToolsPath((Revision)minBuildToolsVersion)));
        if (dialog2 != null && dialog2.showAndGet()) {
            if (!((Collection)this$0.buildFiles).isEmpty()) {
                FixBuildToolsProcessor processor = new FixBuildToolsProcessor($project, this$0.buildFiles, this$0.version, true, this$0.removeBuildTools);
                processor.setPreviewUsages(true);
                processor.run();
            } else {
                ProjectSystemUtil.getSyncManager($project).requestSyncProject(ProjectSystemSyncUtil.toReason(GradleSyncStats.Trigger.TRIGGER_QF_BUILD_TOOLS_INSTALLED));
            }
        }
        $future.complete(null);
        return Unit.INSTANCE;
    }
}

