/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.listeners;

import com.android.tools.idea.gradle.project.sync.GradleSyncListenerWithRoot;
import com.android.tools.idea.gradle.project.sync.listeners.StateChangeNotificationKt;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.EditorNotifications;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016J\u001d\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016J%\u0010\f\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\t2\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/gradle/project/sync/listeners/StateChangeNotification;", "Lcom/android/tools/idea/gradle/project/sync/GradleSyncListenerWithRoot;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "syncStarted", "", "rootProjectPath", "", "Lorg/jetbrains/annotations/SystemIndependent;", "syncSucceeded", "syncFailed", "errorMessage", "syncSkipped", "notifyStateChanged", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nStateChangeNotification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateChangeNotification.kt\ncom/android/tools/idea/gradle/project/sync/listeners/StateChangeNotification\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,53:1\n13472#2,2:54\n*S KotlinDebug\n*F\n+ 1 StateChangeNotification.kt\ncom/android/tools/idea/gradle/project/sync/listeners/StateChangeNotification\n*L\n40#1:54,2\n*E\n"})
public class StateChangeNotification
implements GradleSyncListenerWithRoot {
    @NotNull
    private final Project project;

    public StateChangeNotification(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    public void syncStarted(@NotNull Project project, @NotNull String rootProjectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)rootProjectPath, (String)"rootProjectPath");
        this.notifyStateChanged();
    }

    @Override
    public void syncSucceeded(@NotNull Project project, @NotNull String rootProjectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)rootProjectPath, (String)"rootProjectPath");
        this.notifyStateChanged();
    }

    @Override
    public void syncFailed(@NotNull Project project, @NotNull String errorMessage, @NotNull String rootProjectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter((Object)rootProjectPath, (String)"rootProjectPath");
        this.notifyStateChanged();
    }

    @Override
    public void syncSkipped(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    @VisibleForTesting
    public void notifyStateChanged() {
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.project, () -> StateChangeNotification.notifyStateChanged$lambda$0(this));
    }

    private static final void notifyStateChanged$lambda$0(StateChangeNotification this$0) {
        EditorNotifications editorNotifications = EditorNotifications.getInstance((Project)this$0.project);
        Intrinsics.checkNotNullExpressionValue((Object)editorNotifications, (String)"getInstance(...)");
        EditorNotifications editorNotifications2 = editorNotifications;
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)this$0.project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        Object[] $this$forEach$iv = virtualFileArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile file = (VirtualFile)element$iv;
            boolean bl = false;
            try {
                editorNotifications2.updateNotifications(file);
            }
            catch (Throwable e) {
                StateChangeNotificationKt.access$getLOG$p().info("Failed to update editor notifications for file '" + FileUtil.toSystemDependentName((String)file.getPath()) + "'", e);
            }
        }
    }
}

