/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.listeners;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.extensions.GradleDaemonJvmHelperExtensionsKt;
import com.android.tools.idea.gradle.project.sync.GradleSyncListenerWithRoot;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.GradleSyncStateHolder;
import com.android.tools.idea.gradle.project.sync.hyperlink.DoNotShowJdkHomeWarningAgainHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.SelectJdkFromFileSystemHyperlink;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.IdeSdks;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.util.GradleVersion;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.execution.GradleDaemonJvmHelper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016J-\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0003\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/gradle/project/sync/listeners/SpawnMultipleDaemonsWarningListener;", "Lcom/android/tools/idea/gradle/project/sync/GradleSyncListenerWithRoot;", "<init>", "()V", "syncSucceeded", "", "project", "Lcom/intellij/openapi/project/Project;", "rootProjectPath", "", "Lorg/jetbrains/annotations/SystemIndependent;", "showMultipleGradleDaemonWarning", "gradleJvmPath", "javaHome", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nSpawnMultipleDaemonsWarningListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpawnMultipleDaemonsWarningListener.kt\ncom/android/tools/idea/gradle/project/sync/listeners/SpawnMultipleDaemonsWarningListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1869#2,2:104\n1869#2,2:106\n*S KotlinDebug\n*F\n+ 1 SpawnMultipleDaemonsWarningListener.kt\ncom/android/tools/idea/gradle/project/sync/listeners/SpawnMultipleDaemonsWarningListener\n*L\n91#1:104,2\n95#1:106,2\n*E\n"})
public final class SpawnMultipleDaemonsWarningListener
implements GradleSyncListenerWithRoot {
    @Override
    public void syncSucceeded(@NotNull Project project, @NotNull String rootProjectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)rootProjectPath, (String)"rootProjectPath");
        if (project.isDisposed()) {
            return;
        }
        if (!IdeInfo.getInstance().isAndroidStudio()) {
            return;
        }
        if (!NotificationsConfigurationImpl.getSettings((String)GradleSyncState.JDK_LOCATION_WARNING_NOTIFICATION_GROUP.getDisplayId()).isShouldLog()) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> SpawnMultipleDaemonsWarningListener.syncSucceeded$lambda$0(project, rootProjectPath, this));
    }

    @UiThread
    private final void showMultipleGradleDaemonWarning(Project project, String rootProjectPath, String gradleJvmPath, String javaHome) {
        Notification notification;
        String hyperlinkUrl = AndroidBundle.message("project.sync.warning.multiple.gradle.daemons.url", new Object[0]);
        Object[] objectArray = new NotificationHyperlink[]{new OpenUrlHyperlink(hyperlinkUrl, "More info...")};
        List quickFixes = CollectionsKt.mutableListOf((Object[])objectArray);
        SelectJdkFromFileSystemHyperlink selectJdkHyperlink = SelectJdkFromFileSystemHyperlink.Companion.create$default(SelectJdkFromFileSystemHyperlink.Companion, project, rootProjectPath, null, 4, null);
        if (selectJdkHyperlink != null) {
            ((Collection)quickFixes).add(selectJdkHyperlink);
        }
        quickFixes.add(new DoNotShowJdkHomeWarningAgainHyperlink());
        Object message = null;
        Object[] objectArray2 = new Object[]{project.getName(), gradleJvmPath, javaHome};
        message = AndroidBundle.message("project.sync.warning.multiple.gradle.daemons.message", objectArray2);
        Iterable $this$forEach$iv = quickFixes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotificationHyperlink quickFix = (NotificationHyperlink)element$iv;
            boolean bl = false;
            message = message + "<br>" + quickFix.toHtml();
        }
        NotificationListener listener2 = (arg_0, arg_1) -> SpawnMultipleDaemonsWarningListener.showMultipleGradleDaemonWarning$lambda$1(quickFixes, project, arg_0, arg_1);
        String string = message;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element");
        NotificationType notificationType = MessageType.WARNING.toNotificationType();
        Intrinsics.checkNotNullExpressionValue((Object)notificationType, (String)"toNotificationType(...)");
        Notification $this$showMultipleGradleDaemonWarning_u24lambda_u242 = notification = GradleSyncState.JDK_LOCATION_WARNING_NOTIFICATION_GROUP.createNotification("", string, notificationType);
        boolean bl = false;
        $this$showMultipleGradleDaemonWarning_u24lambda_u242.setListener(listener2);
        $this$showMultipleGradleDaemonWarning_u24lambda_u242.notify(project);
    }

    private static final void syncSucceeded$lambda$0(Project $project, String $rootProjectPath, SpawnMultipleDaemonsWarningListener this$0) {
        ActionsKt.runReadAction(() -> SpawnMultipleDaemonsWarningListener.syncSucceeded$lambda$0$0($project, $rootProjectPath, this$0));
    }

    private static final Unit syncSucceeded$lambda$0$0(Project $project, String $rootProjectPath, SpawnMultipleDaemonsWarningListener this$0) {
        String string;
        String gradleJvmPath;
        String string2;
        if ($project.isDisposed()) {
            return Unit.INSTANCE;
        }
        if (IdeSdks.getInstance().isUsingJavaHomeJdk($project)) {
            return Unit.INSTANCE;
        }
        GradleVersion gradleVersion2 = GradleSyncStateHolder.Companion.getInstance($project).getLastSyncedGradleVersion();
        if (gradleVersion2 == null) {
            return Unit.INSTANCE;
        }
        GradleVersion gradleVersion3 = gradleVersion2;
        if (GradleDaemonJvmHelperExtensionsKt.isProjectUsingDaemonJvmCriteria(GradleDaemonJvmHelper.INSTANCE, $rootProjectPath, gradleVersion3)) {
            return Unit.INSTANCE;
        }
        GradleInstallationManager gradleInstallationManager = GradleInstallationManager.Companion.getInstance();
        String string3 = $project.getBasePath();
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = gradleInstallationManager.getGradleJvmPath($project, string3)) == null) {
            string2 = gradleJvmPath = "Undefined";
        }
        if ((string = IdeSdks.getInstance().getJdkFromJavaHome()) == null) {
            string = "Undefined";
        }
        String javaHome = string;
        ApplicationManager.getApplication().invokeLater(() -> SpawnMultipleDaemonsWarningListener.syncSucceeded$lambda$0$0$0(this$0, $project, $rootProjectPath, gradleJvmPath, javaHome));
        return Unit.INSTANCE;
    }

    private static final void syncSucceeded$lambda$0$0$0(SpawnMultipleDaemonsWarningListener this$0, Project $project, String $rootProjectPath, String $gradleJvmPath, String $javaHome) {
        this$0.showMultipleGradleDaemonWarning($project, $rootProjectPath, $gradleJvmPath, $javaHome);
    }

    private static final void showMultipleGradleDaemonWarning$lambda$1(List $quickFixes, Project $project, Notification notification, HyperlinkEvent event) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$forEach$iv = $quickFixes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotificationHyperlink link2 = (NotificationHyperlink)element$iv;
            boolean bl = false;
            link2.executeIfClicked($project, event);
        }
    }
}

