/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.jdk.exceptions.base;

import com.android.tools.idea.gradle.jdk.GradleDefaultJdkPathStore;
import com.android.tools.idea.gradle.project.sync.hyperlink.SelectJdkFromFileSystemHyperlink;
import com.android.tools.idea.gradle.project.sync.jdk.GradleJdkConfigurationUtils;
import com.android.tools.idea.gradle.project.sync.jdk.ProjectJdkUtils;
import com.android.tools.idea.gradle.project.sync.jdk.exceptions.cause.InvalidGradleJdkCause;
import com.android.tools.idea.gradle.util.GradleConfigProperties;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.wireless.android.sdk.stats.GradleJdkInvalidEvent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001#B\u001c\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0017\u001a\u00020\u0018J-\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0019\u001a\u00020\u001aX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/gradle/project/sync/jdk/exceptions/base/GradleJdkException;", "", "project", "Lcom/intellij/openapi/project/Project;", "gradleRootPath", "", "Lorg/jetbrains/annotations/SystemIndependent;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "jdkPathLocationFile", "Ljava/io/File;", "getJdkPathLocationFile", "()Ljava/io/File;", "message", "getMessage", "()Ljava/lang/String;", "message$delegate", "Lkotlin/Lazy;", "reason", "Lcom/google/wireless/android/sdk/stats/GradleJdkInvalidEvent$InvalidJdkReason;", "getReason", "()Lcom/google/wireless/android/sdk/stats/GradleJdkInvalidEvent$InvalidJdkReason;", "reason$delegate", "recover", "", "cause", "Lcom/android/tools/idea/gradle/project/sync/jdk/exceptions/cause/InvalidGradleJdkCause;", "getCause", "()Lcom/android/tools/idea/gradle/project/sync/jdk/exceptions/cause/InvalidGradleJdkCause;", "showRecoveredGradleJdkNotification", "errorDescription", "errorResolution", "getJdkRecoveryCandidates", "", "Lcom/android/tools/idea/gradle/project/sync/jdk/exceptions/base/GradleJdkException$JdkRecoveryCandidate;", "JdkRecoveryCandidate", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleJdkException.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleJdkException.kt\ncom/android/tools/idea/gradle/project/sync/jdk/exceptions/base/GradleJdkException\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,99:1\n295#2,2:100\n37#3:102\n36#3,3:103\n*S KotlinDebug\n*F\n+ 1 GradleJdkException.kt\ncom/android/tools/idea/gradle/project/sync/jdk/exceptions/base/GradleJdkException\n*L\n52#1:100,2\n83#1:102\n83#1:103,3\n*E\n"})
public abstract class GradleJdkException {
    @NotNull
    private final Project project;
    @NotNull
    private final String gradleRootPath;
    @Nullable
    private final File jdkPathLocationFile;
    @NotNull
    private final Lazy message$delegate;
    @NotNull
    private final Lazy reason$delegate;

    public GradleJdkException(@NotNull Project project, @NotNull String gradleRootPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)gradleRootPath, (String)"gradleRootPath");
        this.project = project;
        this.gradleRootPath = gradleRootPath;
        this.message$delegate = LazyKt.lazy(() -> GradleJdkException.message_delegate$lambda$0(this));
        this.reason$delegate = LazyKt.lazy(() -> GradleJdkException.reason_delegate$lambda$0(this));
    }

    @Nullable
    public File getJdkPathLocationFile() {
        return this.jdkPathLocationFile;
    }

    @NotNull
    public final String getMessage() {
        Lazy lazy = this.message$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final GradleJdkInvalidEvent.InvalidJdkReason getReason() {
        Lazy lazy = this.reason$delegate;
        return (GradleJdkInvalidEvent.InvalidJdkReason)lazy.getValue();
    }

    public final void recover() {
        block5: {
            String string;
            Object v0;
            block4: {
                Iterable $this$firstOrNull$iv = this.getJdkRecoveryCandidates();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    JdkRecoveryCandidate it = (JdkRecoveryCandidate)element$iv;
                    boolean bl = false;
                    if (!ExternalSystemJdkUtil.isValidJdk((String)it.getPath())) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            JdkRecoveryCandidate jdkRecoveryCandidate = v0;
            if (jdkRecoveryCandidate == null) break block5;
            JdkRecoveryCandidate $this$recover_u24lambda_u241 = jdkRecoveryCandidate;
            boolean bl = false;
            String string2 = $this$recover_u24lambda_u241.getGradleJvm();
            if (string2 != null) {
                String it = string2;
                boolean bl2 = false;
                ProjectJdkUtils.INSTANCE.updateProjectGradleJvm(this.project, this.gradleRootPath, it);
            } else {
                JdkRecoveryCandidate $this$recover_u24lambda_u241_u241 = $this$recover_u24lambda_u241;
                boolean bl3 = false;
                GradleJdkConfigurationUtils.INSTANCE.setProjectGradleJdk(this.project, this.gradleRootPath, $this$recover_u24lambda_u241_u241.getPath());
            }
            if ((string = JavaSdk.getInstance().getVersionString($this$recover_u24lambda_u241.getPath())) == null) {
                string = "<unknown>";
            }
            String jdkVersion = string;
            String string3 = this.getCause().getDescription();
            Object[] objectArray = new Object[]{$this$recover_u24lambda_u241.getOrigin(), jdkVersion};
            String string4 = AndroidBundle.message("project.sync.jdk.recovery.message", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            this.showRecoveredGradleJdkNotification(this.project, this.gradleRootPath, string3, string4);
        }
    }

    @NotNull
    protected abstract InvalidGradleJdkCause getCause();

    private final void showRecoveredGradleJdkNotification(Project project, String gradleRootPath, String errorDescription, String errorResolution) {
        String title2 = GradleBundle.message((String)"gradle.jvm.is.invalid", (Object[])new Object[0]);
        StringBuilder messageBuilder = new StringBuilder().append(errorDescription).append('\n').append(errorResolution).append('\n');
        List quickFixes = CollectionsKt.listOfNotNull((Object)((Object)SelectJdkFromFileSystemHyperlink.Companion.create$default(SelectJdkFromFileSystemHyperlink.Companion, project, gradleRootPath, null, 4, null)));
        Collection $this$toTypedArray$iv = quickFixes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        SelectJdkFromFileSystemHyperlink[] selectJdkFromFileSystemHyperlinkArray = thisCollection$iv.toArray(new SelectJdkFromFileSystemHyperlink[0]);
        AndroidNotification.getInstance((Project)project).showBalloon(title2, messageBuilder.toString(), NotificationType.WARNING, (NotificationHyperlink[])Arrays.copyOf(selectJdkFromFileSystemHyperlinkArray, selectJdkFromFileSystemHyperlinkArray.length));
    }

    private final List<JdkRecoveryCandidate> getJdkRecoveryCandidates() {
        Object[] objectArray = new JdkRecoveryCandidate[4];
        String string = AndroidBundle.message("gradle.local.jdk.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        File file = new GradleConfigProperties(new File(this.gradleRootPath)).getJavaHome();
        String string2 = file != null ? file.getAbsolutePath() : null;
        if (string2 == null) {
            string2 = "";
        }
        objectArray[0] = new JdkRecoveryCandidate(string, string2, "#GRADLE_LOCAL_JAVA_HOME", false, 8, null);
        String string3 = AndroidBundle.message("gradle.project.jdk.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        Sdk sdk = ProjectRootManager.getInstance((Project)this.project).getProjectSdk();
        String string4 = sdk != null ? sdk.getHomePath() : null;
        if (string4 == null) {
            string4 = "";
        }
        objectArray[1] = new JdkRecoveryCandidate(string3, string4, null, false, 12, null);
        String string5 = AndroidBundle.message("gradle.default.jdk.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        String string6 = GradleDefaultJdkPathStore.INSTANCE.getJdkPath();
        if (string6 == null) {
            string6 = "";
        }
        objectArray[2] = new JdkRecoveryCandidate(string5, string6, null, false, 12, null);
        String string7 = AndroidBundle.message("gradle.embedded.jdk.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
        objectArray[3] = new JdkRecoveryCandidate(string7, ((Object)IdeSdks.getInstance().getEmbeddedJdkPath()).toString(), null, false, 12, null);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final String message_delegate$lambda$0(GradleJdkException this$0) {
        return this$0.getCause().getDescription();
    }

    private static final GradleJdkInvalidEvent.InvalidJdkReason reason_delegate$lambda$0(GradleJdkException this$0) {
        return this$0.getCause().getReason();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J3\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/gradle/project/sync/jdk/exceptions/base/GradleJdkException$JdkRecoveryCandidate;", "", "origin", "", "path", "gradleJvm", "displayNotification", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "getOrigin", "()Ljava/lang/String;", "getPath", "getGradleJvm", "getDisplayNotification", "()Z", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "intellij.android.projectSystem.gradle"})
    private static final class JdkRecoveryCandidate {
        @NotNull
        private final String origin;
        @NotNull
        private final String path;
        @Nullable
        private final String gradleJvm;
        private final boolean displayNotification;

        public JdkRecoveryCandidate(@NotNull String origin, @NotNull String path, @Nullable String gradleJvm, boolean displayNotification) {
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.origin = origin;
            this.path = path;
            this.gradleJvm = gradleJvm;
            this.displayNotification = displayNotification;
        }

        public /* synthetic */ JdkRecoveryCandidate(String string, String string2, String string3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            this(string, string2, string3, bl);
        }

        @NotNull
        public final String getOrigin() {
            return this.origin;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @Nullable
        public final String getGradleJvm() {
            return this.gradleJvm;
        }

        public final boolean getDisplayNotification() {
            return this.displayNotification;
        }

        @NotNull
        public final String component1() {
            return this.origin;
        }

        @NotNull
        public final String component2() {
            return this.path;
        }

        @Nullable
        public final String component3() {
            return this.gradleJvm;
        }

        public final boolean component4() {
            return this.displayNotification;
        }

        @NotNull
        public final JdkRecoveryCandidate copy(@NotNull String origin, @NotNull String path, @Nullable String gradleJvm, boolean displayNotification) {
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new JdkRecoveryCandidate(origin, path, gradleJvm, displayNotification);
        }

        public static /* synthetic */ JdkRecoveryCandidate copy$default(JdkRecoveryCandidate jdkRecoveryCandidate, String string, String string2, String string3, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = jdkRecoveryCandidate.origin;
            }
            if ((n & 2) != 0) {
                string2 = jdkRecoveryCandidate.path;
            }
            if ((n & 4) != 0) {
                string3 = jdkRecoveryCandidate.gradleJvm;
            }
            if ((n & 8) != 0) {
                bl = jdkRecoveryCandidate.displayNotification;
            }
            return jdkRecoveryCandidate.copy(string, string2, string3, bl);
        }

        @NotNull
        public String toString() {
            return "JdkRecoveryCandidate(origin=" + this.origin + ", path=" + this.path + ", gradleJvm=" + this.gradleJvm + ", displayNotification=" + this.displayNotification + ")";
        }

        public int hashCode() {
            int result2 = this.origin.hashCode();
            result2 = result2 * 31 + this.path.hashCode();
            result2 = result2 * 31 + (this.gradleJvm == null ? 0 : this.gradleJvm.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.displayNotification);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JdkRecoveryCandidate)) {
                return false;
            }
            JdkRecoveryCandidate jdkRecoveryCandidate = (JdkRecoveryCandidate)other;
            if (!Intrinsics.areEqual((Object)this.origin, (Object)jdkRecoveryCandidate.origin)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.path, (Object)jdkRecoveryCandidate.path)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.gradleJvm, (Object)jdkRecoveryCandidate.gradleJvm)) {
                return false;
            }
            return this.displayNotification == jdkRecoveryCandidate.displayNotification;
        }
    }
}

