/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.jdk;

import com.android.tools.idea.gradle.project.sync.jdk.ProjectJdkTableUtils;
import com.android.tools.idea.gradle.project.sync.jdk.ProjectJdkUtilsKt;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.extensions.SdkExtensions;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ#\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000b\u0010\u000b\u001a\u00070\t\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/gradle/project/sync/jdk/ProjectJdkUtils;", "", "<init>", "()V", "updateProjectJdkWithPath", "", "project", "Lcom/intellij/openapi/project/Project;", "jdkPath", "", "updateProjectGradleJvm", "gradleRootPath", "Lorg/jetbrains/annotations/SystemIndependent;", "gradleJvm", "setUpEmbeddedJdkAsProjectJdk", "intellij.android.projectSystem.gradle"})
public final class ProjectJdkUtils {
    @NotNull
    public static final ProjectJdkUtils INSTANCE = new ProjectJdkUtils();

    private ProjectJdkUtils() {
    }

    public final void updateProjectJdkWithPath(@NotNull Project project, @NotNull String jdkPath) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)jdkPath, (String)"jdkPath");
            if (!ExternalSystemJdkUtil.isValidJdk((String)jdkPath)) {
                ProjectJdkUtilsKt.access$getLOG$p().info("Unable to update project Jdk given invalid path: " + jdkPath);
                return;
            }
            String jdkName = ProjectJdkTableUtils.INSTANCE.addOrRecreateDedicatedJdkTableEntry(jdkPath);
            Sdk sdk = ProjectJdkTable.getInstance().findJdk(jdkName);
            if (sdk == null) break block2;
            Sdk jdk = sdk;
            boolean bl = false;
            Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
            if (projectSdk == null || !SdkExtensions.isEqualTo(projectSdk, jdk)) {
                JavaSdkUtil.applyJdkToProject((Project)project, (Sdk)jdk);
                ProjectJdkUtilsKt.access$getLOG$p().info("Updated project Jdk to: " + jdk.getName());
            }
        }
    }

    public final void updateProjectGradleJvm(@NotNull Project project, @NotNull String gradleRootPath, @NotNull String gradleJvm) {
        block0: {
            GradleProjectSettings projectSettings;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)gradleRootPath, (String)"gradleRootPath");
            Intrinsics.checkNotNullParameter((Object)gradleJvm, (String)"gradleJvm");
            GradleProjectSettings gradleProjectSettings = projectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)project).getLinkedProjectSettings(gradleRootPath);
            if (gradleProjectSettings == null) break block0;
            gradleProjectSettings.setGradleJvm(gradleJvm);
        }
    }

    public final void setUpEmbeddedJdkAsProjectJdk(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        WriteAction.runAndWait(() -> ProjectJdkUtils.setUpEmbeddedJdkAsProjectJdk$lambda$0(project));
    }

    private static final void setUpEmbeddedJdkAsProjectJdk$lambda$0(Project $project) {
        block0: {
            Path path = IdeSdks.getInstance().getEmbeddedJdkPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getEmbeddedJdkPath(...)");
            Path embeddedJdkPath = path;
            String jdkTableEntry = ProjectJdkTableUtils.INSTANCE.addOrRecreateDedicatedJdkTableEntry(((Object)embeddedJdkPath).toString());
            Sdk sdk = ProjectJdkTable.getInstance().findJdk(jdkTableEntry);
            if (sdk == null) break block0;
            Sdk it = sdk;
            boolean bl = false;
            ProjectRootManager.getInstance((Project)$project).setProjectSdk(it);
        }
    }
}

