/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues.processor;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.JCenterRepositoryModel;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001!B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001d\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001d\u0010\u001e\u001a\u00020\u001c2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010H\u0007\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/gradle/project/sync/issues/processor/RemoveJcenterProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "affectedModules", "", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getAffectedModules", "()Ljava/util/List;", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "usagesFromRepositories", "", "repositories", "Lcom/android/tools/idea/gradle/dsl/api/repositories/RepositoriesModel;", "extractJcenterModel", "Lcom/android/tools/idea/gradle/dsl/model/repositories/JCenterRepositoryModel;", "performRefactoring", "", "([Lcom/intellij/usageView/UsageInfo;)V", "updateProjectBuildModel", "getCommandName", "", "RepositoryUsageInfo", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nRemoveJcenterProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveJcenterProcessor.kt\ncom/android/tools/idea/gradle/project/sync/issues/processor/RemoveJcenterProcessor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,117:1\n37#2:118\n36#2,3:119\n*S KotlinDebug\n*F\n+ 1 RemoveJcenterProcessor.kt\ncom/android/tools/idea/gradle/project/sync/issues/processor/RemoveJcenterProcessor\n*L\n75#1:118\n75#1:119,3\n*E\n"})
public final class RemoveJcenterProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final Project project;
    @NotNull
    private final List<Module> affectedModules;

    public RemoveJcenterProcessor(@NotNull Project project, @NotNull List<? extends Module> affectedModules) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(affectedModules, (String)"affectedModules");
        super(project);
        this.project = project;
        this.affectedModules = affectedModules;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<Module> getAffectedModules() {
        return this.affectedModules;
    }

    @NotNull
    public UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        return new UsageViewDescriptor(){

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return "References to be removed: " + UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount);
            }

            public PsiElement[] getElements() {
                Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return "Remove JCenter from repositories.";
            }
        };
    }

    @NotNull
    public UsageInfo[] findUsages() {
        GradleSettingsModel settingsModel;
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel, (String)"get(...)");
        ProjectBuildModel projectBuildModel2 = projectBuildModel;
        GradleBuildModel buildModel = projectBuildModel2.getProjectBuildModel();
        if (buildModel != null) {
            RepositoriesModel repositoriesModel = buildModel.buildscript().repositories();
            Intrinsics.checkNotNullExpressionValue((Object)repositoriesModel, (String)"repositories(...)");
            usages.addAll(this.usagesFromRepositories(repositoriesModel));
        }
        if ((settingsModel = projectBuildModel2.getProjectSettingsModel()) != null) {
            RepositoriesModel repositoriesModel = settingsModel.dependencyResolutionManagement().repositories();
            Intrinsics.checkNotNullExpressionValue((Object)repositoriesModel, (String)"repositories(...)");
            usages.addAll(this.usagesFromRepositories(repositoriesModel));
        }
        for (Module module : this.affectedModules) {
            GradleBuildModel moduleModel;
            if (projectBuildModel2.getModuleBuildModel(module) == null) continue;
            RepositoriesModel repositoriesModel = moduleModel.repositories();
            Intrinsics.checkNotNullExpressionValue((Object)repositoriesModel, (String)"repositories(...)");
            usages.addAll(this.usagesFromRepositories(repositoriesModel));
        }
        Collection $this$toTypedArray$iv = usages;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new UsageInfo[0]);
    }

    private final Collection<UsageInfo> usagesFromRepositories(RepositoriesModel repositories) {
        ArrayList<RepositoryUsageInfo> usages = new ArrayList<RepositoryUsageInfo>();
        List<JCenterRepositoryModel> jcenterModels = this.extractJcenterModel(repositories);
        for (JCenterRepositoryModel model : jcenterModels) {
            if (model.getPsiElement() == null) continue;
            usages.add(new RepositoryUsageInfo(model));
        }
        return usages;
    }

    private final List<JCenterRepositoryModel> extractJcenterModel(RepositoriesModel repositories) {
        List<RepositoryModel> list2 = repositories.repositories();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"repositories(...)");
        return CollectionsKt.filterIsInstance((Iterable)list2, JCenterRepositoryModel.class);
    }

    public void performRefactoring(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        this.updateProjectBuildModel(usages);
        ProjectSystemUtil.getSyncManager(this.project).requestSyncProject(ProjectSystemSyncUtil.toReason(GradleSyncStats.Trigger.TRIGGER_QF_REMOVE_JCENTER_FROM_REPOSITORIES));
    }

    @VisibleForTesting
    public final void updateProjectBuildModel(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel, (String)"get(...)");
        ProjectBuildModel projectBuildModel2 = projectBuildModel;
        for (UsageInfo usage : usages) {
            if (!(usage instanceof RepositoryUsageInfo)) continue;
            ((RepositoryUsageInfo)usage).removeUsage();
        }
        projectBuildModel2.applyChanges();
    }

    @NotNull
    public String getCommandName() {
        return "Remove JCenter From Repositories";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/gradle/project/sync/issues/processor/RemoveJcenterProcessor$RepositoryUsageInfo;", "Lcom/intellij/usageView/UsageInfo;", "model", "Lcom/android/tools/idea/gradle/dsl/model/repositories/JCenterRepositoryModel;", "<init>", "(Lcom/android/tools/idea/gradle/dsl/model/repositories/JCenterRepositoryModel;)V", "getModel", "()Lcom/android/tools/idea/gradle/dsl/model/repositories/JCenterRepositoryModel;", "removeUsage", "", "intellij.android.projectSystem.gradle"})
    public static final class RepositoryUsageInfo
    extends UsageInfo {
        @NotNull
        private final JCenterRepositoryModel model;

        public RepositoryUsageInfo(@NotNull JCenterRepositoryModel model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            PsiElement psiElement = model.getPsiElement();
            Intrinsics.checkNotNull((Object)psiElement);
            super(psiElement);
            this.model = model;
        }

        @NotNull
        public final JCenterRepositoryModel getModel() {
            return this.model;
        }

        public final void removeUsage() {
            this.model.getDslElement().delete();
        }
    }
}

