/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues.processor;

import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u001b\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001b\u0010\u0017\u001a\u00020\u00182\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007\u00a2\u0006\u0002\u0010\u0019J\u001b\u0010\u001a\u001a\u00020\u00182\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016\u00a2\u0006\u0002\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/gradle/project/sync/issues/processor/GradlePropertyProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "propertyName", "", "propertyValue", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getPropertyName", "()Ljava/lang/String;", "getPropertyValue", "getCommandName", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "updateProjectBuildModel", "", "([Lcom/intellij/usageView/UsageInfo;)V", "performRefactoring", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nGradlePropertyProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradlePropertyProcessor.kt\ncom/android/tools/idea/gradle/project/sync/issues/processor/GradlePropertyProcessor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,104:1\n13472#2,2:105\n*S KotlinDebug\n*F\n+ 1 GradlePropertyProcessor.kt\ncom/android/tools/idea/gradle/project/sync/issues/processor/GradlePropertyProcessor\n*L\n70#1:105,2\n*E\n"})
public final class GradlePropertyProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final Project project;
    @NotNull
    private final String propertyName;
    @NotNull
    private final String propertyValue;

    public GradlePropertyProcessor(@NotNull Project project, @NotNull String propertyName, @NotNull String propertyValue) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Intrinsics.checkNotNullParameter((Object)propertyValue, (String)"propertyValue");
        super(project);
        this.project = project;
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getPropertyName() {
        return this.propertyName;
    }

    @NotNull
    public final String getPropertyValue() {
        return this.propertyValue;
    }

    @NotNull
    public String getCommandName() {
        return "Updating or adding " + this.propertyName + " gradle property";
    }

    @NotNull
    public UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        return new UsageViewDescriptor(this){
            final /* synthetic */ GradlePropertyProcessor this$0;
            {
                this.this$0 = $receiver;
            }

            public PsiElement[] getElements() {
                Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return "Updating or adding " + this.this$0.getPropertyName() + " gradle property";
            }

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return "References to be updated or added: " + UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount);
            }
        };
    }

    @NotNull
    public UsageInfo[] findUsages() {
        PsiDirectory baseDirPsiDirectory;
        VirtualFile virtualFile = this.myProject.getBaseDir();
        if (virtualFile == null) {
            return new UsageInfo[0];
        }
        VirtualFile baseDir2 = virtualFile;
        VirtualFile gradlePropertiesVirtualFile = baseDir2.findChild("gradle.properties");
        if (gradlePropertiesVirtualFile != null && gradlePropertiesVirtualFile.exists()) {
            PsiFile gradlePropertiesPsiFile = PsiManager.getInstance((Project)this.myProject).findFile(gradlePropertiesVirtualFile);
            if (gradlePropertiesPsiFile instanceof PropertiesFile) {
                IProperty property2 = ((PropertiesFile)gradlePropertiesPsiFile).findPropertyByKey(this.propertyName);
                UsageInfo[] usageInfoArray = property2 == null ? (UsageInfo[])gradlePropertiesPsiFile : property2.getPsiElement();
                Intrinsics.checkNotNull((Object)usageInfoArray);
                UsageInfo[] psiElement = usageInfoArray;
                usageInfoArray = new UsageInfo[]{new UsageInfo((PsiElement)psiElement)};
                return usageInfoArray;
            }
        } else if (baseDir2.exists() && (baseDirPsiDirectory = PsiManager.getInstance((Project)this.myProject).findDirectory(baseDir2)) instanceof PsiElement) {
            UsageInfo[] usageInfoArray = new UsageInfo[]{new UsageInfo((PsiElement)baseDirPsiDirectory)};
            return usageInfoArray;
        }
        return new UsageInfo[0];
    }

    @VisibleForTesting
    public final void updateProjectBuildModel(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        UsageInfo[] $this$forEach$iv = usages;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            IProperty existing;
            PropertiesFile propertiesFile;
            Object object;
            UsageInfo element$iv;
            UsageInfo usage = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            PsiElement element = usage.getElement();
            if (element instanceof PsiFile) {
                var10_10 = element;
                object = var10_10 instanceof PropertiesFile ? (PropertiesFile)var10_10 : null;
            } else if (element instanceof PsiDirectory) {
                PsiFile psiFile = ((PsiDirectory)element).findFile("gradle.properties");
                if (psiFile == null) {
                    PsiFile psiFile2 = ((PsiDirectory)element).createFile("gradle.properties");
                    psiFile = psiFile2;
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"createFile(...)");
                }
                PsiFile it = psiFile;
                boolean bl2 = false;
                object = it instanceof PropertiesFile ? (PropertiesFile)it : null;
                if (object == null) {
                    continue;
                }
            } else {
                PsiElement psiElement = element;
                if (psiElement == null) continue;
                var10_10 = psiElement.getContainingFile();
                object = var10_10 instanceof PropertiesFile ? (PropertiesFile)var10_10 : null;
            }
            PropertiesFile propertiesFile2 = propertiesFile = object;
            IProperty iProperty = existing = propertiesFile2 != null ? propertiesFile2.findPropertyByKey(this.propertyName) : null;
            if (existing != null) {
                existing.setValue(this.propertyValue);
                continue;
            }
            PropertiesFile propertiesFile3 = propertiesFile;
            if (propertiesFile3 == null) continue;
            propertiesFile3.addProperty(this.propertyName, this.propertyValue);
        }
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel, (String)"get(...)");
        ProjectBuildModel projectBuildModel2 = projectBuildModel;
        projectBuildModel2.applyChanges();
    }

    public void performRefactoring(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        this.updateProjectBuildModel(usages);
        ProjectSystemUtil.getSyncManager(this.project).requestSyncProject(ProjectSystemSyncUtil.toReason(GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED));
    }
}

