/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.tools.idea.gradle.model.IdeSyncIssue;
import com.android.tools.idea.gradle.project.sync.hyperlink.EnableAndroidXHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileSyncMessageHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlSyncMessageHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.SimpleDeduplicatingSyncIssueReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueNotificationHyperlink;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014JF\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00122\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u0016H\u0014J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/gradle/project/sync/issues/AndroidXUsedReporter;", "Lcom/android/tools/idea/gradle/project/sync/issues/SimpleDeduplicatingSyncIssueReporter;", "<init>", "()V", "getSupportedIssueType", "", "shouldIncludeModuleLinks", "", "getDeduplicationKey", "", "issue", "Lcom/android/tools/idea/gradle/model/IdeSyncIssue;", "getCustomLinks", "", "Lcom/android/tools/idea/gradle/project/sync/issues/SyncIssueNotificationHyperlink;", "project", "Lcom/intellij/openapi/project/Project;", "syncIssues", "", "affectedModules", "Lcom/intellij/openapi/module/Module;", "buildFileMap", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "createQuickFixes", "propertiesPath", "Ljava/io/File;", "intellij.android.projectSystem.gradle"})
public final class AndroidXUsedReporter
extends SimpleDeduplicatingSyncIssueReporter {
    @Override
    protected int getSupportedIssueType() {
        return 40;
    }

    @Override
    protected boolean shouldIncludeModuleLinks() {
        return true;
    }

    @Override
    @NotNull
    protected Object getDeduplicationKey(@NotNull IdeSyncIssue issue2) {
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        return this.getSupportedIssueType();
    }

    @Override
    @NotNull
    protected List<SyncIssueNotificationHyperlink> getCustomLinks(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(syncIssues, (String)"syncIssues");
        Intrinsics.checkNotNullParameter(affectedModules, (String)"affectedModules");
        Intrinsics.checkNotNullParameter(buildFileMap, (String)"buildFileMap");
        File file = GradleProjectSystemUtil.getUserGradlePropertiesFile(project);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getUserGradlePropertiesFile(...)");
        return this.createQuickFixes(file);
    }

    @VisibleForTesting
    @NotNull
    public final List<SyncIssueNotificationHyperlink> createQuickFixes(@NotNull File propertiesPath) {
        Intrinsics.checkNotNullParameter((Object)propertiesPath, (String)"propertiesPath");
        List quickFixes = new ArrayList();
        quickFixes.add(new EnableAndroidXHyperlink());
        if (propertiesPath.exists()) {
            quickFixes.add(new OpenFileSyncMessageHyperlink(propertiesPath.getPath(), "Open Gradle properties file", -1, -1));
        }
        quickFixes.add(new OpenUrlSyncMessageHyperlink("https://developer.android.com/jetpack/androidx/migrate", "More information about migrating to AndroidX..."));
        return quickFixes;
    }
}

