/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.tools.idea.gradle.project.ProxySettingsDialog;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.gradle.util.GradleProperties;
import com.android.tools.idea.gradle.util.IdeGradleProxySettingsBridge;
import com.android.tools.idea.gradle.util.IdeProxyInfo;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.net.ProxyConfiguration;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpProxySettingsCleanUp {
    public static void cleanUp(@NotNull Project project) {
        GradleProperties properties;
        IdeProxyInfo ideProxyInfo = IdeProxyInfo.getInstance();
        boolean ideUsingProxy = ideProxyInfo.isHttpProxyExplicitlyConfigured();
        try {
            properties = new GradleProperties(GradleProjectSystemUtil.getUserGradlePropertiesFile(project));
        }
        catch (IOException e) {
            Logger.getInstance(HttpProxySettingsCleanUp.class).info("Failed to read gradle.properties file", (Throwable)e);
            return;
        }
        IdeGradleProxySettingsBridge gradleProxySettings = properties.getHttpProxySettings();
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> {
            ProxySettingsDialog dialog2 = HttpProxySettingsCleanUp.getDialog(project, ideProxyInfo, ideUsingProxy, properties, gradleProxySettings);
            if (dialog2 != null && dialog2.showAndGet()) {
                HttpProxySettingsCleanUp.saveProperties(project, properties, dialog2);
            }
        });
    }

    @Nullable
    private static ProxySettingsDialog getDialog(@NotNull Project project, IdeProxyInfo ideProxyInfo, boolean ideUsingProxy, GradleProperties properties, IdeGradleProxySettingsBridge gradleProxySettings) {
        ProxySettingsDialog dialog2 = null;
        if (!ideUsingProxy) {
            boolean gradleUsingProxy = StringUtil.isNotEmpty((String)gradleProxySettings.getHost());
            if (gradleUsingProxy) {
                dialog2 = new ProxySettingsDialog(project, gradleProxySettings, false);
            }
        } else if (ideProxyInfo.getSettings().getProxyConfiguration() instanceof ProxyConfiguration.ProxyAutoConfiguration) {
            if (StringUtil.isEmpty((String)gradleProxySettings.getHost()) || !properties.getProperties().containsKey("systemProp.http.proxyPort")) {
                dialog2 = new ProxySettingsDialog(project, gradleProxySettings, true);
            }
        } else {
            ProxyConfiguration.StaticProxyConfiguration staticProxyConfiguration;
            IdeGradleProxySettingsBridge ideProxySettings;
            ProxyConfiguration proxyConfiguration = ideProxyInfo.getSettings().getProxyConfiguration();
            if (proxyConfiguration instanceof ProxyConfiguration.StaticProxyConfiguration && !(ideProxySettings = new IdeGradleProxySettingsBridge(ideProxyInfo, staticProxyConfiguration = (ProxyConfiguration.StaticProxyConfiguration)proxyConfiguration)).equals(gradleProxySettings)) {
                dialog2 = new ProxySettingsDialog(project, ideProxySettings, true);
            }
        }
        return dialog2;
    }

    private static void saveProperties(@NotNull Project project, GradleProperties properties, ProxySettingsDialog dialog2) {
        boolean needsPassword = dialog2.applyProxySettings(properties.getProperties());
        try {
            properties.save();
            if (needsPassword) {
                String msg = "Proxy passwords are not defined.";
                OpenFileHyperlink openLink = new OpenFileHyperlink(GradleProjectSystemUtil.getUserGradlePropertiesFile(project).getPath());
                AndroidNotification.getInstance((Project)project).showBalloon("Proxy Settings", msg, NotificationType.WARNING, new NotificationHyperlink[]{openLink});
            }
        }
        catch (IOException e) {
            Throwable root = ExceptionUtil.getRootCause((Throwable)e);
            Object cause = root.getMessage();
            Object errMsg = "Failed to save HTTP proxy settings to gradle.properties file.";
            if (StringUtil.isNotEmpty((String)cause)) {
                if (!((String)cause).endsWith(".")) {
                    cause = (String)cause + ".";
                }
                errMsg = (String)errMsg + String.format("\nCause: %1$s", cause);
            }
            AndroidNotification notification = AndroidNotification.getInstance((Project)project);
            notification.showBalloon("Proxy Settings", (String)errMsg, NotificationType.ERROR);
            Logger.getInstance(HttpProxySettingsCleanUp.class).info("Failed to save changes to gradle.properties file", root);
        }
    }
}

