/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueNotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.processor.RemoveJcenterProcessor;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/gradle/project/sync/hyperlink/RemoveJcenterHyperlink;", "Lcom/android/tools/idea/gradle/project/sync/issues/SyncIssueNotificationHyperlink;", "project", "Lcom/intellij/openapi/project/Project;", "affectedModules", "", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getAffectedModules", "()Ljava/util/List;", "execute", "", "applyFix", "processor", "Lcom/android/tools/idea/gradle/project/sync/issues/processor/RemoveJcenterProcessor;", "Companion", "intellij.android.projectSystem.gradle"})
public final class RemoveJcenterHyperlink
extends SyncIssueNotificationHyperlink {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<Module> affectedModules;

    public RemoveJcenterHyperlink(@NotNull Project project, @NotNull List<? extends Module> affectedModules) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(affectedModules, (String)"affectedModules");
        super("remove.jcenter.hyperlink", "Remove JCenter from repositories", AndroidStudioEvent.GradleSyncQuickFix.REMOVE_JCENTER_HYPERLINK);
        this.project = project;
        this.affectedModules = affectedModules;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<Module> getAffectedModules() {
        return this.affectedModules;
    }

    @Override
    protected void execute(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.applyFix(project, new RemoveJcenterProcessor(project, this.affectedModules));
    }

    @VisibleForTesting
    public final void applyFix(@NotNull Project project, @NotNull RemoveJcenterProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
        if (!Companion.canBeApplied(project, this.affectedModules)) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                Messages.showWarningDialog((Project)project, (String)"Could not identify where to apply this fix", (String)"Remove JCenter Quickfix");
            }
            return;
        }
        processor.setPreviewUsages(true);
        processor.run();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/gradle/project/sync/hyperlink/RemoveJcenterHyperlink$Companion;", "", "<init>", "()V", "canBeApplied", "", "project", "Lcom/intellij/openapi/project/Project;", "affectedModules", "", "Lcom/intellij/openapi/module/Module;", "intellij.android.projectSystem.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean canBeApplied(@NotNull Project project, @NotNull List<? extends Module> affectedModules) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(affectedModules, (String)"affectedModules");
            ProjectBuildModel projectBuildModel = ProjectBuildModel.getOrLog(project);
            if (projectBuildModel == null) {
                return false;
            }
            ProjectBuildModel projectBuildModel2 = projectBuildModel;
            GradleBuildModel buildModel = projectBuildModel2.getProjectBuildModel();
            if (buildModel != null && buildModel.buildscript().repositories().containsMethodCall("jcenter")) {
                return true;
            }
            GradleSettingsModel settingsModel = projectBuildModel2.getProjectSettingsModel();
            if (settingsModel != null && settingsModel.dependencyResolutionManagement().repositories().containsMethodCall("jcenter")) {
                return true;
            }
            for (Module module : affectedModules) {
                GradleBuildModel moduleModel;
                if (projectBuildModel2.getModuleBuildModel(module) == null || !moduleModel.repositories().containsMethodCall("jcenter")) continue;
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

