/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.project.sync.errors.InstallPlatformQuickFix;
import com.android.tools.idea.gradle.project.sync.errors.MissingPlatformIssueCheckerKt;
import com.android.tools.idea.gradle.project.sync.errors.OpenAndroidSdkManagerQuickFix;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.issues.SyncFailureUsageReporter;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.projectsystem.AndroidProjectRootUtil;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.sdk.AndroidSdkData;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import java.util.Collection;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016JD\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00140\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/MissingPlatformIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "<init>", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "intellij.android.projectSystem.gradle"})
public final class MissingPlatformIssueChecker
implements GradleIssueChecker {
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        AndroidVersion version2;
        AndroidSdkHandler sdkHandler;
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        String string = rootCause.getMessage();
        if (string == null) {
            return null;
        }
        String message = string;
        String missingPlatform = MissingPlatformIssueCheckerKt.getMissingPlatform(message);
        if (StringsKt.isBlank((CharSequence)message) || missingPlatform == null || !(rootCause instanceof IllegalStateException) && !(rootCause instanceof ExternalSystemException)) {
            return null;
        }
        SyncFailureUsageReporter.Companion.getInstance().collectFailure(issueData.getProjectPath(), AndroidStudioEvent.GradleSyncFailure.MISSING_ANDROID_PLATFORM);
        BuildIssueComposer buildIssueComposer = new BuildIssueComposer(message, null, 2, null);
        AndroidSdkData androidSdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        Object object = sdkHandler = androidSdkData != null ? androidSdkData.getSdkHandler() : null;
        if (sdkHandler != null && (version2 = AndroidTargetHash.getPlatformVersion((String)missingPlatform)) != null) {
            String causes;
            StudioLoggerProgressIndicator logger = new StudioLoggerProgressIndicator(this.getClass());
            String string2 = causes = sdkHandler.getAndroidTargetManager((ProgressIndicator)logger).getErrorForPackage(DetailsTypes.getPlatformPath((AndroidVersion)version2));
            buildIssueComposer.addDescriptionOnNewLine((String)(string2 != null ? "possible cause: \n " + string2 : ""));
            buildIssueComposer.startNewParagraph();
            buildIssueComposer.addQuickFix("Install missing platform(s) and sync project", new InstallPlatformQuickFix(CollectionsKt.listOf((Object)version2)));
        }
        if (buildIssueComposer.getIssueQuickFixes().isEmpty()) {
            boolean projectFound = false;
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            for (Project project : projectArray) {
                Intrinsics.checkNotNull((Object)project);
                Project project2 = project;
                for (Module module : ModuleManager.Companion.getInstance(project2).getModules()) {
                    Collection facets;
                    if (!Intrinsics.areEqual((Object)AndroidProjectRootUtil.getModuleDirPath(module), (Object)issueData.getProjectPath())) continue;
                    projectFound = true;
                    Intrinsics.checkNotNullExpressionValue((Object)FacetManager.getInstance((Module)module).getFacetsByType(AndroidFacet.ID), (String)"getFacetsByType(...)");
                    if (!(!facets.isEmpty())) break;
                    buildIssueComposer.addQuickFix("Open Android SDK Manager", new OpenAndroidSdkManagerQuickFix());
                    break;
                }
                if (projectFound) break;
            }
        }
        return buildIssueComposer.composeBuildIssue();
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return stacktrace != null && (MissingPlatformIssueCheckerKt.access$getILLEGAL_STATE_TRACE_PATTERN$p().matcher(stacktrace).find() || MissingPlatformIssueCheckerKt.access$getEXTERNAL_SYSTEM_EXCEPTION_PATTERN$p().matcher(stacktrace).find()) && MissingPlatformIssueCheckerKt.getMissingPlatform(failureCause) != null;
    }
}

