/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.quickFixes.OpenLinkQuickFix;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.gradle.tooling.BuildException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016JD\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00180\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/DuplicateClassIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "<init>", "()V", "HREF", "", "SUFFIX_8_7", "SUFFIX_OLD", "DUPLICATE_CLASS", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "intellij.android.projectSystem.gradle"})
public final class DuplicateClassIssueChecker
implements GradleIssueChecker {
    @NotNull
    private final String HREF;
    @NotNull
    private final String SUFFIX_8_7;
    @NotNull
    private final String SUFFIX_OLD;
    @NotNull
    private final String DUPLICATE_CLASS;

    public DuplicateClassIssueChecker() {
        this.HREF = "d.android.com/r/tools/classpath-sync-errors";
        this.SUFFIX_8_7 = "Learn how to fix dependency resolution errors at https://d.android.com/r/tools/classpath-sync-errors";
        this.SUFFIX_OLD = "Go to the documentation to learn how to <a href=\"" + this.HREF + "\">Fix dependency resolution errors</a>.";
        this.DUPLICATE_CLASS = "Duplicate class ";
    }

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        if (!(issueData.getError() instanceof BuildException)) {
            return null;
        }
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        if (!(rootCause instanceof RuntimeException)) {
            return null;
        }
        Ref.ObjectRef message = new Ref.ObjectRef();
        String string = ((RuntimeException)rootCause).getMessage();
        if (string == null) {
            return null;
        }
        message.element = string;
        if (StringsKt.startsWith$default((String)((String)message.element), (String)this.DUPLICATE_CLASS, (boolean)false, (int)2, null)) {
            if (StringsKt.endsWith$default((String)((String)message.element), (String)this.SUFFIX_OLD, (boolean)false, (int)2, null)) {
                OpenLinkQuickFix urlLink = new OpenLinkQuickFix("http://" + this.HREF);
                message.element = StringsKt.replace$default((String)((String)message.element), (String)this.HREF, (String)urlLink.getId(), (boolean)false, (int)4, null);
                return new BuildIssue((Ref.ObjectRef<String>)message, urlLink){
                    private final String title;
                    private final String description;
                    private final List<OpenLinkQuickFix> quickFixes;
                    {
                        this.title = "Duplicate class found";
                        this.description = (String)$message.element;
                        this.quickFixes = CollectionsKt.listOf((Object)$urlLink);
                    }

                    public String getTitle() {
                        return this.title;
                    }

                    public String getDescription() {
                        return this.description;
                    }

                    public List<OpenLinkQuickFix> getQuickFixes() {
                        return this.quickFixes;
                    }

                    public Navigatable getNavigatable(Project project) {
                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                        return null;
                    }
                };
            }
            if (StringsKt.endsWith$default((String)((String)message.element), (String)this.SUFFIX_8_7, (boolean)false, (int)2, null)) {
                return new BuildIssue((Ref.ObjectRef<String>)message){
                    private final String title;
                    private final String description;
                    private final List<BuildIssueQuickFix> quickFixes;
                    {
                        this.title = "Duplicate class found";
                        this.description = (String)$message.element;
                        this.quickFixes = CollectionsKt.emptyList();
                    }

                    public String getTitle() {
                        return this.title;
                    }

                    public String getDescription() {
                        return this.description;
                    }

                    public List<BuildIssueQuickFix> getQuickFixes() {
                        return this.quickFixes;
                    }

                    public Navigatable getNavigatable(Project project) {
                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                        return null;
                    }
                };
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean consumeBuildOutputFailureMessage(@NotNull String message, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        if (!StringsKt.startsWith$default((String)failureCause, (String)this.DUPLICATE_CLASS, (boolean)false, (int)2, null)) return false;
        if (!(parentEventId instanceof String)) return false;
        String string = (String)parentEventId;
        if (string == null) return false;
        if (!StringsKt.endsWith$default((String)string, (String)":checkDebugDuplicateClasses", (boolean)false, (int)2, null)) return false;
        return true;
    }
}

