/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.AarDependencyCompatibilityIssue;
import com.android.tools.idea.gradle.project.sync.errors.AarDependencyCompatibilityIssueChecker;
import com.android.tools.idea.gradle.project.sync.errors.AarDependencyCompatibilityIssueCheckerKt;
import com.android.tools.idea.gradle.project.sync.errors.UpdateCompileSdkQuickFix;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.intellij.build.issue.BuildIssue;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/AarDependencyCompatibilityIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "<init>", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "intellij.android.projectSystem.gradle"})
public final class AarDependencyCompatibilityIssueChecker
implements GradleIssueChecker {
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        Throwable throwable = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        if (throwable == null) {
            return null;
        }
        Throwable rootCause = throwable;
        if (!(rootCause instanceof RuntimeException)) {
            return null;
        }
        String string = rootCause.getMessage();
        if (string == null) {
            return null;
        }
        String rootMessage = string;
        BuildIssueComposer issueComposer = new BuildIssueComposer(rootMessage, "Aar Dependency compatibility issues");
        Map modulesWithSuggestedMinCompileSdk = new LinkedHashMap();
        for (MatchResult matchResult = Regex.find$default((Regex)AarDependencyCompatibilityIssueCheckerKt.access$getCOMPILE_SDK_ISSUE_REGEX$p(), (CharSequence)rootMessage, (int)0, (int)2, null); matchResult != null; matchResult = matchResult.next()) {
            Integer suggestedMinCompileSdk;
            String modulePath;
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"modulePath");
            String string2 = modulePath = matchGroup != null ? matchGroup.getValue() : null;
            if (modulePath == null) continue;
            Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"minCompileSdk");
            Integer n = object != null && (object = object.getValue()) != null ? StringsKt.toIntOrNull((String)object) : (suggestedMinCompileSdk = null);
            if (suggestedMinCompileSdk == null) continue;
            modulesWithSuggestedMinCompileSdk.merge(modulePath, suggestedMinCompileSdk, (arg_0, arg_1) -> AarDependencyCompatibilityIssueChecker.check$lambda$0(check.1.INSTANCE, arg_0, arg_1));
        }
        if (modulesWithSuggestedMinCompileSdk.isEmpty()) {
            return null;
        }
        issueComposer.addQuickFix(new UpdateCompileSdkQuickFix(modulesWithSuggestedMinCompileSdk));
        return new AarDependencyCompatibilityIssue(issueComposer.composeBuildIssue());
    }

    private static final Integer check$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }
}

