/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.common;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.filters.AndroidGradleExecutionConsoleManager;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.project.build.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.project.common.GradleInitScripts;
import com.android.tools.idea.gradle.project.sync.idea.AndroidGradleProjectResolverKeys;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.GradleInvocationParams;
import com.android.tools.idea.ui.GuiTestingService;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandLineArgs {
    private static Key<String[]> GRADLE_SYNC_COMMAND_LINE_OPTIONS_KEY = Key.create((String)"gradle.sync.command.line.options");
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final GradleInitScripts myInitScripts;

    public CommandLineArgs() {
        this(IdeInfo.getInstance(), GradleInitScripts.getInstance());
    }

    @VisibleForTesting
    CommandLineArgs(@NotNull IdeInfo ideInfo, @NotNull GradleInitScripts initScripts) {
        this.myIdeInfo = ideInfo;
        this.myInitScripts = initScripts;
    }

    @NotNull
    public List<String> get(@Nullable Project project) {
        Boolean refreshExternalNativeModels;
        ArrayList<String> args = new ArrayList<String>();
        this.myInitScripts.addAndroidStudioToolingPluginInitScriptCommandLineArg(args);
        args.add("-Djava.awt.headless=true");
        if (project != null) {
            String[] extraOptions = (String[])project.getUserData(AndroidGradleExecutionConsoleManager.EXTRA_GRADLE_COMMAND_LINE_OPTIONS_KEY);
            if (extraOptions != null) {
                project.putUserData(AndroidGradleExecutionConsoleManager.EXTRA_GRADLE_COMMAND_LINE_OPTIONS_KEY, null);
                Collections.addAll(args, extraOptions);
            }
            AndroidGradleBuildConfiguration buildConfiguration = AndroidGradleBuildConfiguration.getInstance(project);
            Collections.addAll(args, buildConfiguration.getCommandLineOptions());
        }
        args.add("--stacktrace");
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.model.only", (boolean)true));
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.model.only.advanced", (boolean)true));
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.invoked.from.ide", (boolean)true));
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.model.only.versioned", (int)3));
        GradleInvocationParams.addAndroidStudioPluginVersion(args);
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.model.disable.src.download", (boolean)true));
        args.add(AndroidGradleSettings.createProjectProperty((String)"idea.gradle.do.not.build.tasks", (boolean)GradleExperimentalSettings.getInstance().SKIP_GRADLE_TASKS_LIST));
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.avoid.task.registration", (boolean)GradleExperimentalSettings.getInstance().SKIP_GRADLE_TASKS_LIST));
        if (this.myIdeInfo.isAndroidStudio()) {
            args.add(AndroidGradleSettings.createJvmArg((String)"org.gradle.internal.GradleProjectBuilderOptions", (String)"omit_all_tasks"));
        }
        if (project != null && (refreshExternalNativeModels = (Boolean)project.getUserData(AndroidGradleProjectResolverKeys.REFRESH_EXTERNAL_NATIVE_MODELS_KEY)) != null) {
            project.putUserData(AndroidGradleProjectResolverKeys.REFRESH_EXTERNAL_NATIVE_MODELS_KEY, null);
            args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.refresh.external.native.model", (boolean)refreshExternalNativeModels));
        }
        Application application = ApplicationManager.getApplication();
        boolean isTestingMode = GuiTestingService.isInTestingMode();
        if (isTestingMode) {
            application.putUserData(GRADLE_SYNC_COMMAND_LINE_OPTIONS_KEY, (Object)ArrayUtil.toStringArray(args));
        } else {
            this.myInitScripts.addLocalMavenRepoInitScriptCommandLineArg(args);
        }
        return args;
    }
}

