/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.output;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CmakeOutputParser
implements BuildOutputParser {
    static final String CMAKE = "CMake";
    private static final String ERROR = "Error";
    private static final String CMAKE_ERROR = "CMake Error";
    private final Pattern cmakeErrorOrWarning = Pattern.compile("^\\s*CMake (Error|Warning).+");
    static final Pattern fileAndLineNumber = Pattern.compile("^(([A-Za-z]:)?.*):([0-9]+)? *:([0-9]+)?(.+)?");
    static final Pattern errorFileAndLineNumber = Pattern.compile("CMake (Error|Warning).*at (([A-Za-z]:)?[^:]+):([0-9]+)?.*(\\([^:]*\\))?:([0-9]+)?(.+)?");
    private static final int SOURCE_POSITION_OFFSET = -1;

    public boolean parse(String line, BuildOutputInstantReader reader2, Consumer<? super BuildEvent> messageConsumer) {
        if (this.cmakeErrorOrWarning.matcher(line).matches()) {
            String nextLine;
            ArrayList<String> messages = new ArrayList<String>();
            messages.add(line.trim());
            while ((nextLine = reader2.readLine()) != null) {
                if (nextLine.isEmpty() || this.cmakeErrorOrWarning.matcher(nextLine).matches()) {
                    reader2.pushBack();
                    break;
                }
                if ((nextLine = nextLine.trim()).isEmpty()) continue;
                messages.add(nextLine);
            }
            if (CmakeOutputParser.matchesErrorFileAndLineNumberError(messages, reader2.getParentEventId(), messageConsumer) || CmakeOutputParser.matchesFileAndLineNumberError(messages, reader2.getParentEventId(), messageConsumer)) {
                return true;
            }
            if (((String)messages.get(0)).startsWith(CMAKE_ERROR)) {
                messageConsumer.accept((BuildEvent)new MessageEventImpl(reader2.getParentEventId(), MessageEvent.Kind.ERROR, "CMake errors", String.join((CharSequence)" ", messages), String.join((CharSequence)"\n", messages)));
            } else {
                messageConsumer.accept((BuildEvent)new MessageEventImpl(reader2.getParentEventId(), MessageEvent.Kind.WARNING, "CMake warnings", String.join((CharSequence)" ", messages), String.join((CharSequence)"\n", messages)));
            }
            return true;
        }
        return false;
    }

    private static boolean matchesFileAndLineNumberError(List<String> messages, Object buildId, Consumer<? super BuildEvent> messageConsumer) {
        String fullMessage = String.join((CharSequence)" ", messages);
        Matcher matcher = fileAndLineNumber.matcher(fullMessage);
        if (matcher.matches()) {
            File file = new File(matcher.group(1));
            ErrorFields fields2 = CmakeOutputParser.matchFileAndLineNumberErrorParts(matcher, fullMessage);
            fields2.kind = fullMessage.contains(CMAKE_ERROR) ? MessageEvent.Kind.ERROR : MessageEvent.Kind.WARNING;
            FilePosition position = new FilePosition(file, fields2.lineNumber + -1, fields2.columnNumber + -1);
            messageConsumer.accept((BuildEvent)new FileMessageEventImpl(buildId, fields2.kind, CMAKE + (fields2.kind == MessageEvent.Kind.ERROR ? " errors" : " warnings"), fields2.errorMessage, String.join((CharSequence)"\n", messages), position));
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static ErrorFields matchFileAndLineNumberErrorParts(Matcher matcher, String line) {
        ErrorFields fields2 = new ErrorFields();
        fields2.lineNumber = -1;
        if (matcher.group(3) != null) {
            fields2.lineNumber = Integer.valueOf(matcher.group(3));
        }
        fields2.columnNumber = -1;
        if (matcher.group(4) != null) {
            fields2.columnNumber = Integer.valueOf(matcher.group(4));
        }
        fields2.errorMessage = line;
        if (matcher.group(5) != null) {
            fields2.errorMessage = matcher.group(5);
        }
        return fields2;
    }

    private static boolean matchesErrorFileAndLineNumberError(List<String> messages, Object buildId, Consumer<? super BuildEvent> messageConsumer) {
        String fullMessage = String.join((CharSequence)" ", messages);
        Matcher matcher = errorFileAndLineNumber.matcher(fullMessage);
        if (matcher.matches()) {
            File file = new File(matcher.group(2));
            ErrorFields fields2 = CmakeOutputParser.matchErrorFileAndLineNumberErrorParts(matcher, fullMessage);
            FilePosition position = new FilePosition(file, fields2.lineNumber + -1, fields2.columnNumber + -1);
            messageConsumer.accept((BuildEvent)new FileMessageEventImpl(buildId, fields2.kind, CMAKE + (fields2.kind == MessageEvent.Kind.ERROR ? " errors" : " warnings"), fields2.errorMessage, String.join((CharSequence)"\n", messages), position));
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static ErrorFields matchErrorFileAndLineNumberErrorParts(Matcher matcher, String line) {
        ErrorFields fields2 = new ErrorFields();
        fields2.kind = MessageEvent.Kind.WARNING;
        if (matcher.group(1).equals(ERROR)) {
            fields2.kind = MessageEvent.Kind.ERROR;
        }
        fields2.lineNumber = 0;
        if (matcher.group(4) != null) {
            fields2.lineNumber = Integer.valueOf(matcher.group(4));
        }
        fields2.columnNumber = 0;
        if (matcher.group(6) != null) {
            fields2.columnNumber = Integer.valueOf(matcher.group(6));
        }
        fields2.errorMessage = line;
        if (matcher.group(7) != null) {
            fields2.errorMessage = matcher.group(7).trim();
        }
        return fields2;
    }

    static class ErrorFields {
        MessageEvent.Kind kind;
        int lineNumber;
        int columnNumber;
        String errorMessage;

        ErrorFields() {
        }
    }
}

