/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.LinkedAndroidModuleGroupUtilsKt;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class ProjectStructure {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object myLock = new Object();
    @NotNull
    private AndroidPluginVersionsInProject myPluginVersionsInProject = new AndroidPluginVersionsInProject();
    @NotNull
    private final List<Module> myAppHolderModules = new ArrayList<Module>();

    @NotNull
    public static ProjectStructure getInstance(@NotNull Project project) {
        return (ProjectStructure)project.getService(ProjectStructure.class);
    }

    private ProjectStructure(@NotNull Project project) {
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeProjectStructure() {
        AndroidPluginVersionsInProject pluginVersionsInProject = new AndroidPluginVersionsInProject();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        ArrayList<Module> appHolderModules = new ArrayList<Module>();
        for (Module module : moduleManager.getModules()) {
            GradleAndroidModel androidModel = GradleAndroidModel.get(module);
            if (androidModel == null) continue;
            pluginVersionsInProject.add(androidModel);
            if (!ProjectStructure.isApp(module) || !LinkedAndroidModuleGroupUtilsKt.isHolderModule(module)) continue;
            appHolderModules.add(module);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myPluginVersionsInProject = pluginVersionsInProject;
            this.myAppHolderModules.clear();
            this.myAppHolderModules.addAll(appHolderModules);
        }
    }

    private static boolean isApp(@NotNull Module module) {
        AndroidModuleSystem.Type projectType = ProjectSystemUtil.getModuleSystem(module).getType();
        return projectType == AndroidModuleSystem.Type.TYPE_APP || projectType == AndroidModuleSystem.Type.TYPE_INSTANTAPP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public AndroidPluginVersionsInProject getAndroidPluginVersions() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myPluginVersionsInProject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ImmutableList<Module> getAppHolderModules() {
        Object object = this.myLock;
        synchronized (object) {
            return ImmutableList.copyOf(this.myAppHolderModules);
        }
    }

    public static boolean isAndroidOrJavaHolderModule(@NotNull Module module) {
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return false;
        }
        return ExternalSystemApiUtil.getExternalModuleType((Module)module) == null;
    }

    public static class AndroidPluginVersionsInProject {
        @NotNull
        private final Set<AgpVersion> myAgpVersions = new HashSet<AgpVersion>();

        private void add(@NotNull GradleAndroidModel androidModel) {
            AgpVersion modelVersion = androidModel.getAgpVersion();
            this.add(modelVersion);
        }

        @VisibleForTesting
        private void add(@NotNull AgpVersion modelVersion) {
            this.myAgpVersions.add(modelVersion);
        }

        @NotNull
        public List<AgpVersion> getAllVersions() {
            return new ArrayList<AgpVersion>(this.myAgpVersions);
        }
    }
}

