/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GradleProjectDependencyParser {
    @NotNull
    public static Function<VirtualFile, Iterable<String>> newInstance(final @NotNull Project project) {
        return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<VirtualFile, Iterable<String>>(){

            public Iterable<String> load(@NotNull VirtualFile key) throws Exception {
                return GradleProjectDependencyParser.parse(key, project);
            }
        });
    }

    @NotNull
    private static Set<String> parse(@NotNull VirtualFile moduleRoot, @NotNull Project project) {
        VirtualFile buildFile = GradleProjectSystemUtil.findGradleBuildFile(moduleRoot);
        if (buildFile == null) {
            return Collections.emptySet();
        }
        HashSet result2 = Sets.newHashSet();
        ProjectBuildModel projectModel = ProjectBuildModel.getOrLog(project);
        if (projectModel != null) {
            GradleBuildModel buildModel = projectModel.getModuleBuildModel(buildFile);
            DependenciesModel dependenciesModel = buildModel.dependencies();
            for (ModuleDependencyModel dependency : dependenciesModel.modules()) {
                String modulePath = dependency.path().forceString();
                result2.add(modulePath);
            }
        }
        return result2;
    }
}

