/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.files;

import com.android.tools.idea.gradle.dsl.api.BuildModelNotification;
import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.GradleDslTransformerFactory;
import com.android.tools.idea.gradle.dsl.parser.GradleDslWriter;
import com.android.tools.idea.gradle.dsl.parser.elements.ElementState;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementEnum;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslGlobalValue;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GradleDslFile
extends GradlePropertiesDslElement {
    private static final Logger LOG = Logger.getInstance(GradleDslFile.class);
    @NotNull
    protected final GradlePropertiesDslElement.ElementList myGlobalProperties = new GradlePropertiesDslElement.ElementList();
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleDslWriter myGradleDslWriter;
    @NotNull
    protected final GradleDslParser myGradleDslParser;
    @NotNull
    private final BuildModelContext myBuildModelContext;

    protected GradleDslFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName, @NotNull BuildModelContext context) {
        super(null, null, GradleNameElement.fake(moduleName));
        this.myFile = file;
        this.myProject = project;
        this.myBuildModelContext = context;
        Application application = ApplicationManager.getApplication();
        PsiFile psiFile = (PsiFile)application.runReadAction(() -> PsiManager.getInstance((Project)this.myProject).findFile(this.myFile));
        List factories = GradleDslTransformerFactory.EXTENSION_POINT_NAME.getExtensionList();
        boolean foundFactory = false;
        @NotNull GradleDslParser dslParser = new GradleDslParser.Adapter(context);
        @NotNull GradleDslWriter dslWriter = new GradleDslWriter.Adapter(context);
        if (psiFile == null) {
            LOG.debug("Failed to find psiFile for virtualFile " + this.myFile.getName());
        } else {
            for (GradleDslTransformerFactory factory2 : factories) {
                if (!factory2.canTransform(psiFile)) continue;
                dslParser = factory2.createParser(psiFile, context, this);
                dslWriter = factory2.createWriter(context);
                this.setPsiElement((PsiElement)psiFile);
                foundFactory = true;
                break;
            }
            if (!foundFactory) {
                LOG.debug("Failed to find transformer for file " + psiFile.getName() + " (" + psiFile.getClass().getCanonicalName() + ")");
            }
        }
        this.myGradleDslWriter = dslWriter;
        this.myGradleDslParser = dslParser;
        this.populateGlobalProperties();
    }

    private void populateGlobalProperties() {
        GradleDslGlobalValue rootDir = new GradleDslGlobalValue((GradleDslElement)this, new File(FileUtil.toCanonicalPath((String)Optional.ofNullable(this.myProject.getBasePath()).orElse(""))).getPath(), "rootDir");
        this.myGlobalProperties.addElement(rootDir, ElementState.DEFAULT, false);
        GradleDslGlobalValue projectDir = new GradleDslGlobalValue((GradleDslElement)this, this.getDirectoryPath().getPath(), "projectDir");
        this.myGlobalProperties.addElement(projectDir, ElementState.DEFAULT, false);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Arrays.asList("1_1", "1_2", "1_3", "1_4", "1_5", "1_6", "1_7", "1_8", "1_9", "1_10", "11", "12", "13", "HIGHER").forEach(s -> builder.put((Object)("VERSION_" + s), (Object)("JavaVersion.VERSION_" + s)));
        ImmutableMap javaVersionValues = builder.build();
        GradleDslElementEnum javaVersion = new GradleDslElementEnum((GradleDslElement)this, GradleNameElement.fake("JavaVersion"), (Map<String, String>)javaVersionValues);
        this.myGlobalProperties.addElement(javaVersion, ElementState.DEFAULT, false);
    }

    @Override
    protected GradleDslElement getElementWhere(@NotNull Predicate<GradlePropertiesDslElement.ElementList.ElementItem> predicate) {
        GradleDslElement result2 = super.getElementWhere(predicate);
        if (result2 == null) {
            result2 = this.myGlobalProperties.getElementWhere(predicate);
        }
        return result2;
    }

    @Override
    protected GradleDslElement getElementBeforeChildWhere(Predicate<GradlePropertiesDslElement.ElementList.ElementItem> predicate, @NotNull GradleDslElement element, boolean includeSelf) {
        GradleDslElement result2 = super.getElementBeforeChildWhere(predicate, element, includeSelf);
        if (result2 == null) {
            result2 = this.myGlobalProperties.getElementBeforeChildWhere(predicate, element, includeSelf);
        }
        return result2;
    }

    public void reparse() {
        this.clear();
        this.parse();
    }

    public void parse() {
        this.myGradleDslParser.parse();
        this.getContext().getDependencyManager().resolveAllIn(this, true);
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @NotNull
    public File getDirectoryPath() {
        return VfsUtilCore.virtualToIoFile((VirtualFile)this.getFile().getParent());
    }

    @NotNull
    public GradleDslWriter getWriter() {
        return this.myGradleDslWriter;
    }

    @NotNull
    public GradleDslParser getParser() {
        return this.myGradleDslParser;
    }

    @NotNull
    public BuildModelContext getContext() {
        return this.myBuildModelContext;
    }

    @NotNull
    public List<BuildModelNotification> getPublicNotifications() {
        return this.myBuildModelContext.getPublicNotifications(this);
    }

    public void saveAllChanges() {
        PsiElement element = this.getPsiElement();
        if (element == null) {
            return;
        }
        assert (element instanceof PsiFile);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject());
        Document document = psiDocumentManager.getDocument((PsiFile)element);
        if (document == null) {
            return;
        }
        if (psiDocumentManager.isDocumentBlockedByPsi(document)) {
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
        }
        FileDocumentManager.getInstance().saveDocument(document);
        if (!psiDocumentManager.isCommitted(document)) {
            psiDocumentManager.commitDocument(document);
        }
    }

    @Nullable
    public VirtualFile tryToFindSettingsFile() {
        if (this instanceof GradleSettingsFile) {
            return this.getFile();
        }
        for (VirtualFile buildFileParent = this.getFile().getParent(); buildFileParent != null; buildFileParent = buildFileParent.getParent()) {
            VirtualFile maybeSettingsFile = this.myBuildModelContext.getGradleSettingsFile(VfsUtilCore.virtualToIoFile((VirtualFile)buildFileParent));
            if (maybeSettingsFile == null) continue;
            return maybeSettingsFile;
        }
        return null;
    }
}

