/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.GradleDslNameConverter;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class GradleNameElement {
    @NotNull
    public static final Pattern INDEX_PATTERN = Pattern.compile("\\[(.+?)\\]|(.+?)(?=\\[)");
    @Nullable
    private PsiElement myNameElement;
    @Nullable
    private String myLocalName;
    @Nullable
    private String myFakeName;
    @Nullable
    private String myName = null;
    @Nullable
    private String myOriginalName;

    @NotNull
    public static GradleNameElement from(@NotNull PsiElement element, GradleDslNameConverter converter) {
        return new GradleNameElement(element, converter);
    }

    @NotNull
    public static GradleNameElement empty() {
        return new GradleNameElement(null, null);
    }

    @NotNull
    public static GradleNameElement create(@NotNull String name2) {
        return new GradleNameElement(GradleNameElement.escape(name2), false);
    }

    @NotNull
    public static GradleNameElement fake(@NotNull String name2) {
        return new GradleNameElement(name2, true);
    }

    @NotNull
    public static GradleNameElement copy(@NotNull GradleNameElement element) {
        return new GradleNameElement(element);
    }

    private GradleNameElement(@Nullable PsiElement element, GradleDslNameConverter converter) {
        this.setUpFrom(element, converter);
    }

    private GradleNameElement(@NotNull String name2, boolean isFake) {
        if (isFake) {
            this.myFakeName = name2;
        } else {
            this.myLocalName = name2;
        }
        this.myOriginalName = name2;
    }

    private GradleNameElement(@NotNull GradleNameElement element) {
        this.myLocalName = element.myLocalName;
        this.myFakeName = element.myFakeName;
        this.myOriginalName = element.myOriginalName;
    }

    public void commitNameChange(@Nullable PsiElement nameElement, GradleDslNameConverter converter, GradleDslElement context) {
        this.setUpFrom(nameElement, converter);
        ModelPropertyDescription property2 = converter.modelDescriptionForParent(this.fullName(), context);
        if (property2 == null) {
            this.rename(this.fullNameParts());
        } else {
            this.rename(property2.name);
        }
        this.myOriginalName = this.findName();
    }

    @NotNull
    public String fullName() {
        List<String> parts = this.fullNameParts();
        return GradleNameElement.createNameFromParts(parts);
    }

    @NotNull
    public @Unmodifiable List<String> fullNameParts() {
        String name2 = this.findName();
        if (name2 == null) {
            return new ArrayList<String>();
        }
        List<String> nameSegments = GradleNameElement.split(name2);
        return ContainerUtil.map(nameSegments, GradleNameElement::convertNameToKey);
    }

    public static String createNameFromParts(@NotNull @Unmodifiable List<String> parts) {
        return GradleNameElement.join(parts);
    }

    @NotNull
    public @Unmodifiable List<String> qualifyingParts() {
        List<String> parts = this.fullNameParts();
        if (parts.isEmpty()) {
            return parts;
        }
        return parts.subList(0, parts.size() - 1);
    }

    public boolean isQualified() {
        List<String> parts = this.fullNameParts();
        return parts.size() > 1;
    }

    @NotNull
    public String name() {
        List<String> parts = this.fullNameParts();
        if (parts.isEmpty()) {
            return "";
        }
        return parts.get(parts.size() - 1);
    }

    @Nullable
    public PsiElement getNamedPsiElement() {
        return this.myNameElement;
    }

    @Nullable
    public String getLocalName() {
        return this.myLocalName;
    }

    @Nullable
    public String getOriginalName() {
        return this.myOriginalName;
    }

    private void internalRename(@NotNull String newName) {
        if (!this.isFake()) {
            this.myLocalName = newName;
        } else {
            this.myFakeName = newName;
        }
        this.myName = null;
    }

    public void rename(@NotNull String newName) {
        this.internalRename(GradleNameElement.escape(newName));
    }

    public void rename(@NotNull List<String> hierarchicalName) {
        this.internalRename(GradleNameElement.join(hierarchicalName));
    }

    public boolean isEmpty() {
        String name2 = this.findName();
        return name2 == null || name2.isEmpty();
    }

    public boolean isFake() {
        return this.myNameElement == null && this.myFakeName != null;
    }

    @NotNull
    public String toString() {
        return this.fullName();
    }

    public boolean isReferencedIn(@NotNull String propertyReference) {
        String indexName;
        String name2 = this.name();
        if (propertyReference.equals(name2)) {
            return true;
        }
        Matcher matcher = INDEX_PATTERN.matcher(propertyReference);
        if (matcher.find() && matcher.groupCount() > 0 && (indexName = matcher.group(0)).equals(name2)) {
            return true;
        }
        List<String> parts = GradleNameElement.split(propertyReference);
        if (!parts.isEmpty() && parts.get(0).equals(name2)) {
            return true;
        }
        return parts.size() > 1 && parts.get(0).equals(ExtDslElement.EXT.name) && parts.get(1).equals(name2);
    }

    @Nullable
    private String findName() {
        if (this.myName != null) {
            return this.myName;
        }
        String name2 = null;
        if (this.myLocalName != null) {
            name2 = this.myLocalName;
        }
        if (name2 == null && this.myFakeName != null) {
            name2 = this.myFakeName;
        }
        this.myName = name2;
        return name2;
    }

    @NotNull
    public static String convertNameToKey(@NotNull String str) {
        return StringUtil.unquoteString((String)str);
    }

    @NotNull
    public static String escape(@NotNull String part) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < part.length(); ++i) {
            char c = part.charAt(i);
            if (c == '.' || c == '\\') {
                buf.append('\\');
            }
            buf.append(c);
        }
        String result2 = buf.toString();
        return result2;
    }

    @NotNull
    public static String unescape(@NotNull String part) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < part.length(); ++i) {
            char c = part.charAt(i);
            if (c == '\\') {
                assert (i < part.length() - 1);
                buf.append(part.charAt(++i));
                continue;
            }
            buf.append(c);
        }
        String result2 = buf.toString();
        return result2;
    }

    @NotNull
    public static String join(@NotNull List<String> parts) {
        String result2 = parts.stream().map(GradleNameElement::escape).collect(Collectors.joining("."));
        return result2;
    }

    @NotNull
    public static List<String> split(@NotNull String name2) {
        StringBuilder buf = new StringBuilder();
        ArrayList<String> result2 = new ArrayList<String>();
        for (int i = 0; i < name2.length(); ++i) {
            char c = name2.charAt(i);
            if (c == '\\') {
                assert (i < name2.length() - 1);
                buf.append(name2.charAt(++i));
                continue;
            }
            if (c == '.') {
                result2.add(buf.toString());
                buf.setLength(0);
                continue;
            }
            buf.append(name2.charAt(i));
        }
        result2.add(buf.toString());
        return result2;
    }

    private void setUpFrom(@Nullable PsiElement element, GradleDslNameConverter converter) {
        this.myNameElement = element;
        this.myFakeName = null;
        if (this.myNameElement instanceof PsiNamedElement) {
            this.myLocalName = GradleNameElement.escape(((PsiNamedElement)this.myNameElement).getName());
        } else if (this.myNameElement != null) {
            this.myLocalName = converter.psiToName(this.myNameElement);
        }
        this.myOriginalName = this.myLocalName;
        this.myName = null;
    }
}

