/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.FileDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.FileTreeDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.AbstractDependenciesModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.FileDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.FileTreeDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.ScriptModuleDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.utils.DependencyUtilsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptDependenciesModelImpl
extends AbstractDependenciesModel {
    public static final Logger LOG = Logger.getInstance(ScriptDependenciesModelImpl.class);

    public ScriptDependenciesModelImpl(@NotNull DependenciesDslElement dslElement) {
        super(dslElement);
    }

    @Override
    public void addModule(@NotNull String configurationName, @NotNull String path, @Nullable String config) {
        ScriptModuleDependencyModelImpl.createNew(this.myDslElement, configurationName, path, config);
    }

    @Override
    protected AbstractDependenciesModel.Fetcher<ArtifactDependencyModel> getArtifactFetcher() {
        return (configurationName, element, resolved, configurationElement, maintainer, dest) -> {
            ArtifactDependencyModelImpl.DynamicNotation notation;
            if (!(element instanceof GradleDslExpression)) {
                return;
            }
            String methodName = null;
            if (element instanceof GradleDslMethodCall) {
                List<GradleDslExpression> arguments = ((GradleDslMethodCall)element).getArguments();
                methodName = ((GradleDslMethodCall)element).getMethodName();
                if (arguments.size() == 1 && Arrays.asList("platform", "enforcedPlatform").contains(methodName)) {
                    element = arguments.get(0);
                    resolved = DependencyUtilsKt.resolveElement(element);
                } else {
                    return;
                }
            }
            if ((element instanceof GradleDslSimpleExpression || resolved instanceof GradleDslExpressionMap) && (notation = ArtifactDependencyModelImpl.DynamicNotation.create(configurationName, (GradleDslExpression)element, configurationElement, maintainer, methodName)) != null) {
                dest.add(notation);
                if (DependencyUtilsKt.isInVersionCatalogFile(resolved)) {
                    notation.markAsVersionCatalogDependency();
                    notation.enableSetThrough();
                }
            }
        };
    }

    @Override
    protected AbstractDependenciesModel.Fetcher<ModuleDependencyModel> getModuleFetcher() {
        return (configurationName, element, resolved, configurationElement, maintainer, dest) -> {
            if (resolved instanceof GradleDslMethodCall) {
                ModuleDependencyModel model;
                String platformMethodName = null;
                GradleDslMethodCall methodCall = (GradleDslMethodCall)resolved;
                if (Arrays.asList("platform", "enforcedPlatform").contains(methodCall.getMethodName()) && methodCall.getArguments().size() == 1 && methodCall.getArguments().get(0) instanceof GradleDslMethodCall) {
                    platformMethodName = methodCall.getMethodName();
                    methodCall = (GradleDslMethodCall)methodCall.getArguments().get(0);
                }
                if (methodCall.getMethodName().equals("project") && (model = ScriptModuleDependencyModelImpl.create(configurationName, methodCall, maintainer, platformMethodName)) != null && model.path().getValueType() != GradlePropertyModel.ValueType.NONE) {
                    dest.add(model);
                }
            }
        };
    }

    @Override
    protected AbstractDependenciesModel.Fetcher<FileTreeDependencyModel> getFileTreeFetcher() {
        return (configurationName, element, resolved, configurationElement, maintainer, dest) -> {
            FileTreeDependencyModel model;
            GradleDslMethodCall methodCall;
            if (resolved instanceof GradleDslMethodCall && (methodCall = (GradleDslMethodCall)resolved).getMethodName().equals("fileTree") && (model = FileTreeDependencyModelImpl.create(methodCall, configurationName, maintainer)) != null && model.dir().getValueType() != GradlePropertyModel.ValueType.NONE) {
                dest.add(model);
            }
        };
    }

    @Override
    protected AbstractDependenciesModel.Fetcher<FileDependencyModel> getFileFetcher() {
        return (configurationName, element, resolved, configurationElement, maintainer, dest) -> {
            GradleDslMethodCall methodCall;
            if (resolved instanceof GradleDslMethodCall && (methodCall = (GradleDslMethodCall)resolved).getMethodName().equals("files")) {
                dest.addAll(FileDependencyModelImpl.create(configurationName, methodCall, maintainer));
            }
        };
    }

    @Override
    protected AbstractDependenciesModel.DependencyReplacer getDependencyReplacer() {
        return new AbstractDependenciesModel.DependencyReplacer(this){

            @Override
            public void performDependencyReplace(@NotNull PsiElement psiElement, @NotNull GradleDslElement element, @NotNull ArtifactDependencySpec dependency) {
                block3: {
                    block5: {
                        block4: {
                            block2: {
                                if (!(element instanceof GradleDslLiteral)) break block2;
                                ((GradleDslLiteral)element).setValue(dependency.compactNotation());
                                break block3;
                            }
                            if (!(element instanceof GradleDslExpressionMap)) break block4;
                            AbstractDependenciesModel.updateGradleExpressionMapWithDependency((GradleDslExpressionMap)element, dependency);
                            break block3;
                        }
                        if (!(element instanceof GradleDslMethodCall)) break block5;
                        GradleDslMethodCall methodCall = (GradleDslMethodCall)element;
                        for (GradleDslElement gradleDslElement : methodCall.getArguments()) {
                            if (gradleDslElement.getPsiElement() != psiElement) continue;
                            this.performDependencyReplace(psiElement, gradleDslElement, dependency);
                        }
                        break block3;
                    }
                    if (!(element instanceof GradleDslExpressionList)) break block3;
                    for (GradleDslSimpleExpression expression : ((GradleDslExpressionList)element).getSimpleExpressions()) {
                        if (element.getPsiElement() != psiElement) continue;
                        this.performDependencyReplace(psiElement, expression, dependency);
                    }
                }
            }
        };
    }

    @Override
    protected <T extends DependencyModel> void collectFrom(@NotNull String configurationName, @NotNull GradleDslElement element, @NotNull AbstractDependenciesModel.Fetcher<T> byFetcher, @NotNull List<T> dest) {
        String name2;
        GradleDslClosure configurationElement = element.getClosureElement();
        GradleDslElement resolved = DependencyUtilsKt.resolveElement(element);
        if (resolved instanceof GradleDslExpressionList) {
            for (GradleDslExpression expression : ((GradleDslExpressionList)resolved).getExpressions()) {
                GradleDslElement gradleDslElement = DependencyUtilsKt.resolveElement(expression);
                Maintainers maintener = Maintainers.EXPRESSION_LIST_MAINTAINER;
                byFetcher.fetch(configurationName, expression, gradleDslElement, configurationElement, maintener, dest);
            }
            return;
        }
        if (resolved instanceof GradleDslMethodCall && (name2 = ((GradleDslMethodCall)resolved).getMethodName()).equals(configurationName)) {
            for (GradleDslElement gradleDslElement : ((GradleDslMethodCall)resolved).getArguments()) {
                GradleDslElement resolvedArgument = DependencyUtilsKt.resolveElement(gradleDslElement);
                byFetcher.fetch(configurationName, gradleDslElement, resolvedArgument, configurationElement, Maintainers.ARGUMENT_LIST_MAINTAINER, dest);
            }
            return;
        }
        byFetcher.fetch(configurationName, element, resolved, configurationElement, Maintainers.SINGLE_ITEM_MAINTAINER, dest);
    }

    @Override
    @Nullable
    protected GradleDslElement findByPsiElement(@NotNull PsiElement child) {
        for (String configurationName : this.myDslElement.getProperties()) {
            for (GradleDslElement element : this.myDslElement.getPropertyElementsByName(configurationName)) {
                if (element instanceof GradleDslMethodCall) {
                    GradleDslMethodCall methodCall = (GradleDslMethodCall)element;
                    for (GradleDslElement gradleDslElement : methodCall.getArguments()) {
                        if (gradleDslElement.getPsiElement() == null || !ScriptDependenciesModelImpl.isChildOfParent(child, gradleDslElement.getPsiElement())) continue;
                        return gradleDslElement;
                    }
                    continue;
                }
                if (element instanceof GradleDslExpressionList) {
                    GradleDslExpressionList list2 = (GradleDslExpressionList)element;
                    for (GradleDslSimpleExpression e : list2.getSimpleExpressions()) {
                        if (e.getPsiElement() == null || !ScriptDependenciesModelImpl.isChildOfParent(child, e.getPsiElement())) continue;
                        return e;
                    }
                    continue;
                }
                if (element.getPsiElement() == null || !ScriptDependenciesModelImpl.isChildOfParent(child, element.getPsiElement())) continue;
                return element;
            }
        }
        return null;
    }

    static enum Maintainers implements DependencyModelImpl.Maintainer
    {
        EXPRESSION_LIST_MAINTAINER{

            @Override
            @Nullable
            public DependencyModelImpl.Maintainer setConfigurationName(DependencyModelImpl dependencyModel, String newConfigurationName) {
                GradleDslExpressionList list2;
                GradleDslElement dslElement = dependencyModel.getDslElement();
                GradleDslElement gradleDslElement = dslElement.getParent();
                GradleDslExpressionList parentList = gradleDslElement instanceof GradleDslExpressionList ? (list2 = (GradleDslExpressionList)gradleDslElement) : (GradleDslExpressionList)dslElement.getParent().getParent();
                List<GradleDslExpression> expressions = parentList.getExpressions();
                GradleDslExpressionList nameHolder = parentList;
                if (expressions.size() == 1) {
                    Maintainers.renameSingleElementConfiguration(nameHolder, newConfigurationName);
                    return this;
                }
                DependenciesDslElement dependenciesElement = (DependenciesDslElement)nameHolder.getParent();
                int index = dependenciesElement.getAllElements().indexOf(nameHolder);
                if (expressions.get(0) == dslElement && expressions.get(1) instanceof GradleDslExpressionMap) {
                    UnsupportedOperationException t = new UnsupportedOperationException("Changing the configuration name of a multi-entry dependency declaration containing map-notations is not supported.");
                    LOG.warn((Throwable)t);
                    return null;
                }
                GradleDslExpression copiedElement = ((GradleDslExpression)dslElement).copy();
                copiedElement.getNameElement().rename(newConfigurationName);
                dependencyModel.setDslElement(copiedElement);
                dependenciesElement.addNewElementAt(index, copiedElement);
                parentList.removeElement(dslElement);
                dependenciesElement.setModified();
                return SINGLE_ITEM_MAINTAINER;
            }
        }
        ,
        ARGUMENT_LIST_MAINTAINER{

            @Override
            @Nullable
            public DependencyModelImpl.Maintainer setConfigurationName(DependencyModelImpl dependencyModel, String newConfigurationName) {
                GradleDslElement dslElement = dependencyModel.getDslElement();
                GradleDslExpressionList parentList = (GradleDslExpressionList)dslElement.getParent();
                List<GradleDslExpression> expressions = parentList.getExpressions();
                GradleDslElement nameHolder = parentList.getParent();
                GradleNameElement nameElement = nameHolder.getNameElement();
                if (expressions.size() == 1) {
                    Maintainers.renameSingleElementConfiguration(nameHolder, newConfigurationName);
                    return this;
                }
                DependenciesDslElement dependenciesElement = (DependenciesDslElement)nameHolder.getParent();
                int index = dependenciesElement.getAllElements().indexOf(nameHolder);
                GradleDslExpression copiedElement = ((GradleDslExpression)dslElement).copy();
                copiedElement.getNameElement().rename(newConfigurationName);
                dependencyModel.setDslElement(copiedElement);
                dependenciesElement.addNewElementAt(index, copiedElement);
                parentList.removeElement(dslElement);
                dependenciesElement.setModified();
                return SINGLE_ITEM_MAINTAINER;
            }
        }
        ,
        SINGLE_ITEM_MAINTAINER{

            @Override
            @Nullable
            public DependencyModelImpl.Maintainer setConfigurationName(DependencyModelImpl dependencyModel, String newConfigurationName) {
                GradleDslElement dslElement = dependencyModel.getDslElement();
                Maintainers.renameSingleElementConfiguration(dslElement, newConfigurationName);
                return this;
            }
        }
        ,
        DEEP_EXPRESSION_LIST_MAINTAINER{

            @Override
            @Nullable
            public DependencyModelImpl.Maintainer setConfigurationName(DependencyModelImpl dependencyModel, String newConfigurationName) {
                List<GradleDslExpression> declarationExpressions;
                GradleDslExpressionList declarationExpressionList;
                GradleDslElement dslElement = dependencyModel.getDslElement();
                GradleDslExpressionList parentList = (GradleDslExpressionList)dslElement.getParent();
                List<GradleDslExpression> expressions = parentList.getExpressions();
                GradleDslMethodCall methodCall = (GradleDslMethodCall)parentList.getParent();
                GradleDslExpressionList nameHolder = declarationExpressionList = (GradleDslExpressionList)methodCall.getParent();
                DependenciesDslElement dependenciesElement = (DependenciesDslElement)nameHolder.getParent();
                int index = dependenciesElement.getAllElements().indexOf(nameHolder);
                if (expressions.size() == 1 && (declarationExpressions = declarationExpressionList.getExpressions()).size() == 1) {
                    Maintainers.renameSingleElementConfiguration(nameHolder, newConfigurationName);
                    return this;
                }
                GradleDslMethodCall copiedMethodElement = new GradleDslMethodCall((GradleDslElement)dependenciesElement, GradleNameElement.create(newConfigurationName), methodCall.getMethodName());
                GradleDslExpression expressionCopy = ((GradleDslExpression)dslElement).copy();
                copiedMethodElement.addNewArgument(expressionCopy);
                dependencyModel.setDslElement(expressionCopy);
                dependenciesElement.addNewElementAt(index, copiedMethodElement);
                if (expressions.size() == 1) {
                    declarationExpressionList.removeElement(methodCall);
                } else {
                    parentList.removeElement(dslElement);
                }
                dependenciesElement.setModified();
                return DEEP_SINGLE_ITEM_MAINTAINER;
            }
        }
        ,
        DEEP_ARGUMENT_LIST_MAINTAINER{

            @Override
            @Nullable
            public DependencyModelImpl.Maintainer setConfigurationName(DependencyModelImpl dependencyModel, String newConfigurationName) {
                List<GradleDslExpression> declarationMethodExpressions;
                GradleDslElement dslElement = dependencyModel.getDslElement();
                GradleDslExpressionList parentList = (GradleDslExpressionList)dslElement.getParent();
                List<GradleDslExpression> expressions = parentList.getExpressions();
                GradleDslMethodCall methodCall = (GradleDslMethodCall)parentList.getParent();
                GradleDslExpressionList declarationMethodArguments = (GradleDslExpressionList)methodCall.getParent();
                GradleDslMethodCall nameHolder = (GradleDslMethodCall)declarationMethodArguments.getParent();
                DependenciesDslElement dependenciesElement = (DependenciesDslElement)nameHolder.getParent();
                int index = dependenciesElement.getAllElements().indexOf(nameHolder);
                if (expressions.size() == 1 && (declarationMethodExpressions = declarationMethodArguments.getExpressions()).size() == 1) {
                    Maintainers.renameSingleElementConfiguration(nameHolder, newConfigurationName);
                    return this;
                }
                GradleDslMethodCall copiedMethodElement = new GradleDslMethodCall((GradleDslElement)dependenciesElement, GradleNameElement.create(newConfigurationName), methodCall.getMethodName());
                GradleDslExpression expressionCopy = ((GradleDslExpression)dslElement).copy();
                copiedMethodElement.addNewArgument(expressionCopy);
                dependencyModel.setDslElement(expressionCopy);
                dependenciesElement.addNewElementAt(index, copiedMethodElement);
                if (expressions.size() == 1) {
                    declarationMethodArguments.removeElement(methodCall);
                } else {
                    parentList.removeElement(dslElement);
                }
                dependenciesElement.setModified();
                return DEEP_SINGLE_ITEM_MAINTAINER;
            }
        }
        ,
        DEEP_SINGLE_ITEM_MAINTAINER{

            @Override
            @Nullable
            public DependencyModelImpl.Maintainer setConfigurationName(DependencyModelImpl dependencyModel, String newConfigurationName) {
                GradleDslElement dslElement = dependencyModel.getDslElement();
                GradleDslExpressionList parentList = (GradleDslExpressionList)dslElement.getParent();
                List<GradleDslExpression> expressions = parentList.getExpressions();
                GradleDslMethodCall methodCall = (GradleDslMethodCall)parentList.getParent();
                if (expressions.size() == 1) {
                    Maintainers.renameSingleElementConfiguration(methodCall, newConfigurationName);
                    return this;
                }
                GradleDslMethodCall nameHolder = methodCall;
                DependenciesDslElement dependenciesElement = (DependenciesDslElement)nameHolder.getParent();
                int index = dependenciesElement.getAllElements().indexOf(nameHolder);
                GradleDslMethodCall copiedMethodElement = new GradleDslMethodCall((GradleDslElement)dependenciesElement, GradleNameElement.create(newConfigurationName), methodCall.getMethodName());
                GradleDslExpression expressionCopy = ((GradleDslExpression)dslElement).copy();
                copiedMethodElement.addNewArgument(expressionCopy);
                dependencyModel.setDslElement(expressionCopy);
                dependenciesElement.addNewElementAt(index, copiedMethodElement);
                parentList.removeElement(dslElement);
                dependenciesElement.setModified();
                return DEEP_SINGLE_ITEM_MAINTAINER;
            }
        };


        private static void renameSingleElementConfiguration(@NotNull GradleDslElement dslElement, @NotNull String newConfigurationName) {
            GradleDslMethodCall methodCall;
            if (dslElement instanceof GradleDslMethodCall && (methodCall = (GradleDslMethodCall)dslElement).getMethodName().equals(dslElement.getNameElement().name())) {
                methodCall.setMethodName(newConfigurationName);
            }
            dslElement.getNameElement().rename(newConfigurationName);
            dslElement.setModified();
        }
    }
}

