/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependencyConfigurationModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpecImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.CompactNotationStrategy;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyConfigurationModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.MapNotationStrategy;
import com.android.tools.idea.gradle.dsl.model.dependencies.NotationStrategy;
import com.android.tools.idea.gradle.dsl.model.dependencies.PlatformArtifactDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelBuilder;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.parser.dependencies.FakeArtifactElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArtifactDependencyModelImpl
extends DependencyModelImpl
implements ArtifactDependencyModel {
    @Nullable
    private GradleDslClosure myConfigurationElement;
    protected boolean mySetThrough = false;
    protected boolean versionCatalogDependency = false;
    @NotNull
    private static final Pattern WRAPPED_VARIABLE_FORM = Pattern.compile("\\$\\{(.*)}");
    @NotNull
    private static final Pattern UNWRAPPED_VARIABLE_FORM = Pattern.compile("\\$(([a-zA-Z0-9_]\\w*)(\\.([a-zA-Z0-9_]\\w+))*)");

    public ArtifactDependencyModelImpl(@Nullable GradleDslClosure configurationElement, @NotNull String configurationName, @NotNull DependencyModelImpl.Maintainer maintainer) {
        super(configurationName, maintainer);
        this.myConfigurationElement = configurationElement;
    }

    @Override
    @NotNull
    public ArtifactDependencySpec getSpec() {
        String name2 = this.name().toString();
        assert (name2 != null);
        return new ArtifactDependencySpecImpl(name2, this.group().toString(), this.version().toString(), this.classifier().toString(), this.extension().toString());
    }

    @Override
    @NotNull
    public String compactNotation() {
        return this.getSpec().compactNotation();
    }

    @Override
    @NotNull
    public abstract ResolvedPropertyModel name();

    @Override
    @NotNull
    public abstract ResolvedPropertyModel group();

    @Override
    @NotNull
    public abstract ResolvedPropertyModel version();

    @Override
    @NotNull
    public abstract ResolvedPropertyModel classifier();

    @Override
    @NotNull
    public abstract ResolvedPropertyModel extension();

    @Override
    @NotNull
    public abstract ResolvedPropertyModel completeModel();

    @Override
    @Nullable
    public DependencyConfigurationModel configuration() {
        if (this.myConfigurationElement == null) {
            return null;
        }
        return new DependencyConfigurationModelImpl(this.myConfigurationElement);
    }

    @Override
    public void enableSetThrough() {
        this.mySetThrough = true;
    }

    @Override
    public void disableSetThrough() {
        this.mySetThrough = false;
    }

    @Override
    public boolean isVersionCatalogDependency() {
        return this.versionCatalogDependency;
    }

    @Override
    public void markAsVersionCatalogDependency() {
        this.versionCatalogDependency = true;
    }

    @NotNull
    private static GradleDslLiteral createLiteral(@NotNull GradlePropertiesDslElement parent, @NotNull String configurationName) {
        GradleNameElement name2 = GradleNameElement.create(configurationName);
        GradleDslLiteral literal = new GradleDslLiteral(parent, name2);
        literal.setElementType(PropertyType.REGULAR);
        parent.setNewElement(literal);
        return literal;
    }

    private static void initializeLiteral(@NotNull GradleDslLiteral literal, @NotNull Object value2, @NotNull List<ArtifactDependencySpec> excludes) {
        literal.setValue(value2);
        ArtifactDependencyModelImpl.addExcludes(literal, excludes);
    }

    static void createNew(@NotNull GradlePropertiesDslElement parent, @NotNull String configurationName, @NotNull ReferenceTo reference, @NotNull List<ArtifactDependencySpec> excludes) {
        GradleDslLiteral literal = ArtifactDependencyModelImpl.createLiteral(parent, configurationName);
        ArtifactDependencyModelImpl.initializeLiteral(literal, reference, excludes);
    }

    static void createNew(@NotNull GradlePropertiesDslElement parent, @NotNull String configurationName, @NotNull ArtifactDependencySpec dependency, @NotNull List<ArtifactDependencySpec> excludes) {
        GradleDslLiteral literal = ArtifactDependencyModelImpl.createLiteral(parent, configurationName);
        ArtifactDependencyModelImpl.initializeLiteral(literal, ArtifactDependencyModelImpl.createCompactNotationForLiterals(literal, dependency), excludes);
    }

    private static void addExcludes(@NotNull GradleDslLiteral literal, @NotNull List<ArtifactDependencySpec> excludes) {
        if (!excludes.isEmpty()) {
            GradleDslClosure closure = new GradleDslClosure(literal.getParent(), null, literal.getNameElement());
            for (ArtifactDependencySpec exclude : excludes) {
                GradleDslExpressionMap map2 = new GradleDslExpressionMap(closure, GradleNameElement.create("exclude"));
                String group2 = exclude.getGroup();
                if (group2 != null) {
                    GradleDslLiteral groupEntry = new GradleDslLiteral(map2, GradleNameElement.create("group"));
                    groupEntry.setValue(FakeArtifactElement.shouldInterpolate(group2) ? GradlePropertyModel.iStr(group2) : group2);
                    map2.setNewElement(groupEntry);
                }
                GradleDslLiteral moduleEntry = new GradleDslLiteral(map2, GradleNameElement.create("module"));
                String module = exclude.getName();
                moduleEntry.setValue(FakeArtifactElement.shouldInterpolate(module) ? GradlePropertyModel.iStr(module) : module);
                map2.setNewElement(moduleEntry);
                closure.setNewElement(map2);
            }
            literal.setNewClosureElement(closure);
        }
    }

    @NotNull
    protected static String createCompactNotationForLiterals(@NotNull GradleDslElement dslElement, @NotNull ArtifactDependencySpec spec) {
        ArrayList segments = Lists.newArrayList((Object[])new String[]{spec.getGroup(), spec.getName(), spec.getVersion(), spec.getClassifier(), spec.getExtension()});
        boolean shouldInterpolate = false;
        StringBuilder compactNotation = new StringBuilder();
        for (int currentElementIdx = 0; currentElementIdx < segments.size(); ++currentElementIdx) {
            String segment = (String)segments.get(currentElementIdx);
            if (segment == null) continue;
            if (currentElementIdx == 4) {
                compactNotation.append("@");
            } else if (currentElementIdx > 0) {
                compactNotation.append(":");
            }
            if (FakeArtifactElement.shouldInterpolate(segment)) {
                String value2;
                shouldInterpolate = true;
                Matcher wrappedValueMatcher = WRAPPED_VARIABLE_FORM.matcher(segment);
                Matcher unwrappedValueMatcher = UNWRAPPED_VARIABLE_FORM.matcher(segment);
                String interpolatedVariable = null;
                if (wrappedValueMatcher.find()) {
                    interpolatedVariable = wrappedValueMatcher.group(1);
                } else if (unwrappedValueMatcher.find()) {
                    interpolatedVariable = unwrappedValueMatcher.group(1);
                }
                String string = value2 = interpolatedVariable != null ? dslElement.getDslFile().getParser().convertReferenceToExternalText(dslElement, interpolatedVariable, true) : segment;
                if (Pattern.compile("([a-zA-Z0-9_]\\w*)").matcher(value2).matches()) {
                    compactNotation.append("$").append(value2);
                    continue;
                }
                if (WRAPPED_VARIABLE_FORM.matcher(value2).matches() || UNWRAPPED_VARIABLE_FORM.matcher(value2).matches()) {
                    compactNotation.append(value2);
                    continue;
                }
                compactNotation.append("${").append(value2).append("}");
                continue;
            }
            compactNotation.append(segment);
        }
        return shouldInterpolate ? GradlePropertyModel.iStr(compactNotation.toString()) : compactNotation.toString();
    }

    static class DynamicNotation
    extends ArtifactDependencyModelImpl {
        private GradleDslExpression myDslExpression;

        DynamicNotation(@NotNull String configurationName, @NotNull GradleDslExpression dslExpression, @Nullable GradleDslClosure configurationElement, @NotNull DependencyModelImpl.Maintainer maintainer) {
            super(configurationElement, configurationName, maintainer);
            this.myDslExpression = dslExpression;
        }

        @Nullable
        private static GradleDslExpression resolveExpression(@NotNull GradleDslExpression expression) {
            GradleDslElement element = PropertyUtil.followElement(expression);
            if (element instanceof GradleDslExpression) {
                expression = (GradleDslExpression)element;
            }
            return expression;
        }

        private NotationStrategy getStrategy() {
            GradleDslExpression resolvedExpression = DynamicNotation.resolveExpression(this.myDslExpression);
            if (resolvedExpression instanceof GradleDslExpressionMap) {
                return new MapNotationStrategy((GradleDslExpressionMap)resolvedExpression);
            }
            if (this.myDslExpression instanceof GradleDslSimpleExpression) {
                return new CompactNotationStrategy((GradleDslSimpleExpression)this.myDslExpression, this.mySetThrough);
            }
            return null;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel name() {
            return this.getStrategy().name();
        }

        @Override
        @Nullable
        public ResolvedPropertyModel group() {
            return this.getStrategy().group();
        }

        @Override
        @Nullable
        public ResolvedPropertyModel version() {
            return this.getStrategy().version();
        }

        @Override
        @Nullable
        public ResolvedPropertyModel classifier() {
            return this.getStrategy().classifier();
        }

        @Override
        @Nullable
        public ResolvedPropertyModel extension() {
            return this.getStrategy().extension();
        }

        @Override
        @Nullable
        public ResolvedPropertyModel completeModel() {
            return GradlePropertyModelBuilder.create(this.myDslExpression).buildResolved();
        }

        @Override
        @Nullable
        protected GradleDslElement getDslElement() {
            return this.myDslExpression;
        }

        @Override
        void setDslElement(@NotNull GradleDslElement dslElement) {
            this.myDslExpression = (GradleDslExpression)dslElement;
        }

        @Override
        @Nullable
        public PsiElement getPsiElement() {
            return this.myDslExpression.getExpression();
        }

        public boolean isValidDSL() {
            return this.getStrategy().isValidDSL();
        }

        @Nullable
        static DynamicNotation create(@NotNull String configurationName, @NotNull GradleDslExpression dslExpression, @Nullable GradleDslClosure configurationElement, @NotNull DependencyModelImpl.Maintainer maintainer, @Nullable String platformMethodName) {
            DynamicNotation result2 = platformMethodName == null ? new DynamicNotation(configurationName, dslExpression, configurationElement, maintainer) : new PlatformArtifactDependencyModelImpl.DynamicNotation(configurationName, dslExpression, configurationElement, maintainer, platformMethodName);
            return result2.isValidDSL() ? result2 : null;
        }
    }
}

