/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.api.android.TestOptionsModel;
import com.android.tools.idea.gradle.dsl.api.android.testOptions.EmulatorSnapshotsModel;
import com.android.tools.idea.gradle.dsl.api.android.testOptions.FailureRetentionModel;
import com.android.tools.idea.gradle.dsl.api.android.testOptions.UnitTestsModel;
import com.android.tools.idea.gradle.dsl.api.android.testOptions.testSuites.TestSuiteModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.android.ProductFlavorModelImpl;
import com.android.tools.idea.gradle.dsl.model.android.testOptions.EmulatorSnapshotsModelImpl;
import com.android.tools.idea.gradle.dsl.model.android.testOptions.FailureRetentionModelImpl;
import com.android.tools.idea.gradle.dsl.model.android.testOptions.UnitTestsModelImpl;
import com.android.tools.idea.gradle.dsl.model.android.testOptions.testSuites.TestSuiteModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelBuilder;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.SdkOrPreviewTransform;
import com.android.tools.idea.gradle.dsl.parser.android.TestOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.testOptions.EmulatorSnapshotsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.testOptions.FailureRetentionDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.testOptions.UnitTestsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.testOptions.testSuites.SuitesDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.testOptions.testSuites.TestSuiteDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.VersionConstraint;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TestOptionsModelImpl
extends GradleDslBlockModel
implements TestOptionsModel {
    @NonNls
    public static final String REPORT_DIR = "mReportDir";
    @NonNls
    public static final String RESULTS_DIR = "mResultsDir";
    @NonNls
    public static final String EXECUTION = "mExecution";

    public TestOptionsModelImpl(@NotNull TestOptionsDslElement dslElement) {
        super(dslElement);
    }

    @Override
    @NotNull
    public EmulatorSnapshotsModel emulatorSnapshots() {
        EmulatorSnapshotsDslElement emulatorSnapshotsDslElement = this.myDslElement.ensurePropertyElement(EmulatorSnapshotsDslElement.EMULATOR_SNAPSHOTS);
        return new EmulatorSnapshotsModelImpl(emulatorSnapshotsDslElement);
    }

    @Override
    @NotNull
    public FailureRetentionModel failureRetention() {
        FailureRetentionDslElement failureRetentionDslElement = this.myDslElement.ensurePropertyElement(FailureRetentionDslElement.FAILURE_RETENTION);
        return new FailureRetentionModelImpl(failureRetentionDslElement);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel reportDir() {
        return this.getModelForProperty(REPORT_DIR);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel resultsDir() {
        return this.getModelForProperty(RESULTS_DIR);
    }

    @Override
    @NotNull
    public UnitTestsModel unitTests() {
        UnitTestsDslElement unitTestsDslElement = this.myDslElement.ensurePropertyElement(UnitTestsDslElement.UNIT_TESTS);
        return new UnitTestsModelImpl(unitTestsDslElement);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel execution() {
        return this.getModelForProperty(EXECUTION);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel targetSdkVersion() {
        VersionConstraint agp410plus = VersionConstraint.agpFrom("4.1.0");
        return GradlePropertyModelBuilder.create(this.myDslElement, ProductFlavorModelImpl.TARGET_SDK_VERSION).addTransform(new SdkOrPreviewTransform(ProductFlavorModelImpl.TARGET_SDK_VERSION, "targetSdkVersion", "targetSdk", "targetSdkPreview", agp410plus)).buildResolved();
    }

    @Override
    @NotNull
    public List<TestSuiteModel> suites() {
        SuitesDslElement suites = this.myDslElement.getPropertyElement(SuitesDslElement.SUITES);
        return suites == null ? ImmutableList.of() : suites.get();
    }

    @Override
    public TestSuiteModel addSuite(@NotNull String suiteName) {
        SuitesDslElement suitesDslElement = this.myDslElement.ensurePropertyElement(SuitesDslElement.SUITES);
        TestSuiteDslElement testSuiteElement = suitesDslElement.ensureNamedPropertyElement(TestSuiteDslElement.TEST_SUITE, GradleNameElement.create(suiteName));
        return new TestSuiteModelImpl(testSuiteElement);
    }

    @Override
    public void removeSuite(@NotNull String suiteName) {
        SuitesDslElement suites = this.myDslElement.getPropertyElement(SuitesDslElement.SUITES);
        if (suites != null) {
            suites.removeProperty(suiteName);
        }
    }

    @Override
    public void removeSuites() {
        SuitesDslElement suites = this.myDslElement.getPropertyElement(SuitesDslElement.SUITES);
        if (suites != null) {
            this.myDslElement.removeProperty(suites);
        }
    }
}

