/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.api.android.FlavorTypeModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.SigningConfigPropertyModel;
import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ScriptDependenciesModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelBuilder;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.ext.SigningConfigPropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.ListOrVarargsTransform;
import com.android.tools.idea.gradle.dsl.parser.android.AbstractFlavorTypeDslElement;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.MethodSemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyType;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelSemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.PropertiesElementDescription;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FlavorTypeModelImpl
extends GradleDslBlockModel
implements FlavorTypeModel {
    @NonNls
    public static final String APPLICATION_ID_SUFFIX = "mApplicationIdSuffix";
    @NonNls
    public static final ModelPropertyDescription BUILD_CONFIG_FIELD = new ModelPropertyDescription("mBuildConfigField");
    @NonNls
    public static final ModelPropertyDescription CONSUMER_PROGUARD_FILES = new ModelPropertyDescription("mConsumerProguardFiles");
    @NonNls
    public static final String INIT_WITH = "mInitWith";
    @NonNls
    public static final ModelPropertyDescription MANIFEST_PLACEHOLDERS = new ModelPropertyDescription("mManifestPlaceholders", ModelPropertyType.MUTABLE_MAP);
    @NonNls
    public static final ModelPropertyDescription MATCHING_FALLBACKS = new ModelPropertyDescription("mMatchingFallbacks", ModelPropertyType.MUTABLE_LIST);
    @NonNls
    public static final String MULTI_DEX_ENABLED = "mMultiDexEnabled";
    @NonNls
    public static final String MULTI_DEX_KEEP_FILE = "mMultiDexKeepFile";
    @NonNls
    public static final String MULTI_DEX_KEEP_PROGUARD = "mMultiDexKeepProguard";
    @NonNls
    public static final ModelPropertyDescription PROGUARD_FILES = new ModelPropertyDescription("mProguardFiles");
    @NonNls
    public static final ModelPropertyDescription RES_VALUE = new ModelPropertyDescription("mResValue");
    @NonNls
    public static final String SIGNING_CONFIG = "mSigningConfig";
    @NonNls
    public static final String USE_JACK = "mUseJack";
    @NonNls
    public static final String VERSION_NAME_SUFFIX = "mVersionNameSuffix";
    @NonNls
    public static final PropertiesElementDescription<GradleDslExpressionMap> MANIFEST_PLACEHOLDERS_DESCRIPTION = new PropertiesElementDescription<GradleDslExpressionMap>(FlavorTypeModelImpl.MANIFEST_PLACEHOLDERS.name, GradleDslExpressionMap.class, GradleDslExpressionMap::new);

    public FlavorTypeModelImpl(@NotNull AbstractFlavorTypeDslElement dslElement) {
        super(dslElement);
    }

    @Override
    @NotNull
    public String name() {
        return this.myDslElement.getName();
    }

    @Override
    public void rename(@NotNull String newName) {
        this.myDslElement.getNameElement().rename(newName);
        this.myDslElement.setModified();
    }

    @Override
    @NotNull
    public ResolvedPropertyModel applicationIdSuffix() {
        return this.getModelForProperty(APPLICATION_ID_SUFFIX);
    }

    @Override
    @NotNull
    public List<FlavorTypeModel.BuildConfigField> buildConfigFields() {
        return this.getTypeNameValuesElements(BuildConfigFieldImpl::new, BUILD_CONFIG_FIELD);
    }

    @Override
    public FlavorTypeModel.BuildConfigField addBuildConfigField(@NotNull String type, @NotNull String name2, @NotNull String value2) {
        return (FlavorTypeModel.BuildConfigField)this.addNewTypeNameValueElement(BuildConfigFieldImpl::new, BUILD_CONFIG_FIELD, type, name2, value2);
    }

    @Override
    public void removeBuildConfigField(@NotNull String type, @NotNull String name2, @NotNull String value2) {
        FlavorTypeModel.BuildConfigField model = (FlavorTypeModel.BuildConfigField)this.getTypeNameValueElement(BuildConfigFieldImpl::new, BUILD_CONFIG_FIELD, type, name2, value2);
        if (model != null) {
            model.remove();
        }
    }

    @Override
    @Nullable
    public FlavorTypeModel.BuildConfigField replaceBuildConfigField(@NotNull String oldType, @NotNull String oldName, @NotNull String oldValue, @NotNull String type, @NotNull String name2, @NotNull String value2) {
        FlavorTypeModel.BuildConfigField field2 = (FlavorTypeModel.BuildConfigField)this.getTypeNameValueElement(BuildConfigFieldImpl::new, BUILD_CONFIG_FIELD, oldType, oldName, oldValue);
        if (field2 == null) {
            return null;
        }
        field2.type().setValue(type);
        field2.name().setValue(name2);
        field2.value().setValue(value2);
        return field2;
    }

    @Override
    public void removeAllBuildConfigFields() {
        this.myDslElement.removeProperty(FlavorTypeModelImpl.BUILD_CONFIG_FIELD.name);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel consumerProguardFiles() {
        return GradlePropertyModelBuilder.create(this.myDslElement, CONSUMER_PROGUARD_FILES).addTransform(new ListOrVarargsTransform(CONSUMER_PROGUARD_FILES, "setConsumerProguardFiles", "consumerProguardFiles")).buildResolved();
    }

    @NotNull
    public ResolvedPropertyModel initWith() {
        return this.getModelForProperty(INIT_WITH);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel manifestPlaceholders() {
        GradleDslExpressionMap manifestPlaceholders2 = this.myDslElement.getPropertyElement(MANIFEST_PLACEHOLDERS_DESCRIPTION);
        if (manifestPlaceholders2 == null) {
            manifestPlaceholders2 = new GradleDslExpressionMap(this.myDslElement, GradleNameElement.fake(FlavorTypeModelImpl.MANIFEST_PLACEHOLDERS.name));
            ModelEffectDescription effect = new ModelEffectDescription(MANIFEST_PLACEHOLDERS, ModelSemanticsDescription.CREATE_WITH_VALUE);
            manifestPlaceholders2.setModelEffect(effect);
            manifestPlaceholders2.setElementType(PropertyType.REGULAR);
            this.myDslElement.addDefaultProperty(manifestPlaceholders2);
        }
        return this.getModelForProperty(MANIFEST_PLACEHOLDERS);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel matchingFallbacks() {
        return this.getModelForProperty(MATCHING_FALLBACKS);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel multiDexEnabled() {
        return this.getModelForProperty(MULTI_DEX_ENABLED);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel multiDexKeepFile() {
        return GradlePropertyModelBuilder.create(this.myDslElement, MULTI_DEX_KEEP_FILE).addTransform(PropertyUtil.FILE_TRANSFORM).buildResolved();
    }

    @Override
    @NotNull
    public ResolvedPropertyModel multiDexKeepProguard() {
        return GradlePropertyModelBuilder.create(this.myDslElement, MULTI_DEX_KEEP_PROGUARD).addTransform(PropertyUtil.FILE_TRANSFORM).buildResolved();
    }

    @Override
    @NotNull
    public ResolvedPropertyModel proguardFiles() {
        return GradlePropertyModelBuilder.create(this.myDslElement, PROGUARD_FILES).addTransform(new ListOrVarargsTransform(PROGUARD_FILES, "setProguardFiles", "proguardFiles")).buildResolved();
    }

    @Override
    @NotNull
    public List<FlavorTypeModel.ResValue> resValues() {
        return this.getTypeNameValuesElements(ResValueImpl::new, RES_VALUE);
    }

    @Override
    @NotNull
    public FlavorTypeModel.ResValue addResValue(@NotNull String type, @NotNull String name2, @NotNull String value2) {
        return (FlavorTypeModel.ResValue)this.addNewTypeNameValueElement(ResValueImpl::new, RES_VALUE, type, name2, value2);
    }

    @Override
    public void removeResValue(@NotNull String type, @NotNull String name2, @NotNull String value2) {
        FlavorTypeModel.ResValue model = (FlavorTypeModel.ResValue)this.getTypeNameValueElement(ResValueImpl::new, RES_VALUE, type, name2, value2);
        if (model != null) {
            model.remove();
        }
    }

    @Override
    public FlavorTypeModel.ResValue replaceResValue(@NotNull String oldType, @NotNull String oldName, @NotNull String oldValue, @NotNull String type, @NotNull String name2, @NotNull String value2) {
        FlavorTypeModel.ResValue field2 = (FlavorTypeModel.ResValue)this.getTypeNameValueElement(ResValueImpl::new, RES_VALUE, oldType, oldName, oldValue);
        if (field2 == null) {
            return null;
        }
        field2.type().setValue(type);
        field2.name().setValue(name2);
        field2.value().setValue(value2);
        return field2;
    }

    @Override
    public void removeAllResValues() {
        this.myDslElement.removeProperty(FlavorTypeModelImpl.RES_VALUE.name);
    }

    @Override
    @NotNull
    public SigningConfigPropertyModel signingConfig() {
        return new SigningConfigPropertyModelImpl(GradlePropertyModelBuilder.create(this.myDslElement, SIGNING_CONFIG).build());
    }

    @Override
    @NotNull
    public ResolvedPropertyModel useJack() {
        return this.getModelForProperty(USE_JACK);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel versionNameSuffix() {
        return this.getModelForProperty(VERSION_NAME_SUFFIX);
    }

    @Override
    @NotNull
    public DependenciesModel dependencies() {
        DependenciesDslElement dependenciesElement = this.myDslElement.ensurePropertyElement(DependenciesDslElement.DEPENDENCIES);
        return new ScriptDependenciesModelImpl(dependenciesElement);
    }

    protected <T extends FlavorTypeModel.TypeNameValueElement> T addNewTypeNameValueElement(@NotNull Function<GradleDslExpressionList, T> producer, @NotNull ModelPropertyDescription property2, @NotNull String type, @NotNull String name2, @NotNull String value2) {
        String elementName = property2.name;
        GradleDslMethodCall expressionCall = new GradleDslMethodCall((GradleDslElement)this.myDslElement, GradleNameElement.empty(), elementName);
        ModelEffectDescription effect = new ModelEffectDescription(property2, MethodSemanticsDescription.OTHER);
        expressionCall.setModelEffect(effect);
        GradleDslExpressionList expressionList = new GradleDslExpressionList((GradleDslElement)expressionCall, GradleNameElement.empty(), false);
        expressionCall.setParsedArgumentList(expressionList);
        FlavorTypeModel.TypeNameValueElement newValue = (FlavorTypeModel.TypeNameValueElement)producer.apply((Object)expressionList);
        assert (newValue != null);
        newValue.type().setValue(type);
        newValue.name().setValue(name2);
        newValue.value().setValue(value2);
        this.myDslElement.setNewElement(expressionCall);
        return (T)newValue;
    }

    protected <T> List<T> getTypeNameValuesElements(@NotNull Function<GradleDslExpressionList, T> producer, @NotNull ModelPropertyDescription property2) {
        String elementName = property2.name;
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (GradleDslElement element : this.myDslElement.getPropertyElementsByName(elementName)) {
            if (element instanceof GradleDslMethodCall) {
                element = ((GradleDslMethodCall)element).getArgumentsElement();
            }
            if (!(element instanceof GradleDslExpressionList)) continue;
            GradleDslExpressionList list2 = (GradleDslExpressionList)element;
            Object value2 = producer.apply((Object)list2);
            assert (value2 != null);
            result2.add(value2);
        }
        return result2;
    }

    @Nullable
    protected <T extends FlavorTypeModel.TypeNameValueElement> T getTypeNameValueElement(@NotNull Function<GradleDslExpressionList, T> producer, @NotNull ModelPropertyDescription property2, @NotNull String type, @NotNull String name2, @NotNull String value2) {
        for (GradleDslElement element : this.myDslElement.getPropertyElementsByName(property2.name)) {
            GradleDslExpressionList list2 = null;
            if (element instanceof GradleDslMethodCall) {
                list2 = ((GradleDslMethodCall)element).getArgumentsElement();
            } else if (element instanceof GradleDslExpressionList) {
                list2 = (GradleDslExpressionList)element;
            }
            FlavorTypeModel.TypeNameValueElement typeNameValueElement = (FlavorTypeModel.TypeNameValueElement)producer.apply((Object)list2);
            assert (typeNameValueElement != null);
            String oldType = typeNameValueElement.type().getValue(GradlePropertyModel.STRING_TYPE);
            String oldName = typeNameValueElement.name().getValue(GradlePropertyModel.STRING_TYPE);
            String oldValue = typeNameValueElement.value().getValue(GradlePropertyModel.STRING_TYPE);
            if (oldType == null || !oldType.equals(type) || oldName == null || !oldName.equals(name2) || oldValue == null || !oldValue.equals(value2)) continue;
            return (T)typeNameValueElement;
        }
        return null;
    }

    public static final class BuildConfigFieldImpl
    extends TypeNameValueElementImpl
    implements FlavorTypeModel.BuildConfigField {
        public BuildConfigFieldImpl(@NotNull GradleDslExpressionList list2) {
            super(BUILD_CONFIG_FIELD, list2);
        }
    }

    public static final class ResValueImpl
    extends TypeNameValueElementImpl
    implements FlavorTypeModel.ResValue {
        public ResValueImpl(@NotNull GradleDslExpressionList list2) {
            super(RES_VALUE, list2);
        }
    }

    public static class TypeNameValueElementImpl
    implements FlavorTypeModel.TypeNameValueElement {
        @NotNull
        private final ModelPropertyDescription myPropertyDescription;
        @NotNull
        private final GradlePropertyModelImpl myList;

        public TypeNameValueElementImpl(@NotNull ModelPropertyDescription propertyDescription, @NotNull GradleDslExpressionList list2) {
            this.myPropertyDescription = propertyDescription;
            this.myList = new GradlePropertyModelImpl(list2);
            List<GradlePropertyModel> elements = this.myList.getValue(GradlePropertyModel.LIST_TYPE);
            assert (elements != null);
            for (int i = elements.size(); i < 3; ++i) {
                this.myList.addListValue();
            }
        }

        @NotNull
        private ResolvedPropertyModel getModelForIndex(int index) {
            List<GradlePropertyModel> elements = this.myList.getValue(GradlePropertyModel.LIST_TYPE);
            assert (elements != null);
            GradlePropertyModel expression = elements.get(index);
            assert (expression.getValueType() != GradlePropertyModel.ValueType.NONE);
            return expression.resolve();
        }

        @Override
        @NotNull
        public ResolvedPropertyModel type() {
            return this.getModelForIndex(0);
        }

        @Override
        @NotNull
        public ResolvedPropertyModel name() {
            return this.getModelForIndex(1);
        }

        @Override
        @NotNull
        public ResolvedPropertyModel value() {
            return this.getModelForIndex(2);
        }

        @Override
        @NotNull
        public String elementName() {
            return this.myPropertyDescription.name;
        }

        @Override
        public void remove() {
            this.myList.delete();
        }

        @Override
        public GradlePropertyModel getModel() {
            return this.myList;
        }

        public String toString() {
            return String.format("Type: %1$s, Name: %2$s, Value: %3$s", this.type().getValue(GradlePropertyModel.STRING_TYPE), this.name().getValue(GradlePropertyModel.STRING_TYPE), this.value().getValue(GradlePropertyModel.STRING_TYPE));
        }
    }
}

