/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.parser.ModificationAware;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedValue<T extends ModificationAware> {
    @NotNull
    private final T myDependent;
    @NotNull
    private final Function<T, Object> myProducer;
    private long myCachedModificationCount = -1L;
    @Nullable
    private Object myCachedValue;

    public CachedValue(@NotNull T dependent, @NotNull Function<T, Object> producer) {
        this.myDependent = dependent;
        this.myProducer = producer;
    }

    @Nullable
    public Object getValue() {
        long currentCount = this.myDependent.getModificationCount();
        if (currentCount > this.myCachedModificationCount) {
            this.updateValue();
        }
        return this.myCachedValue;
    }

    public void clear() {
        this.myCachedModificationCount = -1L;
        this.myCachedValue = null;
    }

    private void updateValue() {
        this.myCachedValue = this.myProducer.apply(this.myDependent);
        this.myCachedModificationCount = this.myDependent.getModificationCount();
    }
}

