/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.ide.common.gradle.Component;
import com.android.ide.common.gradle.Version;
import com.android.ide.common.repository.GoogleMavenArtifactId;
import com.android.tools.idea.gradle.LibraryFilePaths;
import com.android.tools.idea.gradle.dependencies.DependenciesHelper;
import com.android.tools.idea.gradle.dsl.android.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.android.model.android.AndroidModelUtilsKt;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleFileModel;
import com.android.tools.idea.gradle.dsl.api.GradleVersionCatalogModel;
import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.CompileOptionsModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.AndroidCommonConfigurationNames;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.java.JavaModel;
import com.android.tools.idea.gradle.model.IdeArtifactLibrary;
import com.android.tools.idea.gradle.model.IdeArtifactName;
import com.android.tools.idea.gradle.model.IdeBaseArtifact;
import com.android.tools.idea.gradle.model.IdeDependencies;
import com.android.tools.idea.gradle.model.IdeLibrary;
import com.android.tools.idea.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.GradleAndroidDependencyModel;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.TestArtifactSearchScopes;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPath;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPathKt;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModifier;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class AndroidGradleJavaProjectModelModifier
extends JavaProjectModelModifier {
    @NotNull
    private static final Map<String, String> EXTERNAL_LIBRARY_VERSIONS = ImmutableMap.of((Object)"net.jcip:jcip-annotations", (Object)"1.0", (Object)"org.jetbrains:annotations-java5", (Object)"15.0", (Object)"org.jetbrains:annotations", (Object)"15.0", (Object)"junit:junit", (Object)"4.12", (Object)"org.testng:testng", (Object)"6.9.6");
    @NotNull
    private static final Set<String> ANDROID_PLUGIN_IDENTIFIERS = ImmutableSet.of((Object)"android", (Object)"android-library", (Object)"com.android.application", (Object)"com.android.library", (Object)"com.android.instantapp", (Object)"com.android.feature", (Object[])new String[]{"com.android.dynamic-feature", "com.android.test"});
    @NotNull
    private static final Set<String> JAVA_PLUGIN_IDENTIFIERS = ImmutableSet.of((Object)"java", (Object)"java-library");

    @Nullable
    public Promise<Void> addModuleDependency(@NotNull Module from2, @NotNull Module to, @NotNull DependencyScope scope, boolean exported) {
        Project project = from2.getProject();
        VirtualFile openedFile = FileEditorManager.getInstance((Project)from2.getProject()).getCurrentFile();
        GradleProjectPath gradlePath = GradleProjectPathKt.getGradleProjectPath(to);
        GradleBuildModel buildModel = GradleBuildModel.get(from2);
        if (buildModel != null && gradlePath != null) {
            DependenciesModel dependencies2 = buildModel.dependencies();
            String configurationName = AndroidGradleJavaProjectModelModifier.getConfigurationName(from2, scope, openedFile);
            dependencies2.addModule(configurationName, gradlePath.getPath(), null);
            WriteCommandAction.writeCommandAction((Project)project).withName("Add Gradle Module Dependency").run(() -> {
                buildModel.applyChanges();
                AndroidGradleJavaProjectModelModifier.registerUndoAction(project);
            });
            return AndroidGradleJavaProjectModelModifier.requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_MODIFIER_ADD_MODULE_DEPENDENCY);
        }
        if (buildModel == null ^ gradlePath == null) {
            return Promises.rejectedPromise();
        }
        return null;
    }

    @Nullable
    public Promise<Void> addExternalLibraryDependency(@NotNull Collection<? extends Module> modules, @NotNull ExternalLibraryDescriptor descriptor2, @NotNull DependencyScope scope) {
        ArtifactDependencySpec dependencySpec = ArtifactDependencySpec.create(descriptor2.getLibraryArtifactId(), descriptor2.getLibraryGroupId(), AndroidGradleJavaProjectModelModifier.selectVersion(descriptor2));
        return AndroidGradleJavaProjectModelModifier.addExternalLibraryDependency(modules, dependencySpec, scope);
    }

    @Nullable
    public Promise<Void> addLibraryDependency(@NotNull Module from2, @NotNull Library library, @NotNull DependencyScope scope, boolean exported) {
        if (!GradleFacet.isAppliedTo(from2)) {
            return null;
        }
        ArtifactDependencySpec dependencySpec = AndroidGradleJavaProjectModelModifier.findNewExternalDependency(from2.getProject(), library);
        if (dependencySpec == null) {
            return Promises.rejectedPromise();
        }
        return AndroidGradleJavaProjectModelModifier.addExternalLibraryDependency((Collection<? extends Module>)ImmutableList.of((Object)from2), dependencySpec, scope);
    }

    @Nullable
    private static Promise<Void> addExternalLibraryDependency(@NotNull Collection<? extends Module> modules, @NotNull ArtifactDependencySpec dependencySpec, @NotNull DependencyScope scope) {
        Module firstModule = (Module)Iterables.getFirst(modules, null);
        if (firstModule == null) {
            return null;
        }
        Project project = firstModule.getProject();
        VirtualFile openedFile = FileEditorManager.getInstance((Project)firstModule.getProject()).getCurrentFile();
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(project);
        ArrayList<GradleFileModel> buildModelsToUpdate = new ArrayList<GradleFileModel>();
        for (Module module : modules) {
            GradleBuildModel buildModel = GradleBuildModel.get(module);
            if (buildModel == null) {
                return null;
            }
            String configurationName = AndroidGradleJavaProjectModelModifier.getConfigurationName(module, scope, openedFile);
            DependenciesHelper.withModel(projectBuildModel).addDependency(configurationName, dependencySpec.compactNotation(), buildModel);
            buildModelsToUpdate.add(buildModel);
        }
        GradleVersionCatalogModel maybeCatalog = DependenciesHelper.getDefaultCatalogModel(projectBuildModel);
        if (maybeCatalog != null) {
            buildModelsToUpdate.add(maybeCatalog);
        }
        WriteCommandAction.writeCommandAction((Project)project).withName("Add Gradle Library Dependency").run(() -> {
            for (GradleFileModel buildModel : buildModelsToUpdate) {
                buildModel.applyChanges();
            }
            AndroidGradleJavaProjectModelModifier.registerUndoAction(project);
        });
        return AndroidGradleJavaProjectModelModifier.requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_MODIFIER_ADD_LIBRARY_DEPENDENCY);
    }

    @Nullable
    public Promise<Void> changeLanguageLevel(@NotNull Module module, @NotNull LanguageLevel level) {
        Project project = module.getProject();
        if (!GradleFacet.isAppliedTo(module)) {
            return null;
        }
        GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (buildModel == null) {
            return null;
        }
        List<String> pluginNames = PluginModel.extractNames(buildModel.appliedPlugins());
        ArrayList<String> androidPluginNames = new ArrayList<String>(pluginNames);
        androidPluginNames.retainAll(ANDROID_PLUGIN_IDENTIFIERS);
        ArrayList<String> javaPluginNames = new ArrayList<String>(pluginNames);
        javaPluginNames.retainAll(JAVA_PLUGIN_IDENTIFIERS);
        if (!androidPluginNames.isEmpty()) {
            AndroidModel android = AndroidModelUtilsKt.android(buildModel);
            CompileOptionsModel compileOptions = android.compileOptions();
            compileOptions.sourceCompatibility().setLanguageLevel(level);
            compileOptions.targetCompatibility().setLanguageLevel(level);
        }
        if (!javaPluginNames.isEmpty()) {
            JavaModel javaModel = buildModel.java();
            javaModel.sourceCompatibility().setLanguageLevel(level);
            javaModel.targetCompatibility().setLanguageLevel(level);
        }
        WriteCommandAction.writeCommandAction((Project)project).withName("Change Gradle Language Level").run(() -> {
            buildModel.applyChanges();
            AndroidGradleJavaProjectModelModifier.registerUndoAction(project);
        });
        return AndroidGradleJavaProjectModelModifier.requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_MODIFIER_LANGUAGE_LEVEL_CHANGED);
    }

    @NotNull
    private static String getConfigurationName(@NotNull Module module, @NotNull DependencyScope scope, @Nullable VirtualFile openedFile) {
        if (!scope.isForProductionCompile()) {
            boolean isScreenshotTest;
            TestArtifactSearchScopes testScopes = TestArtifactSearchScopes.getInstance(module);
            boolean isAndroid = testScopes != null && openedFile != null && testScopes.isAndroidTestSource(openedFile);
            boolean bl = isScreenshotTest = testScopes != null && openedFile != null && testScopes.isScreenshotTestSource(openedFile);
            return isAndroid ? AndroidCommonConfigurationNames.ANDROID_TEST_IMPLEMENTATION : (isScreenshotTest ? AndroidCommonConfigurationNames.SCREENSHOT_TEST_IMPLEMENTATION : "testImplementation");
        }
        return "implementation";
    }

    @Nullable
    private static String selectVersion(@NotNull ExternalLibraryDescriptor descriptor2) {
        GoogleMavenArtifactId library;
        String libraryArtifactId = descriptor2.getLibraryArtifactId();
        String libraryGroupId = descriptor2.getLibraryGroupId();
        String groupAndId = libraryGroupId + ":" + libraryArtifactId;
        String version2 = EXTERNAL_LIBRARY_VERSIONS.get(groupAndId);
        if (version2 == null && (library = GoogleMavenArtifactId.Companion.find(libraryGroupId, libraryArtifactId)) != null) {
            Predicate<Version> filter2 = descriptor2.getMinVersion() == null ? null : v -> v.toString().startsWith(descriptor2.getMinVersion());
            Component component = RepositoryUrlManager.get().getArtifactComponent(library, filter2, false);
            if (component != null) {
                version2 = component.getVersion().toString();
            }
        }
        if (version2 == null) {
            version2 = descriptor2.getPreferredVersion();
        }
        return version2;
    }

    @NotNull
    private static Promise<Void> requestProjectSync(@NotNull Project project, @NotNull GradleSyncStats.Trigger trigger) {
        final AsyncPromise promise = new AsyncPromise();
        ListenableFuture<ProjectSystemSyncManager.SyncResult> result2 = ProjectSystemService.getInstance(project).getProjectSystem().getSyncManager().requestSyncProject(new ProjectSystemSyncManager.SyncReason(trigger));
        Futures.addCallback(result2, (FutureCallback)new FutureCallback<ProjectSystemSyncManager.SyncResult>(){

            public void onSuccess(ProjectSystemSyncManager.SyncResult result2) {
                promise.setResult(null);
            }

            public void onFailure(Throwable t) {
                promise.setError(t.getMessage());
            }
        }, (Executor)MoreExecutors.directExecutor());
        return promise;
    }

    private static void registerUndoAction(final @NotNull Project project) {
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

            public void undo() throws UnexpectedUndoException {
                AndroidGradleJavaProjectModelModifier.requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_MODIFIER_ACTION_UNDONE);
            }

            public void redo() throws UnexpectedUndoException {
                AndroidGradleJavaProjectModelModifier.requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_MODIFIER_ACTION_REDONE);
            }
        });
    }

    @Nullable
    private static ArtifactDependencySpec findNewExternalDependency(@NotNull Project project, @NotNull Library library) {
        if (library.getName() == null) {
            return null;
        }
        ArtifactDependencySpec result2 = null;
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            GradleAndroidDependencyModel androidModel = GradleAndroidDependencyModel.get(module);
            if (androidModel == null || LibraryUtil.findLibrary((Module)module, (String)library.getName()) == null) continue;
            result2 = AndroidGradleJavaProjectModelModifier.findNewExternalDependency(library, androidModel.getSelectedVariantWithDependencies());
            break;
        }
        if (result2 == null) {
            result2 = AndroidGradleJavaProjectModelModifier.findNewExternalDependencyByExaminingPath(library);
        }
        return result2;
    }

    @Nullable
    private static ArtifactDependencySpec findNewExternalDependency(@NotNull Library library, @NotNull IdeVariant selectedVariant) {
        @Nullable ArtifactDependencySpec matchedLibrary = null;
        @Nullable IdeBaseArtifact artifact = selectedVariant.getHostTestArtifacts().stream().filter(it -> it.getName() == IdeArtifactName.UNIT_TEST).findFirst().orElse(null);
        if (artifact != null) {
            matchedLibrary = AndroidGradleJavaProjectModelModifier.findMatchedLibrary(library, artifact);
        }
        if (matchedLibrary == null && (artifact = (IdeBaseArtifact)selectedVariant.getDeviceTestArtifacts().stream().filter(it -> it.getName() == IdeArtifactName.ANDROID_TEST).findFirst().orElse(null)) != null) {
            matchedLibrary = AndroidGradleJavaProjectModelModifier.findMatchedLibrary(library, artifact);
        }
        if (matchedLibrary == null && (artifact = selectedVariant.getTestFixturesArtifact()) != null) {
            matchedLibrary = AndroidGradleJavaProjectModelModifier.findMatchedLibrary(library, artifact);
        }
        if (matchedLibrary == null && (artifact = (IdeBaseArtifact)selectedVariant.getHostTestArtifacts().stream().filter(it -> it.getName() == IdeArtifactName.SCREENSHOT_TEST).findFirst().orElse(null)) != null) {
            matchedLibrary = AndroidGradleJavaProjectModelModifier.findMatchedLibrary(library, artifact);
        }
        if (matchedLibrary == null) {
            matchedLibrary = AndroidGradleJavaProjectModelModifier.findMatchedLibrary(library, (IdeBaseArtifact)selectedVariant.getMainArtifact());
        }
        return matchedLibrary;
    }

    @Nullable
    private static ArtifactDependencySpec findMatchedLibrary(@NotNull Library library, @NotNull IdeBaseArtifact artifact) {
        IdeDependencies dependencies2 = artifact.getCompileClasspath();
        for (IdeLibrary gradleLibrary : dependencies2.getLibraries()) {
            Component component;
            if (!(gradleLibrary instanceof IdeArtifactLibrary)) continue;
            IdeArtifactLibrary dependency = (IdeArtifactLibrary)gradleLibrary;
            String dependencyAddress = dependency.getArtifactAddress();
            String libraryName = library.getName();
            if (libraryName != null && libraryName.startsWith(LibraryFilePaths.NAME_PREFIX)) {
                libraryName = libraryName.substring(LibraryFilePaths.NAME_PREFIX.length());
            }
            if (!dependencyAddress.equals(libraryName) || (component = dependency.getComponent()) == null) continue;
            return ArtifactDependencySpec.create(component.getName(), component.getGroup(), component.getVersion().toString());
        }
        return null;
    }

    @Nullable
    private static ArtifactDependencySpec findNewExternalDependencyByExaminingPath(@NotNull Library library) {
        VirtualFile[] files2 = library.getFiles(OrderRootType.CLASSES);
        if (files2.length == 0) {
            return null;
        }
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)files2[0]);
        String libraryName = library.getName();
        if (libraryName == null) {
            return null;
        }
        List pathSegments = FileUtil.splitPath((String)file.getPath());
        for (int i = 1; i < pathSegments.size() - 2; ++i) {
            if (!libraryName.startsWith((String)pathSegments.get(i))) continue;
            String groupId = (String)pathSegments.get(i - 1);
            String artifactId = (String)pathSegments.get(i);
            String version2 = (String)pathSegments.get(i + 1);
            if (!libraryName.endsWith(version2)) continue;
            return ArtifactDependencySpec.create(artifactId, groupId, version2);
        }
        return null;
    }
}

