/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.flags;

import com.android.flags.CustomTypeFlag;
import com.android.flags.DEFAULT_BOOLEAN_FLAG_VALUE;
import com.android.flags.Flag;
import com.android.flags.FlagGroup;
import com.android.flags.FlagValueContainer;
import com.android.flags.FlagValueProvider;
import com.android.flags.overrides.InMemoryFlagValueContainer;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlagSettings;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.flags.overrides.FeatureConfigurationProvider;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.adapters.AdapterProperty;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.expressions.bool.BooleanExpressions;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.SpinnerLongValueProperty;
import com.android.tools.idea.observable.ui.SpinnerValueProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBIntSpinner;
import com.intellij.ui.LightColors;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StudioFlagsDialog
extends DialogWrapper {
    private static final String DIMENSION_KEY = StudioFlagsDialog.class.getSimpleName();
    public static final String TITLE = "Edit Studio Flags";
    private final FlagValueContainer myBackupOverrides = new InMemoryFlagValueContainer();
    private final BindingsManager myBindings = new BindingsManager();
    private final ListMultimap<FlagGroup, Flag<?>> myGroupedFlags;
    private JPanel myRootPanel;
    private JPanel myContentPanel;
    private JBScrollPane myScrollPane;
    private SearchTextField mySearchTextField;

    public StudioFlagsDialog(@Nullable Project project) {
        super(project);
        this.setupUI();
        this.setTitle(TITLE);
        this.setPreferredBounds(project);
        this.myGroupedFlags = StudioFlagsDialog.collectAllFlags();
        this.replaceOverrides(this.myBackupOverrides, (FlagValueProvider)StudioFlagSettings.getInstance());
        this.updateFlagsComponents(null);
        this.mySearchTextField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                StudioFlagsDialog.this.searchTextChanged(this.getText(e));
            }

            @NotNull
            private String getText(DocumentEvent e) {
                try {
                    return e.getDocument().getText(0, e.getDocument().getLength());
                }
                catch (BadLocationException e1) {
                    return "";
                }
            }
        });
        this.init();
        ApplicationManager.getApplication().invokeLater(() -> this.myScrollPane.getVerticalScrollBar().setValue(0), ModalityState.any());
    }

    private void setPreferredBounds(@Nullable Project project) {
        Window window2 = WindowManager.getInstance().suggestParentWindow(project);
        if (window2 != null) {
            Rectangle bounds = window2.getBounds();
            bounds.grow(-(bounds.width / 4), -(bounds.height / 6));
            this.setInitialLocationCallback(bounds::getLocation);
            this.myRootPanel.setPreferredSize(bounds.getSize());
        }
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySearchTextField;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return DIMENSION_KEY;
    }

    private void searchTextChanged(@NotNull String text2) {
        this.updateFlagsComponents(text2);
        this.myContentPanel.revalidate();
        this.myContentPanel.repaint();
    }

    private void updateFlagsComponents(@Nullable String searchText) {
        this.myContentPanel.removeAll();
        this.myContentPanel.setLayout((LayoutManager)StudioFlagsDialog.getFlagsPanelDefaultLayout());
        boolean isAndroidStudio = IdeInfo.getInstance().isAndroidStudio();
        this.myGroupedFlags.asMap().entrySet().stream().filter(flag -> isAndroidStudio || StudioFlagsDialog.shouldBeIncludedInIdea(flag)).sorted(Comparator.comparing(entry -> ((FlagGroup)entry.getKey()).getDisplayName())).forEach(entry -> {
            FlagGroup group2 = (FlagGroup)entry.getKey();
            List flagMatches = ((Collection)entry.getValue()).stream().filter(flag -> StudioFlagsDialog.showFlag(flag, searchText)).collect(Collectors.toList());
            if (flagMatches.isEmpty()) {
                return;
            }
            JPanel groupPanel = new JPanel((LayoutManager)new VerticalFlowLayout(5, 0));
            TitledBorder titledBorder = BorderFactory.createTitledBorder(group2.getDisplayName());
            titledBorder.setTitleFont(titledBorder.getTitleFont().deriveFont(1, titledBorder.getTitleFont().getSize() + 2));
            groupPanel.setBorder(titledBorder);
            FeatureConfigurationProvider featureConfigurationProvider = FeatureConfigurationProvider.Companion.getCurrentFlags();
            boolean firstFlag = true;
            for (Flag flag2 : flagMatches) {
                JPanel flagPanel = new JPanel((LayoutManager)new VerticalFlowLayout(5, 0));
                if (!firstFlag) {
                    flagPanel.add(new JSeparator(0));
                }
                JBLabel name2 = new JBLabel(this.normalizeFlagText(flag2.getDisplayName()));
                name2.setFont(StartupUiUtil.getLabelFont().deriveFont(1));
                JBLabel id2 = new JBLabel("(" + flag2.getId() + ")");
                id2.setFont(EditorUtil.getEditorFont());
                JTextArea description2 = new JTextArea(this.normalizeFlagText(flag2.getDescription()));
                description2.setFont(StartupUiUtil.getLabelFont());
                description2.setLineWrap(true);
                description2.setWrapStyleWord(true);
                description2.setEditable(false);
                description2.setOpaque(false);
                description2.setForeground(NamedColorUtil.getInactiveTextColor());
                final FlagEditor<?> flagEditor = this.createFlagEditor(flag2);
                HyperlinkLabel resetLink = new HyperlinkLabel("Reset to default");
                resetLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(this){

                    protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                        flagEditor.flagProperty().clearOverride();
                    }
                });
                this.myBindings.bind(new VisibleProperty((JComponent)resetLink), flagEditor.flagProperty().isOverridden());
                JPanel flagEditorPanel = new JPanel(new FlowLayout(0, 5, 0));
                flagEditorPanel.add(flagEditor.editorComponent());
                flagEditorPanel.add((Component)resetLink);
                JPanel namePanel = new JPanel((LayoutManager)new HorizontalLayout(10));
                namePanel.add((Component)name2);
                namePanel.add((Component)id2);
                flagPanel.add(namePanel);
                flagPanel.add(description2);
                if (flag2.getDefault() == DEFAULT_BOOLEAN_FLAG_VALUE.INSTANCE) {
                    String explanation = featureConfigurationProvider.getConfigurationExplanation(flag2);
                    if (explanation != null) {
                        JBLabel defaultValueDescription = new JBLabel(explanation);
                        defaultValueDescription.setIcon(AllIcons.General.BalloonInformation);
                        defaultValueDescription.setOpaque(true);
                        flagPanel.add((Component)defaultValueDescription);
                    }
                } else if (!flag2.getDefault().getExplanation().isEmpty()) {
                    JBLabel defaultValueDescription = new JBLabel(flag2.getDefault().getExplanation());
                    defaultValueDescription.setIcon(AllIcons.General.BalloonInformation);
                    defaultValueDescription.setOpaque(true);
                    flagPanel.add((Component)defaultValueDescription);
                }
                flagPanel.add(flagEditorPanel);
                groupPanel.add(flagPanel);
                firstFlag = false;
            }
            this.myContentPanel.add(groupPanel);
        });
        boolean emptySearchResult = !StringUtil.isEmptyOrSpaces((String)searchText) && this.myContentPanel.getComponentCount() == 0;
        this.mySearchTextField.getTextEditor().setBackground(emptySearchResult ? LightColors.RED : UIUtil.getTextFieldBackground());
        if (emptySearchResult) {
            JLabel label2 = new JLabel();
            label2.setText(IdeCoreBundle.message((String)"message.nothingToShow", (Object[])new Object[0]));
            label2.setHorizontalAlignment(0);
            this.myContentPanel.setLayout(new BorderLayout());
            this.myContentPanel.add((Component)label2, "Center");
        }
    }

    private void setupUI() {
        this.createUIComponents();
        this.myRootPanel = new JPanel();
        this.myRootPanel.setLayout(new BorderLayout(0, 0));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BorderLayout(0, 0));
        this.myRootPanel.add((Component)panel1, "North");
        this.mySearchTextField = new SearchTextField();
        panel1.add((Component)this.mySearchTextField, "Center");
        this.myScrollPane = new JBScrollPane();
        this.myScrollPane.setHorizontalScrollBarPolicy(31);
        this.myRootPanel.add((Component)this.myScrollPane, "Center");
        this.myScrollPane.setViewportView((Component)this.myContentPanel);
    }

    private static boolean shouldBeIncludedInIdea(Map.Entry<FlagGroup, Collection<Flag<?>>> flag) {
        return switch (flag.getKey().getName()) {
            case "appinsights", "cloud", "firebasetestlab", "google.login", "studiobot" -> false;
            default -> true;
        };
    }

    @NlsContexts.Label
    @NotNull
    private String normalizeFlagText(@NlsContexts.Label String flagText) {
        if (IdeInfo.getInstance().isAndroidStudio()) {
            return flagText;
        }
        String productName = ApplicationNamesInfo.getInstance().getFullProductName();
        return flagText.replace("Android Studio", productName).replace("Studio", productName);
    }

    private static boolean showFlag(@NotNull Flag<?> flag, @Nullable String searchText) {
        return StringUtil.isEmptyOrSpaces((String)searchText) || StringUtil.containsIgnoreCase((String)flag.getId(), (String)searchText) || StringUtil.containsIgnoreCase((String)flag.getDisplayName(), (String)searchText) || StringUtil.containsIgnoreCase((String)flag.getDescription(), (String)searchText);
    }

    private void replaceOverrides(FlagValueContainer overridesDest, FlagValueProvider overridesSrc) {
        overridesDest.clear();
        for (Flag flag : this.myGroupedFlags.values()) {
            String flagValue = overridesSrc.get(flag);
            if (flagValue == null) continue;
            overridesDest.put(flag, flagValue);
        }
    }

    private static ListMultimap<FlagGroup, Flag<?>> collectAllFlags() {
        ArrayListMultimap allFlags = ArrayListMultimap.create();
        for (Field field2 : StudioFlags.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field2.getModifiers())) continue;
            try {
                Object instance = field2.get(null);
                if (!(instance instanceof Flag)) continue;
                Flag flag = (Flag)instance;
                allFlags.put((Object)flag.getGroup(), (Object)flag);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return allFlags;
    }

    @NotNull
    private FlagEditor<?> createFlagEditor(Flag<?> flag) {
        if (flag.get().getClass() == Boolean.class) {
            return this.createBooleanFlagEditor(flag);
        }
        if (flag.get().getClass() == String.class) {
            return this.createStringFlagEditor(flag);
        }
        if (flag.get().getClass() == Integer.class) {
            return this.createIntegerFlagEditor(flag);
        }
        if (flag.get().getClass() == Long.class) {
            return this.createLongFlagEditor(flag);
        }
        if (flag.get().getClass().isEnum()) {
            return this.createEnumFlagEditor(flag);
        }
        if (flag instanceof CustomTypeFlag) {
            return this.createCustomFlagEditor((CustomTypeFlag)flag);
        }
        throw new IllegalStateException(String.format("Unhandled flag type (\"%s\"): Flag<%s>", flag.getId(), flag.get().getClass().getSimpleName()));
    }

    @NotNull
    private FlagEditor<String> createStringFlagEditor(final Flag<String> flag) {
        return new FlagEditor<String>(){
            final FlagProperty<String> myFlagProperty;
            {
                this.myFlagProperty = new FlagProperty(flag);
            }

            @Override
            @NotNull
            public FlagProperty<String> flagProperty() {
                return this.myFlagProperty;
            }

            @Override
            @NotNull
            public JComponent editorComponent() {
                JTextField textField2 = new JTextField();
                StudioFlagsDialog.this.myBindings.bindTwoWay(new TextProperty(textField2), this.myFlagProperty);
                return textField2;
            }
        };
    }

    @NotNull
    private FlagEditor<Integer> createIntegerFlagEditor(final Flag<Integer> flag) {
        return new FlagEditor<Integer>(){
            final FlagProperty<Integer> myFlagProperty;
            {
                this.myFlagProperty = new FlagProperty(flag);
            }

            @Override
            @NotNull
            public FlagProperty<Integer> flagProperty() {
                return this.myFlagProperty;
            }

            @Override
            @NotNull
            public JComponent editorComponent() {
                JBIntSpinner spinner = new JBIntSpinner(((Integer)flag.get()).intValue(), Integer.MIN_VALUE, Integer.MAX_VALUE);
                StudioFlagsDialog.this.myBindings.bindTwoWay(new SpinnerValueProperty(spinner), this.myFlagProperty);
                return spinner;
            }
        };
    }

    @NotNull
    private FlagEditor<Long> createLongFlagEditor(final Flag<Long> flag) {
        return new FlagEditor<Long>(){
            final FlagProperty<Long> myFlagProperty;
            {
                this.myFlagProperty = new FlagProperty(flag);
            }

            @Override
            @NotNull
            public FlagProperty<Long> flagProperty() {
                return this.myFlagProperty;
            }

            @Override
            @NotNull
            public JComponent editorComponent() {
                SpinnerNumberModel model = new SpinnerNumberModel((Number)flag.get(), Long.valueOf(Long.MIN_VALUE), Long.valueOf(Long.MAX_VALUE), (Number)1L);
                JSpinner spinner = new JSpinner(model);
                StudioFlagsDialog.this.myBindings.bindTwoWay(new SpinnerLongValueProperty(spinner), this.myFlagProperty);
                return spinner;
            }
        };
    }

    @NotNull
    private FlagEditor<Boolean> createBooleanFlagEditor(final Flag<Boolean> flag) {
        return new FlagEditor<Boolean>(){
            final FlagProperty<Boolean> myFlagProperty;
            {
                this.myFlagProperty = new FlagProperty(flag);
            }

            @Override
            @NotNull
            public FlagProperty<Boolean> flagProperty() {
                return this.myFlagProperty;
            }

            @Override
            @NotNull
            public JComponent editorComponent() {
                JPanel choicesPanel = new JPanel(new FlowLayout(0, 2, 0));
                JRadioButton onButton = new JRadioButton("On");
                JRadioButton offButton = new JRadioButton("Off");
                ButtonGroup group2 = new ButtonGroup();
                group2.add(onButton);
                group2.add(offButton);
                StudioFlagsDialog.this.myBindings.bind(new SelectedProperty(onButton), this.myFlagProperty);
                StudioFlagsDialog.this.myBindings.bind(new SelectedProperty(offButton), BooleanExpressions.not(this.myFlagProperty));
                onButton.addActionListener(l -> this.myFlagProperty.set(true));
                offButton.addActionListener(l -> this.myFlagProperty.set(false));
                choicesPanel.add(onButton);
                choicesPanel.add(offButton);
                return choicesPanel;
            }
        };
    }

    private <T extends Enum<T>> FlagEditor<T> createEnumFlagEditor(final Flag<T> flag) {
        final Class<?> enumClass = ((Enum)flag.get()).getClass();
        return new FlagEditor<T>(){
            final FlagProperty<T> myFlagProperty;
            {
                this.myFlagProperty = new FlagProperty(flag);
            }

            @Override
            @NotNull
            public FlagProperty<T> flagProperty() {
                return this.myFlagProperty;
            }

            @Override
            @NotNull
            public JComponent editorComponent() {
                ComboBox comboBox2 = new ComboBox((Object[])((Enum[])enumClass.getEnumConstants()));
                StudioFlagsDialog.this.myBindings.bindTwoWay(ObjectProperty.wrap(new SelectedItemProperty((JComboBox)comboBox2)), this.myFlagProperty);
                return comboBox2;
            }
        };
    }

    @NotNull
    private <T> FlagEditor<T> createCustomFlagEditor(final CustomTypeFlag<T> flag) {
        return new FlagEditor<T>(){
            final FlagProperty<T> myFlagProperty;
            {
                this.myFlagProperty = new FlagProperty(flag);
            }

            @Override
            @NotNull
            public FlagProperty<T> flagProperty() {
                return this.myFlagProperty;
            }

            @Override
            @NotNull
            public JComponent editorComponent() {
                Object[] examples = (String[])flag.getExamples().stream().map(flag::toString).toArray(String[]::new);
                ComboBox comboBox2 = new ComboBox(examples);
                comboBox2.setEditable(true);
                CustomFlagAdapterProperty adapter = new CustomFlagAdapterProperty(flag, ObjectProperty.wrap(new SelectedItemProperty((JComboBox)comboBox2)));
                StudioFlagsDialog.this.myBindings.bindTwoWay(adapter, this.myFlagProperty);
                JBLabel invalidValue = new JBLabel();
                invalidValue.setIcon(AllIcons.General.Warning);
                invalidValue.setOpaque(true);
                StudioFlagsDialog.this.myBindings.bind(new VisibleProperty((JComponent)invalidValue), adapter.inSync().not());
                StudioFlagsDialog.this.myBindings.bind(new TextProperty((JLabel)invalidValue), adapter.errorString);
                JPanel panel2 = new JPanel((LayoutManager)new HorizontalLayout(10));
                panel2.add((Component)comboBox2);
                panel2.add((Component)invalidValue);
                return panel2;
            }
        };
    }

    public void doCancelAction() {
        this.replaceOverrides((FlagValueContainer)StudioFlagSettings.getInstance(), this.myBackupOverrides);
        super.doCancelAction();
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myRootPanel;
    }

    private void createUIComponents() {
        this.myContentPanel = new JPanel((LayoutManager)StudioFlagsDialog.getFlagsPanelDefaultLayout());
    }

    @NotNull
    private static VerticalFlowLayout getFlagsPanelDefaultLayout() {
        return new VerticalFlowLayout(5, 15);
    }

    private static interface FlagEditor<T> {
        @NotNull
        public FlagProperty<T> flagProperty();

        @NotNull
        public JComponent editorComponent();
    }

    private static final class FlagProperty<T>
    extends AbstractProperty<T> {
        private final Flag<T> myFlag;
        private final BoolProperty myOverridden;

        private FlagProperty(Flag<T> flag) {
            this.myFlag = flag;
            this.myOverridden = new BoolValueProperty(this.myFlag.isUserOverridden());
        }

        @Override
        @NotNull
        public T get() {
            return this.myFlag.get();
        }

        public ObservableBool isOverridden() {
            return this.myOverridden;
        }

        @Override
        protected void setDirectly(@NotNull T value2) {
            this.myFlag.override(value2);
            this.myOverridden.set(true);
        }

        public void clearOverride() {
            this.myFlag.clearOverride();
            this.myOverridden.set(false);
            this.notifyInvalidated();
        }
    }

    private static final class CustomFlagAdapterProperty<T>
    extends AdapterProperty<String, T> {
        private final CustomTypeFlag<T> myFlag;
        private final StringProperty errorString = new StringValueProperty();

        public CustomFlagAdapterProperty(@NotNull CustomTypeFlag<T> flag, @NotNull AbstractProperty<String> wrappedProperty) {
            super(wrappedProperty, flag.get());
            this.myFlag = flag;
        }

        @Override
        @Nullable
        protected T convertFromSourceType(@NotNull String value2) {
            T t;
            try {
                t = this.myFlag.fromString(value2);
            }
            catch (Exception e) {
                this.errorString.set(e.getMessage());
                return null;
            }
            this.errorString.set("");
            return t;
        }

        @Override
        @NotNull
        protected String convertFromDestType(@NotNull T value2) {
            return this.myFlag.toString(value2);
        }
    }
}

