/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.processhandler;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.execution.common.processhandler.AndroidProcessMonitorManager;
import com.android.tools.idea.execution.common.processhandler.AndroidProcessMonitorManagerListener;
import com.android.tools.idea.execution.common.processhandler.SingleDeviceAndroidProcessMonitor;
import com.android.tools.idea.execution.common.processhandler.SingleDeviceAndroidProcessMonitorKt;
import com.android.tools.idea.execution.common.processhandler.SingleDeviceAndroidProcessMonitorState;
import com.android.tools.idea.execution.common.processhandler.SingleDeviceAndroidProcessMonitorStateListener;
import com.android.tools.idea.execution.common.processhandler.TextEmitter;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import java.io.Closeable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000m\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\b\u0007*\u0001\u001d\u0018\u00002\u00020\u0001B\u00a3\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u0012f\b\u0002\u0010\u000e\u001a`\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0002\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0004\u0012\u0004\u0012\u00020\u00140\u000fj\u0002`\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\fH\u0007J\u0012\u0010!\u001a\u0004\u0018\u00010\u00142\u0006\u0010 \u001a\u00020\fH\u0007J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010 \u001a\u00020\fH\u0007J\u0012\u0010#\u001a\u0004\u0018\u00010\u00142\u0006\u0010 \u001a\u00020\fH\u0007J\u0010\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020\fH\u0007J\u0016\u0010&\u001a\u0010\u0012\f\u0012\n (*\u0004\u0018\u00010\f0\f0'H\u0007J\b\u0010)\u001a\u00020%H\u0007J\u0010\u0010*\u001a\u00020\r2\u0006\u0010 \u001a\u00020\fH\u0003J\b\u0010+\u001a\u00020\rH\u0017J\b\u0010,\u001a\u00020\rH\u0007J\u0006\u0010-\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rl\u0010\u000e\u001a`\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0002\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0004\u0012\u0004\u0012\u00020\u00140\u000fj\u0002`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00140\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001e\u00a8\u0006."}, d2={"Lcom/android/tools/idea/execution/common/processhandler/AndroidProcessMonitorManager;", "Ljava/io/Closeable;", "targetApplicationId", "", "deploymentApplicationService", "Lcom/android/tools/idea/run/DeploymentApplicationService;", "textEmitter", "Lcom/android/tools/idea/execution/common/processhandler/TextEmitter;", "listener", "Lcom/android/tools/idea/execution/common/processhandler/AndroidProcessMonitorManagerListener;", "finishAndroidProcessCallback", "Lkotlin/Function1;", "Lcom/android/ddmlib/IDevice;", "", "singleDeviceAndroidProcessMonitorFactory", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "name", "targetDevice", "Lcom/android/tools/idea/execution/common/processhandler/SingleDeviceAndroidProcessMonitorStateListener;", "Lcom/android/tools/idea/execution/common/processhandler/SingleDeviceAndroidProcessMonitor;", "Lcom/android/tools/idea/execution/common/processhandler/SingleDeviceAndroidProcessMonitorFactory;", "<init>", "(Ljava/lang/String;Lcom/android/tools/idea/run/DeploymentApplicationService;Lcom/android/tools/idea/execution/common/processhandler/TextEmitter;Lcom/android/tools/idea/execution/common/processhandler/AndroidProcessMonitorManagerListener;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function4;)V", "myMonitors", "Ljava/util/concurrent/ConcurrentMap;", "myIsOnAllTargetProcessesTerminatedCalled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "myMonitorListener", "com/android/tools/idea/execution/common/processhandler/AndroidProcessMonitorManager$myMonitorListener$1", "Lcom/android/tools/idea/execution/common/processhandler/AndroidProcessMonitorManager$myMonitorListener$1;", "add", "device", "closeAndReplace", "detachDevice", "getMonitor", "isAssociated", "", "allMonitoringDevices", "", "kotlin.jvm.PlatformType", "isEmpty", "remove", "close", "detachAndClose", "start", "intellij.android.execution.common"})
@SourceDebugExtension(value={"SMAP\nAndroidProcessMonitorManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidProcessMonitorManager.kt\ncom/android/tools/idea/execution/common/processhandler/AndroidProcessMonitorManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n1869#2,2:186\n1869#2,2:188\n1869#2,2:190\n*S KotlinDebug\n*F\n+ 1 AndroidProcessMonitorManager.kt\ncom/android/tools/idea/execution/common/processhandler/AndroidProcessMonitorManager\n*L\n151#1:186,2\n161#1:188,2\n166#1:190,2\n*E\n"})
public final class AndroidProcessMonitorManager
implements Closeable {
    @NotNull
    private final String targetApplicationId;
    @NotNull
    private final DeploymentApplicationService deploymentApplicationService;
    @NotNull
    private final TextEmitter textEmitter;
    @NotNull
    private final AndroidProcessMonitorManagerListener listener;
    @NotNull
    private final Function4<String, IDevice, SingleDeviceAndroidProcessMonitorStateListener, DeploymentApplicationService, SingleDeviceAndroidProcessMonitor> singleDeviceAndroidProcessMonitorFactory;
    @NotNull
    private final ConcurrentMap<IDevice, SingleDeviceAndroidProcessMonitor> myMonitors;
    @NotNull
    private final AtomicBoolean myIsOnAllTargetProcessesTerminatedCalled;
    @NotNull
    private final myMonitorListener.1 myMonitorListener;

    public AndroidProcessMonitorManager(@NotNull String targetApplicationId, @NotNull DeploymentApplicationService deploymentApplicationService, @NotNull TextEmitter textEmitter, @NotNull AndroidProcessMonitorManagerListener listener2, @NotNull Function1<? super IDevice, Unit> finishAndroidProcessCallback, @NotNull Function4<? super String, ? super IDevice, ? super SingleDeviceAndroidProcessMonitorStateListener, ? super DeploymentApplicationService, SingleDeviceAndroidProcessMonitor> singleDeviceAndroidProcessMonitorFactory) {
        Intrinsics.checkNotNullParameter((Object)targetApplicationId, (String)"targetApplicationId");
        Intrinsics.checkNotNullParameter((Object)deploymentApplicationService, (String)"deploymentApplicationService");
        Intrinsics.checkNotNullParameter((Object)textEmitter, (String)"textEmitter");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter(finishAndroidProcessCallback, (String)"finishAndroidProcessCallback");
        Intrinsics.checkNotNullParameter(singleDeviceAndroidProcessMonitorFactory, (String)"singleDeviceAndroidProcessMonitorFactory");
        this.targetApplicationId = targetApplicationId;
        this.deploymentApplicationService = deploymentApplicationService;
        this.textEmitter = textEmitter;
        this.listener = listener2;
        this.singleDeviceAndroidProcessMonitorFactory = singleDeviceAndroidProcessMonitorFactory;
        this.myMonitors = new ConcurrentHashMap();
        this.myIsOnAllTargetProcessesTerminatedCalled = new AtomicBoolean();
        this.myMonitorListener = new SingleDeviceAndroidProcessMonitorStateListener(this){
            final /* synthetic */ AndroidProcessMonitorManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void onStateChanged(SingleDeviceAndroidProcessMonitor monitor, SingleDeviceAndroidProcessMonitorState newState2) {
                Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
                Intrinsics.checkNotNullParameter((Object)((Object)newState2), (String)"newState");
                if (newState2 == SingleDeviceAndroidProcessMonitorState.PROCESS_NOT_FOUND) {
                    TextEmitter textEmitter = AndroidProcessMonitorManager.access$getTextEmitter$p(this.this$0);
                    String string = "Timed out waiting for process (" + monitor.getTargetApplicationId() + ") to appear on " + monitor.getTargetDevice().getName() + ".\n";
                    Key key = ProcessOutputTypes.STDOUT;
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"STDOUT");
                    textEmitter.emit(string, key);
                }
                if (SingleDeviceAndroidProcessMonitorKt.isTerminalState(newState2)) {
                    AndroidProcessMonitorManager.access$remove(this.this$0, monitor.getTargetDevice());
                }
            }
        };
    }

    public /* synthetic */ AndroidProcessMonitorManager(String string, DeploymentApplicationService deploymentApplicationService, TextEmitter textEmitter, AndroidProcessMonitorManagerListener androidProcessMonitorManagerListener, Function1 function1, Function4 function4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            function4 = (arg_0, arg_1, arg_2, arg_3) -> AndroidProcessMonitorManager._init_$lambda$0(string, deploymentApplicationService, textEmitter, function1, arg_0, arg_1, arg_2, arg_3);
        }
        this(string, deploymentApplicationService, textEmitter, androidProcessMonitorManagerListener, (Function1<? super IDevice, Unit>)function1, (Function4<? super String, ? super IDevice, ? super SingleDeviceAndroidProcessMonitorStateListener, ? super DeploymentApplicationService, SingleDeviceAndroidProcessMonitor>)function4);
    }

    @AnyThread
    public final void add(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.myMonitors.computeIfAbsent(device2, arg_0 -> AndroidProcessMonitorManager.add$lambda$1(arg_0 -> AndroidProcessMonitorManager.add$lambda$0(this, device2, arg_0), arg_0));
    }

    @WorkerThread
    @Nullable
    public final SingleDeviceAndroidProcessMonitor closeAndReplace(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        return this.myMonitors.compute(device2, (arg_0, arg_1) -> AndroidProcessMonitorManager.closeAndReplace$lambda$1((arg_0, arg_1) -> AndroidProcessMonitorManager.closeAndReplace$lambda$0(this, device2, arg_0, arg_1), arg_0, arg_1));
    }

    @WorkerThread
    public final void detachDevice(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        SingleDeviceAndroidProcessMonitor singleDeviceAndroidProcessMonitor = this.getMonitor(device2);
        if (singleDeviceAndroidProcessMonitor != null) {
            singleDeviceAndroidProcessMonitor.detachAndClose();
        }
        this.remove(device2);
    }

    @WorkerThread
    @Nullable
    public final SingleDeviceAndroidProcessMonitor getMonitor(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        return (SingleDeviceAndroidProcessMonitor)this.myMonitors.get(device2);
    }

    @AnyThread
    public final boolean isAssociated(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        return ((Map)this.myMonitors).containsKey(device2);
    }

    @AnyThread
    @NotNull
    public final Set<IDevice> allMonitoringDevices() {
        return this.myMonitors.keySet();
    }

    @AnyThread
    public final boolean isEmpty() {
        return this.myMonitors.isEmpty();
    }

    @WorkerThread
    private final void remove(IDevice device2) {
        if (this.myMonitors.remove(device2) != null && this.myMonitors.isEmpty() && this.myIsOnAllTargetProcessesTerminatedCalled.compareAndSet(false, true)) {
            this.listener.onAllTargetProcessesTerminated();
        }
    }

    @Override
    @WorkerThread
    public void close() {
        Iterable $this$forEach$iv = this.myMonitors.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SingleDeviceAndroidProcessMonitor it = (SingleDeviceAndroidProcessMonitor)element$iv;
            boolean bl = false;
            it.close();
        }
        this.myMonitors.clear();
    }

    @WorkerThread
    public final void detachAndClose() {
        Iterable $this$forEach$iv = this.myMonitors.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SingleDeviceAndroidProcessMonitor it = (SingleDeviceAndroidProcessMonitor)element$iv;
            boolean bl = false;
            it.detachAndClose();
        }
        this.close();
    }

    public final void start() {
        Iterable $this$forEach$iv = this.myMonitors.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SingleDeviceAndroidProcessMonitor it = (SingleDeviceAndroidProcessMonitor)element$iv;
            boolean bl = false;
            it.start();
        }
    }

    private static final SingleDeviceAndroidProcessMonitor _init_$lambda$0(String $targetApplicationId, DeploymentApplicationService $deploymentApplicationService, TextEmitter $textEmitter, Function1 $finishAndroidProcessCallback, String string, IDevice device2, SingleDeviceAndroidProcessMonitorStateListener monitorListener, DeploymentApplicationService deploymentApplicationService) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)monitorListener, (String)"monitorListener");
        Intrinsics.checkNotNullParameter((Object)deploymentApplicationService, (String)"<unused var>");
        return new SingleDeviceAndroidProcessMonitor($targetApplicationId, device2, monitorListener, $deploymentApplicationService, $textEmitter, $finishAndroidProcessCallback, null, null, 192, null);
    }

    private static final SingleDeviceAndroidProcessMonitor add$lambda$0(AndroidProcessMonitorManager this$0, IDevice $device, IDevice it) {
        return (SingleDeviceAndroidProcessMonitor)this$0.singleDeviceAndroidProcessMonitorFactory.invoke((Object)this$0.targetApplicationId, (Object)$device, (Object)this$0.myMonitorListener, (Object)this$0.deploymentApplicationService);
    }

    private static final SingleDeviceAndroidProcessMonitor add$lambda$1(Function1 $tmp0, Object p0) {
        return (SingleDeviceAndroidProcessMonitor)$tmp0.invoke(p0);
    }

    private static final SingleDeviceAndroidProcessMonitor closeAndReplace$lambda$0(AndroidProcessMonitorManager this$0, IDevice $device, IDevice iDevice, SingleDeviceAndroidProcessMonitor monitorValue) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)iDevice, (String)"<unused var>");
            SingleDeviceAndroidProcessMonitor singleDeviceAndroidProcessMonitor = monitorValue;
            if (singleDeviceAndroidProcessMonitor == null) break block0;
            singleDeviceAndroidProcessMonitor.replaceListenerAndClose(null);
        }
        return (SingleDeviceAndroidProcessMonitor)this$0.singleDeviceAndroidProcessMonitorFactory.invoke((Object)this$0.targetApplicationId, (Object)$device, (Object)this$0.myMonitorListener, (Object)this$0.deploymentApplicationService);
    }

    private static final SingleDeviceAndroidProcessMonitor closeAndReplace$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (SingleDeviceAndroidProcessMonitor)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ TextEmitter access$getTextEmitter$p(AndroidProcessMonitorManager $this) {
        return $this.textEmitter;
    }

    public static final /* synthetic */ void access$remove(AndroidProcessMonitorManager $this, IDevice device2) {
        $this.remove(device2);
    }
}

