/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.adb.shell;

import com.android.ddmlib.MultiLineReceiver;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\b\u001a\u00060\tj\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/execution/common/adb/shell/ErrorMatchingReceiver;", "Lcom/android/ddmlib/MultiLineReceiver;", "<init>", "()V", "errorType", "", "failureMessage", "", "output", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getOutput", "()Ljava/lang/StringBuilder;", "processNewLines", "", "lines", "", "([Ljava/lang/String;)V", "isCancelled", "", "hasError", "Companion", "intellij.android.execution.common"})
public final class ErrorMatchingReceiver
extends MultiLineReceiver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int errorType = -2;
    @Nullable
    private String failureMessage;
    @NotNull
    private final StringBuilder output = new StringBuilder();
    private static final int NO_ERROR = -2;
    private static final int UNTYPED_ERROR = -1;
    private static final Pattern FAILURE = Pattern.compile("Failure\\s+\\[(.*)\\]");
    private static final Pattern TYPED_ERROR = Pattern.compile("Error\\s+[Tt]ype\\s+(\\d+).*");
    @NotNull
    private static final String ERROR_PREFIX = "Error";

    @NotNull
    public final StringBuilder getOutput() {
        return this.output;
    }

    public void processNewLines(@NotNull String[] lines) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        for (String line : lines) {
            if (((CharSequence)line).length() > 0) {
                Matcher errorMatcher;
                Matcher failureMatcher = FAILURE.matcher(line);
                if (failureMatcher.matches()) {
                    this.failureMessage = failureMatcher.group(1);
                }
                if ((errorMatcher = TYPED_ERROR.matcher(line)).matches()) {
                    String string = errorMatcher.group(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                    this.errorType = Integer.parseInt(string);
                    this.failureMessage = line;
                } else if (StringsKt.startsWith$default((String)line, (String)ERROR_PREFIX, (boolean)false, (int)2, null) && this.errorType == -2) {
                    this.errorType = -1;
                    this.failureMessage = line;
                }
            }
            this.output.append(line).append('\n');
        }
    }

    public boolean isCancelled() {
        return false;
    }

    public final boolean hasError() {
        return this.errorType != -2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/execution/common/adb/shell/ErrorMatchingReceiver$Companion;", "", "<init>", "()V", "NO_ERROR", "", "UNTYPED_ERROR", "FAILURE", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "TYPED_ERROR", "ERROR_PREFIX", "", "intellij.android.execution.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

