/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.editors.strings.table.SubTableModelListener;
import java.util.function.IntSupplier;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

final class SubTableModel
implements TableModel {
    private final TableModel myDelegate;
    private final IntSupplier myStartColumnSupplier;
    private final IntSupplier myEndColumnSupplier;

    SubTableModel(@NotNull TableModel delegate2, @NotNull IntSupplier startColumnSupplier, @NotNull IntSupplier endColumnSupplier) {
        this.myDelegate = delegate2;
        this.myStartColumnSupplier = startColumnSupplier;
        this.myEndColumnSupplier = endColumnSupplier;
    }

    int convertColumnIndexToDelegate(int modelColumnIndex) {
        assert (0 <= modelColumnIndex && modelColumnIndex < this.getColumnCount());
        return this.myStartColumnSupplier.getAsInt() + modelColumnIndex;
    }

    int convertColumnIndexToModel(int delegateColumnIndex) {
        assert (this.contains(delegateColumnIndex));
        return delegateColumnIndex - this.myStartColumnSupplier.getAsInt();
    }

    boolean contains(int delegateColumnIndex) {
        return this.myStartColumnSupplier.getAsInt() <= delegateColumnIndex && delegateColumnIndex < this.myEndColumnSupplier.getAsInt();
    }

    @NotNull
    IntSupplier getStartColumnSupplier() {
        return this.myStartColumnSupplier;
    }

    @NotNull
    IntSupplier getEndColumnSupplier() {
        return this.myEndColumnSupplier;
    }

    @Override
    public int getRowCount() {
        return this.myDelegate.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.myEndColumnSupplier.getAsInt() - this.myStartColumnSupplier.getAsInt();
    }

    @Override
    @NotNull
    public String getColumnName(int column2) {
        return this.myDelegate.getColumnName(this.convertColumnIndexToDelegate(column2));
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int column2) {
        return this.myDelegate.getColumnClass(this.convertColumnIndexToDelegate(column2));
    }

    @Override
    public boolean isCellEditable(int row, int column2) {
        return this.myDelegate.isCellEditable(row, this.convertColumnIndexToDelegate(column2));
    }

    @Override
    @NotNull
    public Object getValueAt(int row, int column2) {
        return this.myDelegate.getValueAt(row, this.convertColumnIndexToDelegate(column2));
    }

    @Override
    public void setValueAt(@NotNull Object value2, int row, int column2) {
        this.myDelegate.setValueAt(value2, row, this.convertColumnIndexToDelegate(column2));
    }

    @Override
    public void addTableModelListener(@NotNull TableModelListener listener2) {
        this.myDelegate.addTableModelListener(new SubTableModelListener(this, listener2));
    }

    @Override
    public void removeTableModelListener(@NotNull TableModelListener listener2) {
        for (TableModelListener object : ((AbstractTableModel)this.myDelegate).getTableModelListeners()) {
            SubTableModelListener subTableModelListener = (SubTableModelListener)object;
            if (!subTableModelListener.delegate().equals(listener2)) continue;
            this.myDelegate.removeTableModelListener(subTableModelListener);
            break;
        }
    }
}

