/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.editors.strings.table.ActionType;
import com.android.tools.idea.editors.strings.table.FrozenColumnTableEvent;
import com.android.tools.idea.editors.strings.table.FrozenColumnTableListener;
import com.android.tools.idea.editors.strings.table.FrozenColumnTableRowSorter;
import com.android.tools.idea.editors.strings.table.GridPasteUtils;
import com.android.tools.idea.editors.strings.table.SubTable;
import com.android.tools.idea.editors.strings.table.SubTableHoverListener;
import com.android.tools.idea.editors.strings.table.SubTableModel;
import com.android.tools.idea.editors.strings.table.TableAction;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.IntUnaryOperator;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrozenColumnTable<M extends TableModel> {
    private M myModel;
    private final int myFrozenColumnCount;
    private final Collection<FrozenColumnTableListener> myListeners;
    private SubTable<M> myFrozenTable;
    private SubTable<M> myScrollableTable;
    private SubTable<M> myLastFocusedSubTable;
    private JScrollPane myScrollPane;
    private int rowHeight;
    private int myLastSelectedRow;
    private int myLastSelectedColumn;
    private int myAnchorColumn;
    private int mySelectedColumn;
    @Nullable
    private FrozenColumnTableRowSorter<M> myRowSorter;
    private final CellSelectionListener<M> myCellSelectionListener;

    FrozenColumnTable(@NotNull M model, int frozenColumnCount) {
        this.myModel = model;
        this.myFrozenColumnCount = frozenColumnCount;
        this.myListeners = new ArrayList<FrozenColumnTableListener>();
        this.myCellSelectionListener = new CellSelectionListener();
        this.initFrozenTable();
        this.initScrollableTable();
        this.initScrollPane();
        this.myLastFocusedSubTable = this.myFrozenTable;
        this.registerActionOverrides();
        new SubTableHoverListener(this.myFrozenTable, this.myScrollableTable).install();
        this.myLastSelectedRow = -1;
        this.myLastSelectedColumn = -1;
        this.myAnchorColumn = -1;
        this.mySelectedColumn = -1;
    }

    private void registerActionOverrides() {
        this.registerActionOverrides((JTable)((Object)this.myFrozenTable));
        this.registerActionOverrides((JTable)((Object)this.myScrollableTable));
    }

    private void registerActionOverrides(@NotNull JTable table2) {
        ActionMap map2 = table2.getActionMap();
        for (ActionType type : ActionType.getEntries()) {
            map2.put(type.getActionName(), new TableAction(type, this));
        }
    }

    private void initFrozenTable() {
        this.myFrozenTable = new SubTable(new SubTableModel((TableModel)this.myModel, () -> 0, () -> this.myFrozenColumnCount), this);
        this.myFrozenTable.setName("frozenTable");
        IntUnaryOperator converter = IntUnaryOperator.identity();
        this.myFrozenTable.getTableHeader().addMouseListener(new HeaderPopupTriggerListener(converter));
        this.myFrozenTable.getSelectionModel().addListSelectionListener(event -> {
            this.mirrorRowSelection((JTable)((Object)this.myFrozenTable), (JTable)((Object)this.myScrollableTable));
            this.fireSelectedCellChanged(false);
        });
        this.myFrozenTable.getColumnModel().getSelectionModel().addListSelectionListener(event -> {
            this.removeEmptyColumnSelection((JTable)((Object)this.myFrozenTable));
            this.fireSelectedCellChanged(false);
        });
        this.myFrozenTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@NotNull ComponentEvent event) {
                JViewport header = FrozenColumnTable.this.myScrollPane.getRowHeader();
                Dimension size = ((Component)header).getPreferredSize();
                size.width = FrozenColumnTable.this.myFrozenTable.getWidth();
                ((Component)header).setPreferredSize(size);
                FrozenColumnTable.this.myScrollPane.revalidate();
            }
        });
        this.myFrozenTable.addMouseListener(new CellPopupTriggerListener(converter));
        this.myFrozenTable.addMouseListener(this.myCellSelectionListener);
        this.myFrozenTable.addMouseMotionListener(this.myCellSelectionListener);
        this.myFrozenTable.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent event) {
                FrozenColumnTable.this.myLastFocusedSubTable = FrozenColumnTable.this.myFrozenTable;
            }
        });
    }

    private void initScrollableTable() {
        this.myScrollableTable = new SubTable(new SubTableModel((TableModel)this.myModel, () -> this.myFrozenColumnCount, () -> this.myModel.getColumnCount()), this);
        this.myScrollableTable.setName("scrollableTable");
        IntUnaryOperator converter = viewColumnIndex -> this.myFrozenTable.getColumnCount() + viewColumnIndex;
        this.myScrollableTable.getTableHeader().addMouseListener(new HeaderPopupTriggerListener(converter));
        this.myScrollableTable.getSelectionModel().addListSelectionListener(event -> {
            this.mirrorRowSelection((JTable)((Object)this.myScrollableTable), (JTable)((Object)this.myFrozenTable));
            this.fireSelectedCellChanged(false);
        });
        this.myScrollableTable.getColumnModel().getSelectionModel().addListSelectionListener(event -> {
            this.removeEmptyColumnSelection((JTable)((Object)this.myScrollableTable));
            this.fireSelectedCellChanged(false);
        });
        this.myScrollableTable.addMouseListener(new CellPopupTriggerListener(converter));
        this.myScrollableTable.addMouseListener(this.myCellSelectionListener);
        this.myScrollableTable.addMouseMotionListener(this.myCellSelectionListener);
        this.myScrollableTable.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent event) {
                FrozenColumnTable.this.myLastFocusedSubTable = FrozenColumnTable.this.myScrollableTable;
            }
        });
    }

    private void mirrorRowSelection(@NotNull JTable fromTable, JTable toTable) {
        ListSelectionModel fsm = fromTable.getSelectionModel();
        int first = fsm.getMinSelectionIndex();
        int last = fsm.getMaxSelectionIndex();
        if (first == -1) {
            toTable.clearSelection();
        } else {
            if (fsm.getLeadSelectionIndex() == first) {
                int temp = first;
                first = last;
                last = temp;
            }
            toTable.setRowSelectionInterval(first, last);
        }
    }

    private void removeEmptyColumnSelection(@NotNull JTable table2) {
        ListSelectionModel sm = table2.getColumnModel().getSelectionModel();
        if (!(this.mySelectedColumn >= 0 && this.myAnchorColumn >= 0 || sm.isSelectionEmpty())) {
            this.mySelectedColumn = this.adjustedColumnIndex(sm.getLeadSelectionIndex(), table2);
            this.myAnchorColumn = this.adjustedColumnIndex(sm.getAnchorSelectionIndex(), table2);
        }
    }

    private int adjustedColumnIndex(int index, JTable table2) {
        if (index < 0) {
            return index;
        }
        return table2 == this.myFrozenTable ? index : index + this.getFrozenColumnCount();
    }

    public boolean skipTransferTo(@NotNull Component toComponent, @NotNull Component fromComponent) {
        if (fromComponent instanceof SubTable) {
            return toComponent instanceof SubTable;
        }
        return toComponent instanceof SubTable && this.myLastFocusedSubTable != toComponent;
    }

    private void fireSelectedCellChanged(boolean force) {
        int selectedRow = this.getSelectedRow();
        int selectedColumn = this.getSelectedColumn();
        if (!force && this.myLastSelectedRow == selectedRow && this.myLastSelectedColumn == selectedColumn) {
            return;
        }
        this.myLastSelectedRow = selectedRow;
        this.myLastSelectedColumn = selectedColumn;
        this.myListeners.forEach(FrozenColumnTableListener::selectedCellChanged);
    }

    private void initScrollPane() {
        this.myScrollPane = new JBScrollPane(this.myScrollableTable);
        this.myScrollPane.setCorner("UPPER_LEFT_CORNER", this.myFrozenTable.getTableHeader());
        this.myScrollPane.setRowHeaderView((Component)((Object)this.myFrozenTable));
        JViewport frozenViewport = (JViewport)this.myFrozenTable.getParent();
        JViewport scrollableViewport = (JViewport)this.myScrollableTable.getParent();
        frozenViewport.addChangeListener(event -> {
            int y = frozenViewport.getViewPosition().y;
            Point pos = scrollableViewport.getViewPosition();
            if (pos.y != y) {
                pos.y = y;
                scrollableViewport.setViewPosition(pos);
            }
        });
        scrollableViewport.addChangeListener(event -> {
            int y = scrollableViewport.getViewPosition().y;
            Point pos = frozenViewport.getViewPosition();
            if (pos.y != y) {
                pos.y = y;
                frozenViewport.setViewPosition(pos);
            }
        });
    }

    boolean includeColumn(int modelColumnIndex) {
        return true;
    }

    @NotNull
    TableColumn createColumn(int modelColumnIndex) {
        return new TableColumn(modelColumnIndex);
    }

    public final void setRowSelectionInterval(int viewRowIndexStart, int viewRowIndexEnd) {
        this.myFrozenTable.setRowSelectionInterval(viewRowIndexStart, viewRowIndexEnd);
        this.myScrollableTable.setRowSelectionInterval(viewRowIndexStart, viewRowIndexEnd);
    }

    public final void selectCellAt(int viewRowIndex, int viewColumnIndex) {
        this.setRowSelectionInterval(viewRowIndex, viewRowIndex);
        this.gotoColumn(viewColumnIndex, false);
    }

    public final int getSelectedModelRowIndex() {
        int row = this.getSelectedRow();
        return this.myFrozenTable.convertRowIndexToModel(row);
    }

    public final int[] getSelectedModelRows() {
        int[] indexes = this.myFrozenTable.getSelectedRows();
        assert (Arrays.equals(indexes, this.myScrollableTable.getSelectedRows()));
        return Arrays.stream(indexes).map(index -> this.convertRowIndexToModel(index)).toArray();
    }

    public final int getSelectedRowCount() {
        int count = this.myFrozenTable.getSelectedRowCount();
        assert (count == this.myScrollableTable.getSelectedRowCount());
        return count;
    }

    public final int getSelectedModelColumnIndex() {
        int column2 = this.getSelectedColumn();
        return column2 >= 0 ? this.convertColumnIndexToModel(column2) : -1;
    }

    public final void selectAll() {
        if (this.getRowCount() == 0) {
            return;
        }
        this.myFrozenTable.changeSelection(this.getRowCount() - 1, this.getFrozenColumnCount() - 1, false, false);
        this.myScrollableTable.changeSelection(this.getRowCount() - 1, this.getScrollableTable().getColumnCount() - 1, false, false);
        this.myFrozenTable.changeSelection(0, 0, false, true);
        this.myScrollableTable.changeSelection(0, 0, false, true);
        this.myAnchorColumn = this.getColumnCount() - 1;
        this.mySelectedColumn = 0;
        this.scrollIntoView();
    }

    public final void clearSelection() {
        this.myAnchorColumn = -1;
        this.mySelectedColumn = -1;
        this.myFrozenTable.clearSelection();
        this.myScrollableTable.clearSelection();
    }

    public final void gotoRow(int row) {
        if (this.getRowCount() == 0) {
            return;
        }
        row = Math.max(0, Math.min(row, this.getRowCount() - 1));
        int column2 = Math.max(0, this.mySelectedColumn);
        this.myFrozenTable.getSelectionModel().setSelectionInterval(row, row);
        this.myScrollableTable.getSelectionModel().setSelectionInterval(row, row);
        int fixedColumns = this.getFrozenColumnCount();
        if (column2 < fixedColumns) {
            this.myFrozenTable.getColumnModel().getSelectionModel().setSelectionInterval(column2, column2);
            this.myScrollableTable.getColumnModel().getSelectionModel().clearSelection();
        } else {
            this.myFrozenTable.getColumnModel().getSelectionModel().clearSelection();
            this.myScrollableTable.getColumnModel().getSelectionModel().setSelectionInterval(column2 - fixedColumns, column2 - fixedColumns);
        }
        this.myAnchorColumn = column2;
        this.mySelectedColumn = column2;
        this.fireSelectedCellChanged(false);
        this.scrollIntoView();
    }

    public final void scrollRow(boolean forwards) {
        int selectedRow = this.getSelectedRow();
        if (selectedRow < 0 || !(SwingUtilities.getUnwrappedParent(this.myFrozenTable).getParent() instanceof JScrollPane)) {
            return;
        }
        Dimension delta = this.myFrozenTable.getParent().getSize();
        Rectangle r = this.myFrozenTable.getCellRect(selectedRow, 0, true);
        r.y = forwards ? (r.y += Math.max(delta.height, r.height)) : (r.y -= delta.height);
        int newRow = this.myFrozenTable.rowAtPoint(r.getLocation());
        if (newRow == -1 && forwards) {
            newRow = this.getRowCount();
        }
        this.gotoRow(newRow);
    }

    public final void gotoColumn(int column2, boolean extendFromAnchor) {
        if (!extendFromAnchor) {
            this.myAnchorColumn = -1;
            int row = this.getSelectedRow();
            this.myFrozenTable.getSelectionModel().setSelectionInterval(row, row);
        }
        if (column2 < this.getFrozenColumnCount()) {
            this.gotoFrozenColumn(column2);
        } else {
            this.gotoScrollableColumn(column2 - this.getFrozenColumnCount());
        }
        this.fireSelectedCellChanged(false);
        this.scrollIntoView();
    }

    private void gotoFrozenColumn(int column2) {
        int scrollableAnchor;
        int targetColumn = Math.max(0, column2);
        if (this.myAnchorColumn < 0) {
            this.myAnchorColumn = targetColumn;
        }
        if ((scrollableAnchor = this.myAnchorColumn - this.getFrozenColumnCount()) < 0) {
            this.myScrollableTable.getColumnModel().getSelectionModel().clearSelection();
        } else {
            this.myScrollableTable.getColumnModel().getSelectionModel().setSelectionInterval(scrollableAnchor, 0);
        }
        int frozenAnchor = Math.min(this.myAnchorColumn, this.getFrozenColumnCount() - 1);
        this.myFrozenTable.getColumnModel().getSelectionModel().setSelectionInterval(frozenAnchor, targetColumn);
        if (!this.myFrozenTable.hasFocus()) {
            this.myFrozenTable.requestFocus();
        }
        this.mySelectedColumn = targetColumn;
    }

    private void gotoScrollableColumn(int column2) {
        int targetColumn = Math.min(this.myScrollableTable.getColumnCount() - 1, column2);
        if (this.myAnchorColumn < 0) {
            this.myAnchorColumn = targetColumn + this.getFrozenColumnCount();
        }
        if (this.myAnchorColumn >= this.myFrozenTable.getColumnCount()) {
            this.myFrozenTable.getColumnModel().getSelectionModel().clearSelection();
        } else {
            this.myFrozenTable.getColumnModel().getSelectionModel().setSelectionInterval(this.myAnchorColumn, this.getFrozenColumnCount() - 1);
        }
        int scrollableAnchor = Math.max(this.myAnchorColumn - this.getFrozenColumnCount(), 0);
        this.myScrollableTable.getColumnModel().getSelectionModel().setSelectionInterval(scrollableAnchor, targetColumn);
        if (!this.myScrollableTable.hasFocus()) {
            this.myScrollableTable.requestFocus();
        }
        this.mySelectedColumn = targetColumn + this.getFrozenColumnCount();
    }

    private void scrollIntoView() {
        Rectangle cellRect;
        int row = this.getSelectedRow();
        int column2 = this.mySelectedColumn;
        if (row < 0 || column2 < 0) {
            return;
        }
        SubTable<M> table2 = this.myFrozenTable;
        if (column2 >= this.getFrozenColumnCount()) {
            table2 = this.myScrollableTable;
            column2 -= this.getFrozenColumnCount();
        }
        if ((cellRect = ((JTable)((Object)table2)).getCellRect(row, column2, false)) != null) {
            ((JComponent)((Object)table2)).scrollRectToVisible(cellRect);
        }
    }

    @Nullable
    private JViewport getViewportOf(JTable table2) {
        Container parent = table2.getParent();
        return parent instanceof JViewport ? (JViewport)parent : null;
    }

    public final int getFrozenColumnCount() {
        return this.myFrozenTable.getColumnCount();
    }

    @NotNull
    public final TableColumn getColumn(int viewColumnIndex) {
        if (viewColumnIndex < this.myFrozenTable.getColumnCount()) {
            return this.myFrozenTable.getColumnModel().getColumn(viewColumnIndex);
        }
        return this.myScrollableTable.getColumnModel().getColumn(viewColumnIndex - this.myFrozenTable.getColumnCount());
    }

    final int convertRowIndexToModel(int viewRowIndex) {
        int modelRowIndex = this.myFrozenTable.convertRowIndexToModel(viewRowIndex);
        assert (modelRowIndex == this.myScrollableTable.convertRowIndexToModel(viewRowIndex));
        return modelRowIndex;
    }

    final int convertColumnIndexToModel(int viewColumnIndex) {
        SubTable<M> table2;
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count) {
            table2 = this.myFrozenTable;
        } else {
            table2 = this.myScrollableTable;
            viewColumnIndex -= count;
        }
        return ((SubTableModel)((JTable)((Object)table2)).getModel()).convertColumnIndexToDelegate(((JTable)((Object)table2)).convertColumnIndexToModel(viewColumnIndex));
    }

    @NotNull
    final TableCellRenderer getDefaultTableHeaderRenderer() {
        return this.myFrozenTable.getTableHeader().getDefaultRenderer();
    }

    @NotNull
    final TableCellRenderer getCellRenderer(int viewRowIndex, int viewColumnIndex) {
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count) {
            return this.myFrozenTable.getCellRenderer(viewRowIndex, viewColumnIndex);
        }
        return this.myScrollableTable.getCellRenderer(viewRowIndex, viewColumnIndex - count);
    }

    final int getPreferredWidth(@NotNull TableCellRenderer renderer2, @NotNull Object value2, int viewRowIndex, int viewColumnIndex) {
        SubTable<M> table2;
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count) {
            table2 = this.myFrozenTable;
        } else {
            table2 = this.myScrollableTable;
            viewColumnIndex -= count;
        }
        return renderer2.getTableCellRendererComponent(table2, (Object)value2, (boolean)false, (boolean)false, (int)viewRowIndex, (int)viewColumnIndex).getPreferredSize().width + 2;
    }

    @NotNull
    public final JTable getFrozenTable() {
        return this.myFrozenTable;
    }

    @NotNull
    public final JTable getScrollableTable() {
        return this.myScrollableTable;
    }

    @NotNull
    public final Component getScrollPane() {
        return this.myScrollPane;
    }

    final int getRowHeight() {
        return this.rowHeight;
    }

    final void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
    }

    final void putInInputMap(@NotNull KeyStroke keyStroke, @NotNull Object actionMapKey) {
        this.myFrozenTable.getInputMap().put(keyStroke, actionMapKey);
        this.myScrollableTable.getInputMap().put(keyStroke, actionMapKey);
    }

    public final void putInActionMap(@NotNull Object key, @NotNull Action action2) {
        this.myFrozenTable.getActionMap().put(key, action2);
        this.myScrollableTable.getActionMap().put(key, action2);
    }

    public final void addFrozenColumnTableListener(@NotNull FrozenColumnTableListener listener2) {
        this.myListeners.add(listener2);
    }

    @NotNull
    final Iterable<FrozenColumnTableListener> getListeners() {
        return this.myListeners;
    }

    boolean isPastePossible() {
        return false;
    }

    final void paste(@NotNull Transferable transferable) {
        if (!this.hasSelectedCell() || !transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return;
        }
        int row = this.getSelectedRow();
        int rowCount = this.getRowCount();
        int selectedColumn = this.getSelectedColumn();
        int columnCount = this.getColumnCount();
        List<List<String>> grid = GridPasteUtils.splitIntoGrid(FrozenColumnTable.getTransferDataAsString(transferable));
        for (List<String> gridRow : grid) {
            if (row >= rowCount) break;
            int column2 = selectedColumn;
            for (String gridCell : gridRow) {
                if (column2 >= columnCount) break;
                this.setValueAt(gridCell, row, column2++);
            }
            ++row;
        }
        this.fireSelectedCellChanged(true);
    }

    @NotNull
    private static String getTransferDataAsString(@NotNull Transferable transferable) {
        try {
            return (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            Logger.getInstance(FrozenColumnTable.class).warn((Throwable)exception);
            return "";
        }
    }

    final void createDefaultColumnsFromModel() {
        this.myFrozenTable.createDefaultColumnsFromModel();
        this.myScrollableTable.createDefaultColumnsFromModel();
    }

    final void setDefaultRenderer(@NotNull Class<?> c, @NotNull TableCellRenderer renderer2) {
        this.myFrozenTable.setDefaultRenderer(c, renderer2);
        this.myScrollableTable.setDefaultRenderer(c, renderer2);
    }

    final void setDefaultEditor(@NotNull Class<?> c, @NotNull TableCellEditor editor) {
        this.myFrozenTable.setDefaultEditor(c, editor);
        this.myScrollableTable.setDefaultEditor(c, editor);
    }

    @Nullable
    final FrozenColumnTableRowSorter<M> getRowSorter() {
        return this.myRowSorter;
    }

    final void setRowSorter(@Nullable FrozenColumnTableRowSorter<M> rowSorter) {
        if (rowSorter == null) {
            this.myFrozenTable.setRowSorter(null);
            this.myScrollableTable.setRowSorter(null);
        } else {
            this.myFrozenTable.setRowSorter(rowSorter.getFrozenTableRowSorter());
            this.myScrollableTable.setRowSorter(rowSorter.getScrollableTableRowSorter());
        }
        this.myRowSorter = rowSorter;
    }

    public final boolean hasSelectedCell() {
        return this.getSelectedRow() >= 0 && this.getSelectedColumn() >= 0;
    }

    public final int getSelectedRow() {
        int row = this.getSelectedRow((JTable)((Object)this.myFrozenTable));
        assert (row == this.getSelectedRow((JTable)((Object)this.myScrollableTable)));
        return row;
    }

    private int getSelectedRow(@NotNull JTable table2) {
        ListSelectionModel sm = table2.getSelectionModel();
        return sm.isSelectionEmpty() ? -1 : sm.getLeadSelectionIndex();
    }

    public final int getSelectedColumn() {
        return this.mySelectedColumn;
    }

    public final int getAnchorColumn() {
        return this.myAnchorColumn;
    }

    public final int getRowCount() {
        int count = this.myFrozenTable.getRowCount();
        assert (count == this.myScrollableTable.getRowCount());
        return count;
    }

    public final int getColumnCount() {
        return this.myFrozenTable.getColumnCount() + this.myScrollableTable.getColumnCount();
    }

    @NotNull
    public final String getColumnName(int viewColumnIndex) {
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count) {
            return this.myFrozenTable.getColumnName(viewColumnIndex);
        }
        return this.myScrollableTable.getColumnName(viewColumnIndex - count);
    }

    @VisibleForTesting
    @NotNull
    public final List<Object> getColumnAt(int viewColumnIndex) {
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count) {
            return this.myFrozenTable.getColumnAt(viewColumnIndex);
        }
        return this.myScrollableTable.getColumnAt(viewColumnIndex - count);
    }

    @NotNull
    public final Object getValueAt(int viewRowIndex, int viewColumnIndex) {
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count) {
            return this.myFrozenTable.getValueAt(viewRowIndex, viewColumnIndex);
        }
        return this.myScrollableTable.getValueAt(viewRowIndex, viewColumnIndex - count);
    }

    private void setValueAt(@NotNull Object value2, int viewRowIndex, int viewColumnIndex) {
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count) {
            this.myFrozenTable.setValueAt(value2, viewRowIndex, viewColumnIndex);
            return;
        }
        this.myScrollableTable.setValueAt(value2, viewRowIndex, viewColumnIndex - count);
    }

    public final boolean editCellAt(int viewRowIndex, int viewColumnIndex) {
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count) {
            return this.myFrozenTable.editCellAt(viewRowIndex, viewColumnIndex);
        }
        return this.myScrollableTable.editCellAt(viewRowIndex, viewColumnIndex - count);
    }

    @NotNull
    public final M getModel() {
        return this.myModel;
    }

    public void setModel(@NotNull M model) {
        this.myModel = model;
        this.myFrozenTable.setModel(new SubTableModel((TableModel)model, () -> 0, () -> this.myFrozenColumnCount));
        this.myScrollableTable.setModel(new SubTableModel((TableModel)model, () -> this.myFrozenColumnCount, () -> model.getColumnCount()));
    }

    @Nullable
    public final TableCellEditor getCellEditor() {
        if (this.myFrozenTable.isEditing()) {
            return this.myFrozenTable.getCellEditor();
        }
        return this.myScrollableTable.getCellEditor();
    }

    @NotNull
    final Font getFont() {
        Font font = this.myFrozenTable.getFont();
        assert (font.equals(this.myScrollableTable.getFont()));
        return font;
    }

    private static final class CellSelectionListener<M extends TableModel>
    extends MouseAdapter {
        private CellSelectionListener() {
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            SubTable subTable = (SubTable)((Object)event.getSource());
            FrozenColumnTable source2 = subTable.getFrozenColumnTable();
            Point point = event.getPoint();
            int viewRowIndex = subTable.rowAtPoint(point);
            int viewColumnIndex = source2.adjustedColumnIndex(subTable.columnAtPoint(point), (JTable)((Object)subTable));
            boolean extend = event.isShiftDown();
            source2.gotoColumn(viewColumnIndex, extend);
            int viewRowAnchor = !extend || subTable.getSelectionModel().isSelectionEmpty() ? viewRowIndex : subTable.getSelectionModel().getAnchorSelectionIndex();
            subTable.getSelectionModel().setSelectionInterval(viewRowAnchor, viewRowIndex);
            event.consume();
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent event) {
            SubTable subTable = (SubTable)((Object)event.getSource());
            FrozenColumnTable source2 = subTable.getFrozenColumnTable();
            Point point = event.getPoint();
            int viewRowIndex = subTable.rowAtPoint(point);
            int viewColumnIndex = source2.adjustedColumnIndex(subTable.columnAtPoint(point), (JTable)((Object)subTable));
            if (viewColumnIndex < 0) {
                JTable otherTable = source2.getFrozenTable() == subTable ? source2.getScrollableTable() : source2.getFrozenTable();
                point = SwingUtilities.convertPoint((Component)((Object)subTable), point, otherTable);
                viewColumnIndex = source2.adjustedColumnIndex(otherTable.columnAtPoint(point), otherTable);
            }
            source2.gotoColumn(viewColumnIndex, true);
            int viewRowAnchor = subTable.getSelectionModel().isSelectionEmpty() ? viewRowIndex : subTable.getSelectionModel().getAnchorSelectionIndex();
            subTable.getSelectionModel().setSelectionInterval(viewRowAnchor, viewRowIndex);
            event.consume();
        }
    }

    private static final class HeaderPopupTriggerListener<M extends TableModel>
    extends MouseAdapter {
        private final IntUnaryOperator myConverter;

        private HeaderPopupTriggerListener(@NotNull IntUnaryOperator converter) {
            this.myConverter = converter;
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            this.mousePressedOrReleased(event);
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            this.mousePressedOrReleased(event);
        }

        private void mousePressedOrReleased(@NotNull MouseEvent event) {
            Point point;
            if (!event.isPopupTrigger()) {
                return;
            }
            JTableHeader header = (JTableHeader)event.getSource();
            int subTableIndex = header.columnAtPoint(point = event.getPoint());
            if (subTableIndex == -1) {
                return;
            }
            SubTable subTable = (SubTable)((Object)header.getTable());
            FrozenColumnTable source2 = subTable.getFrozenColumnTable();
            int frozenColumnTableIndex = this.myConverter.applyAsInt(subTableIndex);
            FrozenColumnTableEvent frozenColumnTableEvent = new FrozenColumnTableEvent(source2, -1, frozenColumnTableIndex, point, header);
            source2.getListeners().forEach(listener2 -> listener2.headerPopupTriggered(frozenColumnTableEvent));
        }
    }

    private static final class CellPopupTriggerListener<M extends TableModel>
    extends MouseAdapter {
        private final IntUnaryOperator myConverter;

        private CellPopupTriggerListener(@NotNull IntUnaryOperator converter) {
            this.myConverter = converter;
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            this.mousePressedOrReleased(event);
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            this.mousePressedOrReleased(event);
        }

        private void mousePressedOrReleased(@NotNull MouseEvent event) {
            if (!event.isPopupTrigger()) {
                return;
            }
            SubTable subTable = (SubTable)((Object)event.getSource());
            Point point = event.getPoint();
            FrozenColumnTable source2 = subTable.getFrozenColumnTable();
            int viewRowIndex = subTable.rowAtPoint(point);
            int viewColumnIndex = this.myConverter.applyAsInt(subTable.columnAtPoint(point));
            FrozenColumnTableEvent frozenColumnTableEvent = new FrozenColumnTableEvent(source2, viewRowIndex, viewColumnIndex, point, (Component)((Object)subTable));
            source2.getListeners().forEach(listener2 -> listener2.cellPopupTriggered(frozenColumnTableEvent));
        }
    }
}

