/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.resources.Locale;
import com.android.ide.common.resources.ResourceItem;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.StringResourceViewPanel;
import com.android.tools.idea.editors.strings.table.FrozenColumnTableEvent;
import com.android.tools.idea.editors.strings.table.StringResourceTable;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteStringAction
extends AbstractAction {
    private final StringResourceViewPanel myPanel;

    public DeleteStringAction(@NotNull StringResourceViewPanel panel2) {
        super("Delete");
        this.myPanel = panel2;
    }

    public void update(@NotNull JMenuItem delete2, @NotNull FrozenColumnTableEvent event) {
        ResourceItem item;
        StringResourceTable table2 = this.myPanel.getTable();
        int modelRow = table2.getSelectedModelRowIndex();
        int modelColumn = table2.getSelectedModelColumnIndex();
        int viewRow = event.getViewRowIndex();
        int viewColumn = event.getViewColumnIndex();
        if ((modelRow == -1 || modelColumn == -1) && viewRow >= 0 && viewColumn >= 0) {
            table2.selectCellAt(viewRow, viewColumn);
            modelRow = table2.getSelectedModelRowIndex();
            modelColumn = table2.getSelectedModelColumnIndex();
        }
        if (!StringResourceTableModel.isStringValueColumn(modelColumn)) {
            delete2.setText("Delete Key(s)");
            delete2.setVisible(true);
            return;
        }
        StringResourceTableModel model = (StringResourceTableModel)table2.getModel();
        Locale locale = model.getLocale(modelColumn);
        StringResource resource = model.getStringResourceAt(modelRow);
        ResourceItem resourceItem = item = locale == null ? resource.getDefaultValueAsResourceItem() : resource.getTranslationAsResourceItem(locale);
        if (item != null) {
            delete2.setText("Delete String(s)");
            delete2.setVisible(true);
            return;
        }
        delete2.setVisible(false);
    }

    @Override
    public void actionPerformed(@Nullable ActionEvent event) {
        this.myPanel.deleteStrings();
    }
}

