/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.jfr;

import com.android.tools.idea.diagnostics.TruncatingStringBuilder;
import com.android.tools.idea.diagnostics.jfr.EventFilter;
import com.android.tools.idea.diagnostics.jfr.Sample;
import com.android.tools.idea.diagnostics.jfr.analysis.CallTree;
import com.android.tools.idea.diagnostics.jfr.analysis.IdleStacks;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedFrame;
import jdk.jfr.consumer.RecordedThread;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0011H\u0002J\u000e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0019H\u0002J\b\u0010\"\u001a\u00020\u0014H\u0002J\u0012\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040$*\u00020\u0016H\u0002R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00110\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/CallTreeAggregator;", "", "threadFilter", "Lkotlin/Function1;", "", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "getThreadFilter", "()Lkotlin/jvm/functions/Function1;", "samples", "", "", "", "Lcom/android/tools/idea/diagnostics/jfr/Sample;", "threadIdToName", "callTrees", "Lcom/android/tools/idea/diagnostics/jfr/analysis/CallTree;", "edtId", "accept", "", "e", "Ljdk/jfr/consumer/RecordedEvent;", "processBatch", "endTime", "Ljava/time/Instant;", "getReportForThread", "tid", "tree", "generateReport", "maxLengthBytes", "", "sortSamplesAndComputeDurations", "end", "aggregate", "getStacktrace", "", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nCallTreeAggregator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallTreeAggregator.kt\ncom/android/tools/idea/diagnostics/jfr/CallTreeAggregator\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,109:1\n382#2,7:110\n1068#3:117\n1869#3,2:118\n1011#3,2:121\n1869#3,2:125\n1563#3:128\n1634#3,3:129\n216#4:120\n217#4:123\n216#4:124\n217#4:127\n*S KotlinDebug\n*F\n+ 1 CallTreeAggregator.kt\ncom/android/tools/idea/diagnostics/jfr/CallTreeAggregator\n*L\n47#1:110,7\n64#1:117\n64#1:118,2\n72#1:121,2\n83#1:125,2\n91#1:128\n91#1:129,3\n71#1:120\n71#1:123\n81#1:124\n81#1:127\n*E\n"})
public final class CallTreeAggregator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<String, Boolean> threadFilter;
    @NotNull
    private final Map<Long, List<Sample>> samples;
    @NotNull
    private final Map<Long, String> threadIdToName;
    @NotNull
    private final Map<Long, CallTree> callTrees;
    private long edtId;
    @NotNull
    private static final String EDT = "AWT-EventQueue-0";
    @NotNull
    private static final Function1<String, Boolean> THREAD_FILTER_ALL = CallTreeAggregator::THREAD_FILTER_ALL$lambda$0;
    @NotNull
    private static final Function1<String, Boolean> THREAD_FILTER_EDT_ONLY = CallTreeAggregator::THREAD_FILTER_EDT_ONLY$lambda$0;

    public CallTreeAggregator(@NotNull Function1<? super String, Boolean> threadFilter) {
        Intrinsics.checkNotNullParameter(threadFilter, (String)"threadFilter");
        this.threadFilter = threadFilter;
        this.samples = new LinkedHashMap();
        this.threadIdToName = new LinkedHashMap();
        this.callTrees = new LinkedHashMap();
    }

    @NotNull
    public final Function1<String, Boolean> getThreadFilter() {
        return this.threadFilter;
    }

    /*
     * WARNING - void declaration
     */
    public final void accept(@NotNull RecordedEvent e) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!EventFilter.Companion.getSAMPLING_EVENT_NAMES().contains(e.getEventType().getName())) {
            return;
        }
        RecordedThread thread = e.getThread("sampledThread");
        long tid = thread.getJavaThreadId();
        String threadName = thread.getJavaName();
        Intrinsics.checkNotNull((Object)threadName);
        if (!((Boolean)this.threadFilter.invoke((Object)threadName)).booleanValue()) {
            return;
        }
        this.threadIdToName.put(tid, threadName);
        if (Intrinsics.areEqual((Object)threadName, (Object)EDT)) {
            this.edtId = tid;
        }
        if (IdleStacks.Companion.isIgnoredThread(threadName)) {
            return;
        }
        List stacktrace = this.getStacktrace(e);
        if (IdleStacks.Companion.isIdle(threadName, stacktrace)) {
            stacktrace = CollectionsKt.listOf((Object)"IDLE.IDLE(Unknown Source)");
        }
        Instant instant = e.getStartTime();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"getStartTime(...)");
        Sample sample = new Sample(threadName, instant, 0L, stacktrace);
        Map<Long, List<Sample>> map2 = this.samples;
        Long key$iv = tid;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(sample);
    }

    public final void processBatch(@NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        this.sortSamplesAndComputeDurations(endTime);
        this.aggregate();
        this.samples.clear();
    }

    private final String getReportForThread(long tid, CallTree tree) {
        return this.threadIdToName.get(tid) + ", TID: " + tid + " [" + tree.getTime() + "ms] (" + tree.getSampleCount() + ")\n" + tree + "\n";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String generateReport(int maxLengthBytes) {
        void $this$forEach$iv;
        CallTree edtTree = this.callTrees.remove(this.edtId);
        TruncatingStringBuilder sb = new TruncatingStringBuilder(maxLengthBytes, "\n...report truncated...");
        if (edtTree != null) {
            sb.append(this.getReportForThread(this.edtId, edtTree));
        }
        Iterable $this$sortedByDescending$iv = CollectionsKt.toList((Iterable)this.callTrees.entrySet());
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((CallTree)it.getValue()).numNodesAboveCutoff());
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((CallTree)it.getValue()).numNodesAboveCutoff()));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            long tid = ((Number)entry.getKey()).longValue();
            CallTree tree = (CallTree)entry.getValue();
            sb.append(this.getReportForThread(tid, tree));
        }
        return sb.toString();
    }

    private final void sortSamplesAndComputeDurations(Instant end) {
        Map<Long, List<Sample>> $this$forEach$iv = this.samples;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Long, List<Sample>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            List<Sample> sampleList;
            Map.Entry<Long, List<Sample>> element$iv;
            Map.Entry<Long, List<Sample>> entry = element$iv = iterator2.next();
            boolean bl = false;
            List<Sample> $this$sortBy$iv = sampleList = entry.getValue();
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Sample it = (Sample)a;
                        boolean bl = false;
                        Comparable comparable = it.getTime();
                        it = (Sample)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getTime());
                    }
                });
            }
            int n = sampleList.size() - 1;
            for (int i = 0; i < n; ++i) {
                sampleList.get(i).setDuration(sampleList.get(i + 1).getTime().toEpochMilli() - sampleList.get(i).getTime().toEpochMilli());
            }
            ((Sample)CollectionsKt.last(sampleList)).setDuration(end.toEpochMilli() - ((Sample)CollectionsKt.last(sampleList)).getTime().toEpochMilli());
        }
    }

    private final void aggregate() {
        Map<Long, List<Sample>> $this$forEach$iv = this.samples;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Long, List<Sample>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Long, List<Sample>> element$iv;
            Map.Entry<Long, List<Sample>> entry = element$iv = iterator2.next();
            boolean bl = false;
            long tid = ((Number)entry.getKey()).longValue();
            List<Sample> sampleList = entry.getValue();
            CallTree callTree = this.callTrees.get(tid);
            if (callTree == null) {
                callTree = new CallTree("");
            }
            CallTree root = callTree;
            Iterable $this$forEach$iv2 = sampleList;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Sample sample = (Sample)element$iv2;
                boolean bl2 = false;
                root.addStacktrace(sample.getStackTrace(), sample.getDuration());
            }
            root.sort();
            this.callTrees.put(tid, root);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getStacktrace(RecordedEvent $this$getStacktrace) {
        void $this$mapTo$iv$iv;
        List<RecordedFrame> list2 = $this$getStacktrace.getStackTrace().getFrames();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getFrames(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void frame;
            StringBuilder stringBuilder;
            RecordedFrame recordedFrame = (RecordedFrame)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            StringBuilder $this$getStacktrace_u24lambda_u240_u240 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$getStacktrace_u24lambda_u240_u240.append(frame.getMethod().getType().getName());
            $this$getStacktrace_u24lambda_u240_u240.append(".");
            $this$getStacktrace_u24lambda_u240_u240.append(frame.getMethod().getName());
            StringBuilder stringBuilder2 = frame.getLineNumber() == -1 ? $this$getStacktrace_u24lambda_u240_u240.append("(Unknown Source)") : $this$getStacktrace_u24lambda_u240_u240.append("(?:" + frame.getLineNumber() + ")");
            collection2.add(stringBuilder.toString());
        }
        return (List)destination$iv$iv;
    }

    private static final boolean THREAD_FILTER_ALL$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean THREAD_FILTER_EDT_ONLY$lambda$0(String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return Intrinsics.areEqual((Object)name2, (Object)EDT);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/CallTreeAggregator$Companion;", "", "<init>", "()V", "EDT", "", "THREAD_FILTER_ALL", "Lkotlin/Function1;", "", "getTHREAD_FILTER_ALL", "()Lkotlin/jvm/functions/Function1;", "THREAD_FILTER_EDT_ONLY", "getTHREAD_FILTER_EDT_ONLY", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<String, Boolean> getTHREAD_FILTER_ALL() {
            return THREAD_FILTER_ALL;
        }

        @NotNull
        public final Function1<String, Boolean> getTHREAD_FILTER_EDT_ONLY() {
            return THREAD_FILTER_EDT_ONLY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

