/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.freeze;

import com.android.tools.idea.diagnostics.DiagnosticUtils;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 -2\u00020\u0001:\u0004*+,-B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J0\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u0019H\u0002J\b\u0010!\u001a\u00020\u0019H\u0002J\b\u0010\"\u001a\u00020\u0019H\u0002J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020\u0014H\u0002J\b\u0010)\u001a\u00020\u0019H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006."}, d2={"Lcom/android/tools/idea/diagnostics/freeze/FreezeGraph;", "", "nodes", "", "Lcom/android/tools/idea/diagnostics/freeze/FreezeGraph$ThreadNode;", "awtNode", "<init>", "(Ljava/util/List;Lcom/android/tools/idea/diagnostics/freeze/FreezeGraph$ThreadNode;)V", "getNodes", "()Ljava/util/List;", "getAwtNode", "()Lcom/android/tools/idea/diagnostics/freeze/FreezeGraph$ThreadNode;", "idToNodeMap", "", "", "value", "", "awtDeadlocked", "getAwtDeadlocked", "()Z", "", "summary", "getSummary", "()Ljava/lang/String;", "addEdge", "", "blockedNode", "blockingNode", "reason", "timed", "confidence", "Lcom/android/tools/idea/diagnostics/freeze/FreezeGraph$Confidence;", "addEdgesFromLockInfo", "addEdgesFromReaderWriterLock", "addEdgesFromSemaphore", "getOuterClassName", "frame", "Ljava/lang/StackTraceElement;", "matchMethod", "it", "classAndMethod", "analyze", "Confidence", "ThreadNode", "BlockedEdge", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nFreezeGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FreezeGraph.kt\ncom/android/tools/idea/diagnostics/freeze/FreezeGraph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,230:1\n1208#2,2:231\n1236#2,4:233\n1999#2,14:274\n1790#3,6:237\n1790#3,6:243\n1790#3,6:249\n1790#3,6:255\n1790#3,6:261\n1790#3,6:267\n1#4:273\n*S KotlinDebug\n*F\n+ 1 FreezeGraph.kt\ncom/android/tools/idea/diagnostics/freeze/FreezeGraph\n*L\n25#1:231,2\n25#1:233,4\n207#1:274,14\n99#1:237,6\n120#1:243,6\n121#1:249,6\n123#1:255,6\n124#1:261,6\n156#1:267,6\n*E\n"})
public final class FreezeGraph {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ThreadNode> nodes;
    @Nullable
    private final ThreadNode awtNode;
    @NotNull
    private final Map<Long, ThreadNode> idToNodeMap;
    private boolean awtDeadlocked;
    @NotNull
    private String summary;

    /*
     * WARNING - void declaration
     */
    public FreezeGraph(@NotNull List<ThreadNode> nodes, @Nullable ThreadNode awtNode) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        this.nodes = nodes;
        this.awtNode = awtNode;
        Iterable iterable = this.nodes;
        FreezeGraph freezeGraph = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var6_7 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ThreadNode threadNode = (ThreadNode)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getThreadInfo().getThreadId(), element$iv$iv);
        }
        freezeGraph.idToNodeMap = destination$iv$iv;
        this.summary = "";
    }

    @NotNull
    public final List<ThreadNode> getNodes() {
        return this.nodes;
    }

    @Nullable
    public final ThreadNode getAwtNode() {
        return this.awtNode;
    }

    public final boolean getAwtDeadlocked() {
        return this.awtDeadlocked;
    }

    @NotNull
    public final String getSummary() {
        return this.summary;
    }

    private final void addEdge(ThreadNode blockedNode, ThreadNode blockingNode, String reason, boolean timed, Confidence confidence) {
        BlockedEdge edge = new BlockedEdge(blockedNode, blockingNode, reason, timed, confidence);
        blockedNode.getBlockedBy().add(edge);
        blockingNode.getBlocking().add(edge);
    }

    private final void addEdgesFromLockInfo() {
        for (ThreadNode node : this.nodes) {
            ThreadNode blockingNode;
            ThreadInfo info = node.getThreadInfo();
            long lockOwnerId = info.getLockOwnerId();
            if (lockOwnerId == -1L || this.idToNodeMap.get(lockOwnerId) == null) continue;
            LockInfo lockInfo = info.getLockInfo();
            String reason = lockInfo instanceof MonitorInfo ? info.getThreadState() + " on monitor " + ((MonitorInfo)lockInfo).getClassName() + "@" + ((MonitorInfo)lockInfo).getIdentityHashCode() + " owned by " + blockingNode.getThreadNameAndId() : info.getThreadState() + " on lock " + lockInfo.getClassName() + "@" + lockInfo.getIdentityHashCode() + " owned by " + blockingNode.getThreadNameAndId();
            this.addEdge(node, blockingNode, reason, info.getThreadState() == Thread.State.TIMED_WAITING, Confidence.HIGH);
        }
    }

    private final void addEdgesFromReaderWriterLock() {
        ThreadNode node3;
        int index$iv;
        ThreadNode writerNode = null;
        for (ThreadNode node2 : this.nodes) {
            int match;
            int n;
            block15: {
                ThreadInfo threadInfo = node2.getThreadInfo();
                Thread.State threadState = threadInfo.getThreadState();
                if (threadState != Thread.State.WAITING && threadState != Thread.State.TIMED_WAITING) continue;
                StackTraceElement[] stackTrace = threadInfo.getStackTrace();
                Intrinsics.checkNotNull((Object)stackTrace);
                StackTraceElement[] $this$indexOfLast$iv = stackTrace;
                boolean $i$f$indexOfLast = false;
                int n2 = $this$indexOfLast$iv.length + -1;
                if (0 <= n2) {
                    do {
                        index$iv = n2--;
                        StackTraceElement it = $this$indexOfLast$iv[index$iv];
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!this.matchMethod(it, "com.intellij.openapi.application.impl.AnyThreadWriteThreadingSupport.runWriteAction")) continue;
                        n = index$iv;
                        break block15;
                    } while (0 <= n2);
                }
                n = -1;
            }
            if ((match = n) == -1) continue;
            writerNode = node2;
            break;
        }
        if (writerNode == null) {
            return;
        }
        ArrayList<ThreadNode> readersBlockingWriter = new ArrayList<ThreadNode>();
        ArrayList<ThreadNode> readersBlockedByWriter = new ArrayList<ThreadNode>();
        for (ThreadNode node3 : this.nodes) {
            int n;
            int $this$indexOfLast$iv22;
            int matchReader;
            ThreadInfo threadInfo;
            block19: {
                int n3;
                StackTraceElement[] stackTrace;
                block18: {
                    int n4;
                    int index$iv22;
                    boolean $i$f$indexOfLast;
                    int $this$indexOfLast$iv3;
                    block17: {
                        int n5;
                        block16: {
                            if (Intrinsics.areEqual((Object)node3, writerNode)) continue;
                            threadInfo = node3.getThreadInfo();
                            stackTrace = threadInfo.getStackTrace();
                            Intrinsics.checkNotNull((Object)stackTrace);
                            StackTraceElement[] $this$indexOfLast$iv3 = stackTrace;
                            boolean $i$f$indexOfLast2 = false;
                            index$iv = $this$indexOfLast$iv3.length + -1;
                            if (0 <= index$iv) {
                                do {
                                    int index$iv22 = index$iv--;
                                    StackTraceElement it = $this$indexOfLast$iv3[index$iv22];
                                    boolean bl = false;
                                    Intrinsics.checkNotNull((Object)it);
                                    if (!this.matchMethod(it, "com.intellij.openapi.application.impl.ApplicationImpl.runReadAction")) continue;
                                    n5 = index$iv22;
                                    break block16;
                                } while (0 <= index$iv);
                            }
                            n5 = -1;
                        }
                        $this$indexOfLast$iv3 = n5;
                        StackTraceElement[] $this$indexOfLast$iv4 = stackTrace;
                        $i$f$indexOfLast = false;
                        index$iv22 = $this$indexOfLast$iv4.length + -1;
                        if (0 <= index$iv22) {
                            do {
                                int index$iv3 = index$iv22--;
                                StackTraceElement it = $this$indexOfLast$iv4[index$iv3];
                                boolean bl = false;
                                Intrinsics.checkNotNull((Object)it);
                                if (!this.matchMethod(it, "com.intellij.openapi.application.impl.ApplicationImpl.tryRunReadAction")) continue;
                                n4 = index$iv3;
                                break block17;
                            } while (0 <= index$iv22);
                        }
                        n4 = -1;
                    }
                    int $this$indexOfLast$iv4 = n4;
                    matchReader = Math.max($this$indexOfLast$iv3, $this$indexOfLast$iv4);
                    StackTraceElement[] $this$indexOfLast$iv22 = stackTrace;
                    $i$f$indexOfLast = false;
                    index$iv22 = $this$indexOfLast$iv22.length + -1;
                    if (0 <= index$iv22) {
                        do {
                            int index$iv4 = index$iv22--;
                            StackTraceElement it = $this$indexOfLast$iv22[index$iv4];
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)it);
                            if (!this.matchMethod(it, "com.intellij.openapi.application.impl.ReadMostlyRWLock.startRead")) continue;
                            n3 = index$iv4;
                            break block18;
                        } while (0 <= index$iv22);
                    }
                    n3 = -1;
                }
                $this$indexOfLast$iv22 = n3;
                StackTraceElement[] $this$indexOfLast$iv = stackTrace;
                boolean $i$f$indexOfLast = false;
                int n6 = $this$indexOfLast$iv.length + -1;
                if (0 <= n6) {
                    do {
                        int index$iv5 = n6--;
                        StackTraceElement it = $this$indexOfLast$iv[index$iv5];
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!this.matchMethod(it, "com.intellij.openapi.application.impl.AnyThreadWriteThreadingSupport.getReadPermit")) continue;
                        n = index$iv5;
                        break block19;
                    } while (0 <= n6);
                }
                n = -1;
            }
            int n7 = n;
            int matchWaitingForWriter = Math.max($this$indexOfLast$iv22, n7);
            if (matchReader == -1) continue;
            Thread.State threadState = threadInfo.getThreadState();
            boolean bl = matchWaitingForWriter != -1 && (threadState == Thread.State.WAITING || threadState == Thread.State.TIMED_WAITING) ? readersBlockedByWriter.add(node3) : readersBlockingWriter.add(node3);
        }
        Iterator iterator2 = readersBlockedByWriter.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<ThreadNode> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
            this.addEdge(node3, writerNode, "Reader " + node3.getThreadInfo().getThreadState() + " for writer " + writerNode.getThreadNameAndId(), false, Confidence.HIGH);
        }
        Iterator iterator4 = readersBlockingWriter.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
        iterator3 = iterator4;
        while (iterator3.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
            this.addEdge(writerNode, node3, "Writer " + writerNode.getThreadInfo().getThreadState() + " for reader " + node3.getThreadNameAndId(), false, Confidence.HIGH);
        }
    }

    private final void addEdgesFromSemaphore() {
        for (ThreadNode node : this.nodes) {
            int match1;
            int n;
            StackTraceElement[] stackTrace;
            ThreadInfo threadInfo;
            block6: {
                threadInfo = node.getThreadInfo();
                Thread.State threadState = threadInfo.getThreadState();
                if (threadState != Thread.State.WAITING && threadState != Thread.State.TIMED_WAITING) continue;
                stackTrace = threadInfo.getStackTrace();
                Intrinsics.checkNotNull((Object)stackTrace);
                StackTraceElement[] $this$indexOfLast$iv = stackTrace;
                boolean $i$f$indexOfLast = false;
                int n2 = $this$indexOfLast$iv.length + -1;
                if (0 <= n2) {
                    do {
                        int index$iv = n2--;
                        StackTraceElement it = $this$indexOfLast$iv[index$iv];
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!this.matchMethod(it, "java.util.concurrent.Semaphore.acquire")) continue;
                        n = index$iv;
                        break block6;
                    } while (0 <= n2);
                }
                n = -1;
            }
            if ((match1 = n) == -1 || match1 == stackTrace.length - 1) continue;
            StackTraceElement previousFrame = stackTrace[match1 + 1];
            Intrinsics.checkNotNull((Object)previousFrame);
            String className = this.getOuterClassName(previousFrame);
            ThreadNode foundThread = null;
            for (ThreadNode node2 : this.nodes) {
                StackTraceElement stackTraceElement;
                ThreadInfo threadInfo2;
                block7: {
                    if (Intrinsics.areEqual((Object)node, (Object)node2)) continue;
                    threadInfo2 = node2.getThreadInfo();
                    StackTraceElement[] stackTrace2 = threadInfo2.getStackTrace();
                    Intrinsics.checkNotNull((Object)stackTrace2);
                    StackTraceElement[] stackTraceElementArray = stackTrace2;
                    int n3 = stackTraceElementArray.length;
                    for (int i = 0; i < n3; ++i) {
                        StackTraceElement stackTraceElement2;
                        StackTraceElement it = stackTraceElement2 = stackTraceElementArray[i];
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!Intrinsics.areEqual((Object)this.getOuterClassName(it), (Object)className)) continue;
                        stackTraceElement = stackTraceElement2;
                        break block7;
                    }
                    stackTraceElement = null;
                }
                if (stackTraceElement == null) continue;
                StackTraceElement match2 = stackTraceElement;
                if (DiagnosticUtils.Companion.isAwtThread(threadInfo2)) {
                    if (foundThread != null) continue;
                    foundThread = node2;
                    continue;
                }
                foundThread = node2;
                break;
            }
            if (foundThread == null) continue;
            boolean bl = false;
            this.addEdge(node, foundThread, node.getThreadInfo().getThreadState() + " for semaphore release (" + className + "), possibly by " + foundThread.getThreadNameAndId(), threadInfo.getThreadState() == Thread.State.TIMED_WAITING, Confidence.LOW);
        }
    }

    private final String getOuterClassName(StackTraceElement frame) {
        String string = frame.getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
        return StringsKt.substringBefore$default((String)string, (char)'$', null, (int)2, null);
    }

    private final boolean matchMethod(StackTraceElement it, String classAndMethod) {
        return Intrinsics.areEqual((Object)(it.getClassName() + "." + it.getMethodName()), (Object)classAndMethod);
    }

    private final void analyze() {
        StringBuilder sb = new StringBuilder();
        this.awtDeadlocked = false;
        sb.append("THREAD LOCK INFO SECTION:").append('\n');
        ThreadNode awtNodeLocal = this.awtNode;
        if (awtNodeLocal == null) {
            sb.append("No AWT thread.").append('\n');
            return;
        }
        sb.append("Lock path for AWT thread " + awtNodeLocal.getThreadNameAndId() + ":").append('\n');
        ThreadNode currentNode = awtNodeLocal;
        Set visitedNodes = new LinkedHashSet();
        boolean hasTimeout = false;
        while (currentNode != null) {
            Object v0;
            visitedNodes.add(currentNode);
            Iterable $this$maxByOrNull$iv = currentNode.getBlockedBy();
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    BlockedEdge it = (BlockedEdge)maxElem$iv;
                    boolean bl = false;
                    Comparable maxValue$iv = (Comparable)((Object)it.getConfidence());
                    do {
                        Object e$iv = iterator$iv.next();
                        BlockedEdge it2 = (BlockedEdge)e$iv;
                        $i$a$-maxByOrNull-FreezeGraph$analyze$edge$1 = false;
                        Comparable v$iv = (Comparable)((Object)it2.getConfidence());
                        if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            BlockedEdge edge = v0;
            if (edge != null) {
                hasTimeout |= edge.getTimed();
                sb.append(" * " + currentNode.getThreadNameAndId() + " " + edge.getReason() + " (Confidence: " + edge.getConfidence() + ")").append('\n');
                ThreadNode nextNode = edge.getBlockingNode();
                if (visitedNodes.contains(nextNode)) {
                    String deadlockString = hasTimeout ? "TIMED DEADLOCK" : "DEADLOCK";
                    sb.append(" * " + deadlockString + " while waiting for " + nextNode.getThreadNameAndId()).append('\n');
                    this.awtDeadlocked = true;
                    break;
                }
                currentNode = nextNode;
                continue;
            }
            StackTraceElement[] stackTrace = currentNode.getThreadInfo().getStackTrace();
            Intrinsics.checkNotNull((Object)stackTrace);
            if (!(!(stackTrace.length == 0))) break;
            sb.append("  " + currentNode.getThreadNameAndId() + " - " + currentNode.getThreadInfo().getThreadState() + " at " + stackTrace[0]).append('\n');
            break;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.summary = string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\nH\u00c6\u0003J;\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/diagnostics/freeze/FreezeGraph$BlockedEdge;", "", "blockedNode", "Lcom/android/tools/idea/diagnostics/freeze/FreezeGraph$ThreadNode;", "blockingNode", "reason", "", "timed", "", "confidence", "Lcom/android/tools/idea/diagnostics/freeze/FreezeGraph$Confidence;", "<init>", "(Lcom/android/tools/idea/diagnostics/freeze/FreezeGraph$ThreadNode;Lcom/android/tools/idea/diagnostics/freeze/FreezeGraph$ThreadNode;Ljava/lang/String;ZLcom/android/tools/idea/diagnostics/freeze/FreezeGraph$Confidence;)V", "getBlockedNode", "()Lcom/android/tools/idea/diagnostics/freeze/FreezeGraph$ThreadNode;", "getBlockingNode", "getReason", "()Ljava/lang/String;", "getTimed", "()Z", "getConfidence", "()Lcom/android/tools/idea/diagnostics/freeze/FreezeGraph$Confidence;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "intellij.android.core"})
    public static final class BlockedEdge {
        @NotNull
        private final ThreadNode blockedNode;
        @NotNull
        private final ThreadNode blockingNode;
        @NotNull
        private final String reason;
        private final boolean timed;
        @NotNull
        private final Confidence confidence;

        public BlockedEdge(@NotNull ThreadNode blockedNode, @NotNull ThreadNode blockingNode, @NotNull String reason, boolean timed, @NotNull Confidence confidence) {
            Intrinsics.checkNotNullParameter((Object)blockedNode, (String)"blockedNode");
            Intrinsics.checkNotNullParameter((Object)blockingNode, (String)"blockingNode");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)((Object)confidence), (String)"confidence");
            this.blockedNode = blockedNode;
            this.blockingNode = blockingNode;
            this.reason = reason;
            this.timed = timed;
            this.confidence = confidence;
        }

        @NotNull
        public final ThreadNode getBlockedNode() {
            return this.blockedNode;
        }

        @NotNull
        public final ThreadNode getBlockingNode() {
            return this.blockingNode;
        }

        @NotNull
        public final String getReason() {
            return this.reason;
        }

        public final boolean getTimed() {
            return this.timed;
        }

        @NotNull
        public final Confidence getConfidence() {
            return this.confidence;
        }

        @NotNull
        public final ThreadNode component1() {
            return this.blockedNode;
        }

        @NotNull
        public final ThreadNode component2() {
            return this.blockingNode;
        }

        @NotNull
        public final String component3() {
            return this.reason;
        }

        public final boolean component4() {
            return this.timed;
        }

        @NotNull
        public final Confidence component5() {
            return this.confidence;
        }

        @NotNull
        public final BlockedEdge copy(@NotNull ThreadNode blockedNode, @NotNull ThreadNode blockingNode, @NotNull String reason, boolean timed, @NotNull Confidence confidence) {
            Intrinsics.checkNotNullParameter((Object)blockedNode, (String)"blockedNode");
            Intrinsics.checkNotNullParameter((Object)blockingNode, (String)"blockingNode");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)((Object)confidence), (String)"confidence");
            return new BlockedEdge(blockedNode, blockingNode, reason, timed, confidence);
        }

        public static /* synthetic */ BlockedEdge copy$default(BlockedEdge blockedEdge, ThreadNode threadNode, ThreadNode threadNode2, String string, boolean bl, Confidence confidence, int n, Object object) {
            if ((n & 1) != 0) {
                threadNode = blockedEdge.blockedNode;
            }
            if ((n & 2) != 0) {
                threadNode2 = blockedEdge.blockingNode;
            }
            if ((n & 4) != 0) {
                string = blockedEdge.reason;
            }
            if ((n & 8) != 0) {
                bl = blockedEdge.timed;
            }
            if ((n & 0x10) != 0) {
                confidence = blockedEdge.confidence;
            }
            return blockedEdge.copy(threadNode, threadNode2, string, bl, confidence);
        }

        @NotNull
        public String toString() {
            return "BlockedEdge(blockedNode=" + this.blockedNode + ", blockingNode=" + this.blockingNode + ", reason=" + this.reason + ", timed=" + this.timed + ", confidence=" + this.confidence + ")";
        }

        public int hashCode() {
            int result2 = this.blockedNode.hashCode();
            result2 = result2 * 31 + this.blockingNode.hashCode();
            result2 = result2 * 31 + this.reason.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.timed);
            result2 = result2 * 31 + this.confidence.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BlockedEdge)) {
                return false;
            }
            BlockedEdge blockedEdge = (BlockedEdge)other;
            if (!Intrinsics.areEqual((Object)this.blockedNode, (Object)blockedEdge.blockedNode)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.blockingNode, (Object)blockedEdge.blockingNode)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.reason, (Object)blockedEdge.reason)) {
                return false;
            }
            if (this.timed != blockedEdge.timed) {
                return false;
            }
            return this.confidence == blockedEdge.confidence;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/diagnostics/freeze/FreezeGraph$Companion;", "", "<init>", "()V", "analyzeThreads", "Lcom/android/tools/idea/diagnostics/freeze/FreezeGraph;", "threads", "", "Ljava/lang/management/ThreadInfo;", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nFreezeGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FreezeGraph.kt\ncom/android/tools/idea/diagnostics/freeze/FreezeGraph$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n1563#2:231\n1634#2,3:232\n295#2,2:235\n*S KotlinDebug\n*F\n+ 1 FreezeGraph.kt\ncom/android/tools/idea/diagnostics/freeze/FreezeGraph$Companion\n*L\n61#1:231\n61#1:232,3\n62#1:235,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final FreezeGraph analyzeThreads(@NotNull List<? extends ThreadInfo> threads) {
            Object v0;
            List list2;
            block2: {
                void $this$firstOrNull$iv;
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(threads, (String)"threads");
                Iterable $this$map$iv = threads;
                boolean $i$f$map22 = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ThreadInfo threadInfo = (ThreadInfo)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(new ThreadNode((ThreadInfo)it));
                }
                List threadNodes = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                Iterable $i$f$map22 = threadNodes;
                list2 = threadNodes;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ThreadNode it = (ThreadNode)element$iv;
                    boolean bl = false;
                    if (!DiagnosticUtils.Companion.isAwtThread(it.getThreadInfo())) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            ThreadNode threadNode = v0;
            List list3 = list2;
            FreezeGraph graph = new FreezeGraph(list3, threadNode);
            graph.addEdgesFromLockInfo();
            graph.addEdgesFromReaderWriterLock();
            graph.addEdgesFromSemaphore();
            graph.analyze();
            return graph;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/diagnostics/freeze/FreezeGraph$Confidence;", "", "<init>", "(Ljava/lang/String;I)V", "LOW", "HIGH", "intellij.android.core"})
    public static final class Confidence
    extends Enum<Confidence> {
        public static final /* enum */ Confidence LOW = new Confidence();
        public static final /* enum */ Confidence HIGH = new Confidence();
        private static final /* synthetic */ Confidence[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Confidence[] values() {
            return (Confidence[])$VALUES.clone();
        }

        public static Confidence valueOf(String value2) {
            return Enum.valueOf(Confidence.class, value2);
        }

        @NotNull
        public static EnumEntries<Confidence> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = confidenceArray = new Confidence[]{Confidence.LOW, Confidence.HIGH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000f\u001a\u00020\u0010J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/diagnostics/freeze/FreezeGraph$ThreadNode;", "", "threadInfo", "Ljava/lang/management/ThreadInfo;", "<init>", "(Ljava/lang/management/ThreadInfo;)V", "getThreadInfo", "()Ljava/lang/management/ThreadInfo;", "blockedBy", "", "Lcom/android/tools/idea/diagnostics/freeze/FreezeGraph$BlockedEdge;", "getBlockedBy", "()Ljava/util/List;", "blocking", "getBlocking", "getThreadNameAndId", "", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.core"})
    public static final class ThreadNode {
        @NotNull
        private final ThreadInfo threadInfo;
        @NotNull
        private final List<BlockedEdge> blockedBy;
        @NotNull
        private final List<BlockedEdge> blocking;

        public ThreadNode(@NotNull ThreadInfo threadInfo) {
            Intrinsics.checkNotNullParameter((Object)threadInfo, (String)"threadInfo");
            this.threadInfo = threadInfo;
            this.blockedBy = new ArrayList();
            this.blocking = new ArrayList();
        }

        @NotNull
        public final ThreadInfo getThreadInfo() {
            return this.threadInfo;
        }

        @NotNull
        public final List<BlockedEdge> getBlockedBy() {
            return this.blockedBy;
        }

        @NotNull
        public final List<BlockedEdge> getBlocking() {
            return this.blocking;
        }

        @NotNull
        public final String getThreadNameAndId() {
            return "[\"" + this.threadInfo.getThreadName() + "\" Id=" + this.threadInfo.getThreadId() + "]";
        }

        @NotNull
        public final ThreadInfo component1() {
            return this.threadInfo;
        }

        @NotNull
        public final ThreadNode copy(@NotNull ThreadInfo threadInfo) {
            Intrinsics.checkNotNullParameter((Object)threadInfo, (String)"threadInfo");
            return new ThreadNode(threadInfo);
        }

        public static /* synthetic */ ThreadNode copy$default(ThreadNode threadNode, ThreadInfo threadInfo, int n, Object object) {
            if ((n & 1) != 0) {
                threadInfo = threadNode.threadInfo;
            }
            return threadNode.copy(threadInfo);
        }

        @NotNull
        public String toString() {
            return "ThreadNode(threadInfo=" + this.threadInfo + ")";
        }

        public int hashCode() {
            return this.threadInfo.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ThreadNode)) {
                return false;
            }
            ThreadNode threadNode = (ThreadNode)other;
            return Intrinsics.areEqual((Object)this.threadInfo, (Object)threadNode.threadInfo);
        }
    }
}

