/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.crash;

import com.android.tools.idea.diagnostics.crash.BaseStudioReport;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import java.nio.charset.Charset;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.jetbrains.annotations.NotNull;

public class StudioPsiInvalidationTraceReport
extends BaseStudioReport {
    private final String invalidationReason;
    private final Throwable currentStack;
    private final String threadDump;

    public StudioPsiInvalidationTraceReport(@NotNull PsiFile psiFile, @NotNull String threadDump) {
        super(null, null, "PsiInvalidationTrace");
        this.invalidationReason = StudioPsiInvalidationTraceReport.getInvalidationReason(psiFile);
        this.currentStack = new Throwable();
        this.threadDump = threadDump;
    }

    @Override
    protected void serializeTo(@NotNull MultipartEntityBuilder builder) {
        super.serializeTo(builder);
        builder.addTextBody("exception_info", Throwables.getStackTraceAsString((Throwable)this.currentStack));
        builder.addTextBody("invalidationReason", this.invalidationReason, ContentType.create((String)"text/plain", (Charset)Charsets.UTF_8));
        builder.addTextBody("threadDump", this.threadDump, ContentType.create((String)"text/plain", (Charset)Charsets.UTF_8));
    }

    private static String getInvalidationReason(PsiFile psiFile) {
        StringBuilder sb = new StringBuilder();
        sb.append(PsiInvalidElementAccessException.getInvalidationTrace((UserDataHolder)psiFile));
        sb.append("\n");
        FileViewProvider provider = psiFile.getViewProvider();
        VirtualFile vFile = provider.getVirtualFile();
        if (!vFile.isValid()) {
            sb.append("Virtual file is invalid. ");
        }
        sb.append("\n");
        return sb.toString();
    }
}

