/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.idea.diagnostics.DiagnosticReportConfiguration;
import com.android.tools.idea.diagnostics.DiagnosticReportContributor;
import com.android.tools.idea.diagnostics.TruncatingStringBuilder;
import com.android.tools.idea.diagnostics.freeze.ThreadCallTreeSorter;
import com.android.tools.idea.diagnostics.util.FrameInfo;
import com.android.tools.idea.diagnostics.util.ThreadCallTree;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.intellij.openapi.diagnostic.Logger;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadSamplingReportContributor
implements DiagnosticReportContributor {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.diagnostics.ThreadSamplingReportContributor");
    private static final int MAX_REPORT_LENGTH_BYTES = 200000;
    public static final int DEBUGDATA_MAX_LIST_ENTRIES = 1000;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("ThreadSamplingReportContributor-%d").build());
    private final ThreadMXBean myThreadMXBean = ManagementFactory.getThreadMXBean();
    private final Object LOCK = new Object();
    private final Object DEBUGDATA_LOCK = new Object();
    private final List<ThreadInfo[]> mySampledStacks = new ArrayList<ThreadInfo[]>();
    private ScheduledFuture<?> myFutureSampling;
    private ScheduledFuture<?> myFutureFinishSampling;
    private String myAwtStack = "";
    private String myReport = "";
    private String debugReport = "";
    private DiagnosticReportConfiguration myConfiguration;
    private long collectionStartTimeNs;
    private long collectionStopTimeNs;
    private final IntList samplingOffsetsMs = new IntArrayList();
    private final IntList samplingTimeMs = new IntArrayList();
    private long timeElapsedBeforeCollectionStartedMs = 0L;

    @Override
    public void setup(DiagnosticReportConfiguration configuration2) {
        this.myConfiguration = configuration2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startCollection(long timeElapsedSoFarMs) {
        this.timeElapsedBeforeCollectionStartedMs = timeElapsedSoFarMs;
        this.collectionStartTimeNs = System.nanoTime();
        DiagnosticReportConfiguration configuration2 = this.myConfiguration;
        Object object = this.LOCK;
        synchronized (object) {
            this.myFutureSampling = this.scheduler.scheduleWithFixedDelay(this::sampleThreads, 0L, configuration2.getIntervalMs(), TimeUnit.MILLISECONDS);
            long samplingTimeMs = configuration2.getMaxSamplingTimeMs();
            if (samplingTimeMs > 0L) {
                this.myFutureFinishSampling = this.scheduler.schedule(this::stop, samplingTimeMs, TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public void stopCollection(long totalDurationMs) {
        this.collectionStopTimeNs = System.nanoTime();
        this.stop();
        this.prepareReport(totalDurationMs);
    }

    @Override
    public String getReport() {
        return this.myReport;
    }

    @Override
    public void generateReport(BiConsumer<String, String> saveReportCallback) {
        saveReportCallback.accept("hotPathStackTrace", this.getAWTStack());
        saveReportCallback.accept("profileDiagnostics", this.getReport());
        if (!this.debugReport.isEmpty()) {
            saveReportCallback.accept("freezeReportDebugInfo", this.debugReport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myFutureFinishSampling != null) {
                this.myFutureFinishSampling.cancel(false);
                this.myFutureFinishSampling = null;
            }
            if (this.myFutureSampling != null) {
                this.myFutureSampling.cancel(false);
                this.myFutureSampling = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sampleThreads() {
        long sampleThreadsStart = System.nanoTime();
        try {
            ThreadInfo[] allThreads = this.myThreadMXBean.dumpAllThreads(false, false);
            List<ThreadInfo[]> list2 = this.mySampledStacks;
            synchronized (list2) {
                this.mySampledStacks.add(allThreads);
            }
        }
        catch (Exception allThreads) {
            // empty catch block
        }
        long sampleThreadsEnd = System.nanoTime();
        Object object = this.DEBUGDATA_LOCK;
        synchronized (object) {
            this.samplingOffsetsMs.add((int)TimeUnit.NANOSECONDS.toMillis(sampleThreadsStart - this.collectionStartTimeNs));
            this.samplingTimeMs.add((int)TimeUnit.NANOSECONDS.toMillis(sampleThreadsEnd - sampleThreadsStart));
        }
    }

    public String getAWTStack() {
        return this.myAwtStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareReport(long totalFreezeDurationMs) {
        long timeInAwtThreadMs;
        long sampleCount;
        TruncatingStringBuilder sb = new TruncatingStringBuilder(200000, "\n...report truncated...");
        HashMap<Long, ThreadCallTree> threadMap = new HashMap<Long, ThreadCallTree>();
        long intervalMs = this.myConfiguration.getIntervalMs();
        List<ThreadInfo[]> list2 = this.mySampledStacks;
        synchronized (list2) {
            sampleCount = this.mySampledStacks.size();
            LOG.info("Collected " + sampleCount + " samples");
            for (ThreadInfo[] threadInfoArray : this.mySampledStacks) {
                for (ThreadInfo ti : threadInfoArray) {
                    ThreadCallTree callTree = (ThreadCallTree)threadMap.get(ti.getThreadId());
                    if (callTree == null) {
                        callTree = new ThreadCallTree(ti.getThreadId(), ti.getThreadName());
                        threadMap.put(ti.getThreadId(), callTree);
                    }
                    callTree.addThreadInfo(ti, intervalMs);
                }
            }
        }
        ThreadCallTree awtThread = ThreadSamplingReportContributor.getAwtThread(threadMap.values());
        this.myAwtStack = this.createHotPathStackTrace(awtThread, totalFreezeDurationMs);
        List<ThreadCallTree> sortedCallTrees = new ThreadCallTreeSorter(threadMap.values()).sort();
        for (ThreadCallTree callTree : sortedCallTrees) {
            sb.append(callTree.getReportString(this.myConfiguration.getFrameTimeIgnoreThresholdMs()));
            sb.append("\n");
        }
        this.myReport = sb.toString();
        long l = totalFreezeDurationMs - this.timeElapsedBeforeCollectionStartedMs;
        long l2 = timeInAwtThreadMs = awtThread != null ? awtThread.getRootFrame().getTimeSpent() : 0L;
        if (l >= 5000L && timeInAwtThreadMs < l / 2L) {
            StringBuilder debugSb = new StringBuilder();
            debugSb.append("timeElapsedBeforeCollectionStartedMs=" + this.timeElapsedBeforeCollectionStartedMs + "\n");
            debugSb.append("collectionTimeMs=" + TimeUnit.NANOSECONDS.toMillis(this.collectionStopTimeNs - this.collectionStartTimeNs) + "\n");
            Object object = this.DEBUGDATA_LOCK;
            synchronized (object) {
                debugSb.append("sampleCount=" + sampleCount + "\n");
                debugSb.append("samplingOffsetsMs=" + String.valueOf(ThreadSamplingReportContributor.limitList(this.samplingOffsetsMs, 1000)) + "\n");
                debugSb.append("samplingTimeMs=" + String.valueOf(ThreadSamplingReportContributor.limitList(this.samplingTimeMs, 1000)) + "\n");
            }
            this.debugReport = debugSb.toString();
        }
    }

    @NotNull
    private static IntList limitList(@NotNull IntList list2, int limit) {
        if (list2.size() < limit) {
            return list2;
        }
        return list2.subList(0, limit);
    }

    @NotNull
    private String createHotPathStackTrace(@Nullable ThreadCallTree thread, long totalFreezeDurationMs) {
        FrameInfo frame;
        StringBuilder sb = new StringBuilder();
        String threadName = thread != null ? thread.getThreadName() : "MissingAWTThread";
        sb.append("\"").append(threadName).append("\" tid=0x0 runnable\n").append("     java.lang.Thread.State: RUNNABLE\n").append("     Frozen for ").append(TimeUnit.MILLISECONDS.toSeconds(totalFreezeDurationMs)).append("secs\n");
        FrameInfo frameInfo = frame = thread != null ? thread.getRootFrame() : null;
        if (frame == null) {
            sb.append("\tat ").append(ThreadSamplingReportContributor.class.getName()).append(".missingEdtStack(Unknown source)\n");
        }
        ArrayList<FrameInfo> frames = new ArrayList<FrameInfo>();
        while (frame != null) {
            if (frame.getStackTraceElement() != null) {
                frames.add(frame);
            }
            if ((frame = frame.getHottestSubframe()) == null || frame.getTimeSpent() >= this.myConfiguration.getFrameTimeIgnoreThresholdMs()) continue;
        }
        Collections.reverse(frames);
        for (FrameInfo f : frames) {
            sb.append("\tat ");
            f.appendStackTraceForCurrentFrame(sb);
            sb.append('\n');
        }
        return sb.toString();
    }

    @Nullable
    private static ThreadCallTree getAwtThread(@NotNull Collection<ThreadCallTree> threadMap) {
        return threadMap.stream().filter(ThreadCallTree::isAwtThread).findFirst().orElse(null);
    }
}

