/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\b\u0010\u0010\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/diagnostics/SanitizedBuilder;", "", "<init>", "()V", "LINUX_MULTIPLE_FILE_PATHS", "", "WINDOWS_MULTIPLE_FILE_PATHS", "LINUX_FILE_PATH_TO_EOL", "WINDOWS_FILE_PATH_TO_EOL", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sanitizeUntilEOL", "", "line", "sanitizeMultiplePaths", "toString", "intellij.android.core"})
public final class SanitizedBuilder {
    @NotNull
    private final String LINUX_MULTIPLE_FILE_PATHS;
    @NotNull
    private final String WINDOWS_MULTIPLE_FILE_PATHS;
    @NotNull
    private final String LINUX_FILE_PATH_TO_EOL;
    @NotNull
    private final String WINDOWS_FILE_PATH_TO_EOL;
    @NotNull
    private final StringBuilder builder = new StringBuilder();

    public SanitizedBuilder() {
        this.LINUX_MULTIPLE_FILE_PATHS = "(?<=^|[\\s:=])(/.*?)(?=\\s[\\s-]|\"|'|\\)|:|$)";
        this.WINDOWS_MULTIPLE_FILE_PATHS = "([a-zA-Z]:[\\\\/].*?)(?=\\s[\\s-]|[<>:\"|?*]|;|$)";
        this.LINUX_FILE_PATH_TO_EOL = "(?<=^|[\\s:=\"])(/.*)";
        this.WINDOWS_FILE_PATH_TO_EOL = "([a-zA-Z]:[\\\\/].*)";
    }

    public final void sanitizeUntilEOL(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (((CharSequence)line).length() == 0) {
            this.builder.append(line + "\n");
            return;
        }
        CharSequence charSequence = line;
        Regex regex = new Regex(this.LINUX_FILE_PATH_TO_EOL + "|" + this.WINDOWS_FILE_PATH_TO_EOL);
        String string = "<elided>";
        this.builder.append(regex.replace(charSequence, string) + "\n");
    }

    public final void sanitizeMultiplePaths(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String line2 = line;
        if (((CharSequence)line2).length() == 0) {
            this.builder.append(line2 + "\n");
            return;
        }
        CharSequence charSequence = line2;
        Regex regex = new Regex(this.LINUX_MULTIPLE_FILE_PATHS);
        String string = "<elided>";
        line2 = regex.replace(charSequence, string);
        charSequence = line2;
        regex = new Regex(this.WINDOWS_MULTIPLE_FILE_PATHS);
        string = "<elided>";
        this.builder.append(regex.replace(charSequence, string) + "\n");
    }

    @NotNull
    public String toString() {
        String string = this.builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

