/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.idea.diagnostics.DiagnosticReportConfiguration;
import com.android.tools.idea.diagnostics.DiagnosticReportContributor;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\fH\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016J\u001c\u0010\u0018\u001a\u00020\u00102\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001aH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/diagnostics/CPUUseReportContributor;", "Lcom/android/tools/idea/diagnostics/DiagnosticReportContributor;", "<init>", "()V", "report", "", "enabled", "", "threadIds", "", "initialCpuTimePerThreadId", "initialUptimeMs", "", "previousCpuTimeEnabledState", "Ljava/lang/Boolean;", "setup", "", "configuration", "Lcom/android/tools/idea/diagnostics/DiagnosticReportConfiguration;", "startCollection", "timeElapsedSoFarMs", "stopCollection", "totalDurationMs", "getReport", "generateReport", "saveReportCallback", "Ljava/util/function/BiConsumer;", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nCPUUseReportContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CPUUseReportContributor.kt\ncom/android/tools/idea/diagnostics/CPUUseReportContributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1068#2:128\n1068#2:129\n*S KotlinDebug\n*F\n+ 1 CPUUseReportContributor.kt\ncom/android/tools/idea/diagnostics/CPUUseReportContributor\n*L\n83#1:128\n84#1:129\n*E\n"})
public final class CPUUseReportContributor
implements DiagnosticReportContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String report = "Disabled";
    private boolean enabled;
    private long[] threadIds;
    private long[] initialCpuTimePerThreadId;
    private long initialUptimeMs;
    @Nullable
    private Boolean previousCpuTimeEnabledState;
    private static final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    private static final RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
    private static final OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();

    @Override
    public void setup(@NotNull DiagnosticReportConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
    }

    @Override
    public void startCollection(long timeElapsedSoFarMs) {
        if (!threadBean.isThreadCpuTimeSupported()) {
            return;
        }
        try {
            this.previousCpuTimeEnabledState = threadBean.isThreadCpuTimeEnabled();
            threadBean.setThreadCpuTimeEnabled(true);
            Set<Thread> allThreads = Thread.getAllStackTraces().keySet();
            long[] lArray = allThreads.stream().mapToLong(arg_0 -> CPUUseReportContributor.startCollection$lambda$1(CPUUseReportContributor::startCollection$lambda$0, arg_0)).sorted().toArray();
            Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"toArray(...)");
            this.threadIds = lArray;
            this.initialUptimeMs = runtimeBean.getUptime();
            long[] lArray2 = this.threadIds;
            if (this.threadIds == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"threadIds");
                lArray2 = null;
            }
            this.initialCpuTimePerThreadId = CPUUseReportContributor.Companion.getCpuTimeForThreadIds(lArray2);
            this.enabled = true;
        }
        catch (Throwable t) {
            this.report = "ERROR: " + t;
            this.enabled = false;
        }
    }

    @Override
    public void stopCollection(long totalDurationMs) {
        Iterable $this$sortedByDescending$iv;
        Boolean bl = this.previousCpuTimeEnabledState;
        if (bl != null) {
            boolean it = bl;
            boolean bl2 = false;
            threadBean.setThreadCpuTimeEnabled(it);
        }
        if (!this.enabled) {
            return;
        }
        long durationMs = runtimeBean.getUptime() - this.initialUptimeMs;
        if (durationMs <= 0L) {
            this.report = "ERROR: Duration = " + durationMs + "ms";
            return;
        }
        int cpuCount = osBean.getAvailableProcessors();
        long[] lArray = this.threadIds;
        if (this.threadIds == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"threadIds");
            lArray = null;
        }
        long[] currentCpuTimePerThreadId = CPUUseReportContributor.Companion.getCpuTimeForThreadIds(lArray);
        long[] lArray2 = this.threadIds;
        if (this.threadIds == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"threadIds");
            lArray2 = null;
        }
        double[] cpuUsagePerThreadId = new double[lArray2.length];
        int i = 0;
        long[] lArray3 = this.threadIds;
        if (this.threadIds == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"threadIds");
            lArray3 = null;
        }
        int n = lArray3.length;
        while (i < n) {
            long[] lArray4 = this.initialCpuTimePerThreadId;
            if (this.initialCpuTimePerThreadId == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"initialCpuTimePerThreadId");
                lArray4 = null;
            }
            if (lArray4[i] == -1L || currentCpuTimePerThreadId[i] == -1L) {
                cpuUsagePerThreadId[i] = -1.0;
            } else {
                double threadCpuUse;
                long l = currentCpuTimePerThreadId[i];
                long[] lArray5 = this.initialCpuTimePerThreadId;
                if (this.initialCpuTimePerThreadId == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"initialCpuTimePerThreadId");
                    lArray5 = null;
                }
                long elapsedCpuNs = l - lArray5[i];
                long elapsedCpuMs = elapsedCpuNs / (long)1000000;
                cpuUsagePerThreadId[i] = threadCpuUse = RangesKt.coerceIn((double)(100.0 * (double)elapsedCpuMs / (double)durationMs), (double)0.0, (double)100.0);
            }
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        long[] lArray6 = this.threadIds;
        if (this.threadIds == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"threadIds");
            lArray6 = null;
        }
        Iterable elapsedCpuNs = ArraysKt.zip((long[])lArray6, (Object[])ArraysKt.toTypedArray((double[])cpuUsagePerThreadId));
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = (Long)it.getFirst();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Long)it.getFirst()));
            }
        });
        $i$f$sortedByDescending = false;
        List threadsWithCpuUse = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = (Double)it.getSecond();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getSecond()));
            }
        });
        for (Pair pair : threadsWithCpuUse) {
            String cpuUseString;
            long id2 = ((Number)pair.component1()).longValue();
            double cpuUse = ((Number)pair.component2()).doubleValue();
            if (cpuUse < 0.01) continue;
            ThreadInfo threadInfo = threadBean.getThreadInfo(id2);
            Locale locale = null;
            String string = "%.2f";
            Object[] objectArray = new Object[]{cpuUse};
            Intrinsics.checkNotNullExpressionValue((Object)String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(...)");
            StringBuilder stringBuilder = threadInfo != null ? sb.append("Thread #" + id2 + " - " + threadInfo.getThreadName() + ": " + cpuUseString + "%").append('\n') : sb.append("Thread #" + id2 + " (dead): " + cpuUseString + "%").append('\n');
        }
        double totalLoad = Arrays.stream(cpuUsagePerThreadId).filter(CPUUseReportContributor::stopCollection$lambda$3).sum();
        Locale locale = null;
        String string = "%.2f";
        Object[] objectArray = new Object[]{totalLoad};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String totalLoadString = string2;
        sb.append('\n');
        sb.append("Duration by uptime: " + durationMs + "ms").append('\n');
        sb.append("CPU count: " + cpuCount).append('\n');
        sb.append("Total CPU load: " + totalLoadString + "%").append('\n');
        String string3 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        this.report = string3;
    }

    @Override
    @NotNull
    public String getReport() {
        return this.report;
    }

    @Override
    public void generateReport(@NotNull BiConsumer<String, String> saveReportCallback) {
        Intrinsics.checkNotNullParameter(saveReportCallback, (String)"saveReportCallback");
        saveReportCallback.accept("cpuUseDiagnostics", this.report);
    }

    private static final long startCollection$lambda$0(Thread obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.getId();
    }

    private static final long startCollection$lambda$1(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).longValue();
    }

    private static final boolean stopCollection$lambda$3(double d) {
        return d >= 0.0;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/diagnostics/CPUUseReportContributor$Companion;", "", "<init>", "()V", "threadBean", "Ljava/lang/management/ThreadMXBean;", "kotlin.jvm.PlatformType", "runtimeBean", "Ljava/lang/management/RuntimeMXBean;", "osBean", "Ljava/lang/management/OperatingSystemMXBean;", "getCpuTimeForThreadIds", "", "ids", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        private final long[] getCpuTimeForThreadIds(long[] ids) {
            long[] longArray = new long[ids.length];
            for (long id2 : ids) {
                longArray[i] = threadBean.getThreadCpuTime(id2);
            }
            return longArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

