/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.monitor.ui;

import com.android.tools.idea.device.explorer.monitor.ui.menu.item.PopupMenuItem;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PopupHandler;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/device/explorer/monitor/ui/ComponentPopupMenu;", "", "table", "Ljavax/swing/JTable;", "<init>", "(Ljavax/swing/JTable;)V", "myGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "install", "", "addSeparator", "addItem", "popupMenuItem", "Lcom/android/tools/idea/device/explorer/monitor/ui/menu/item/PopupMenuItem;", "intellij.android.device-explorer-monitor"})
public final class ComponentPopupMenu {
    @NotNull
    private final JTable table;
    @NotNull
    private final DefaultActionGroup myGroup;

    public ComponentPopupMenu(@NotNull JTable table2) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        this.table = table2;
        this.myGroup = new DefaultActionGroup();
    }

    public final void install() {
        PopupHandler.installRowSelectionTablePopup((JTable)this.table, (ActionGroup)((ActionGroup)this.myGroup), (String)"Device Monitor Toolbar");
    }

    public final void addSeparator() {
        this.myGroup.addSeparator();
    }

    public final void addItem(@NotNull PopupMenuItem popupMenuItem) {
        Shortcut[] shortcuts;
        Intrinsics.checkNotNullParameter((Object)popupMenuItem, (String)"popupMenuItem");
        AnAction action2 = popupMenuItem.getAction();
        String shortcutId = popupMenuItem.getShortcutId();
        if (!StringUtil.isEmpty((String)shortcutId)) {
            Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
            Intrinsics.checkNotNullExpressionValue((Object)keymap, (String)"getActiveKeymap(...)");
            Keymap active = keymap;
            Shortcut[] shortcutArray = active.getShortcuts(shortcutId);
            Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
            Shortcut[] shortcuts2 = shortcutArray;
            action2.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(Arrays.copyOf(shortcuts2, shortcuts2.length)), (JComponent)this.table);
        }
        if ((shortcuts = popupMenuItem.getShortcuts()) != null && !(shortcuts.length == 0)) {
            Shortcut[] shortcutArray = shortcuts;
            action2.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(Arrays.copyOf(shortcutArray, shortcutArray.length)), (JComponent)this.table);
        }
        this.myGroup.add(action2);
    }
}

