/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding.analytics;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.analytics.UsageTrackerUtils;
import com.android.tools.idea.databinding.analytics.api.DataBindingTracker;
import com.android.tools.idea.databinding.index.BindingLayoutType;
import com.android.tools.idea.databinding.index.BindingXmlData;
import com.android.tools.idea.databinding.index.BindingXmlIndex;
import com.android.tools.idea.databinding.project.LayoutBindingEnabledFacetsProvider;
import com.android.tools.idea.databinding.util.DataBindingUtil;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.DataBindingEvent;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@VisibleForTesting
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J$\u0010\u0013\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/databinding/analytics/LayoutBindingTracker;", "Lcom/android/tools/idea/databinding/analytics/api/DataBindingTracker;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "trackPolledMetaData", "", "trackDataBindingCompletion", "eventType", "Lcom/google/wireless/android/sdk/stats/DataBindingEvent$EventType;", "context", "Lcom/google/wireless/android/sdk/stats/DataBindingEvent$DataBindingContext;", "enabledFacetsProvider", "Lcom/android/tools/idea/databinding/project/LayoutBindingEnabledFacetsProvider;", "isDataBindingEnabled", "", "isViewBindingEnabled", "trackUserEvent", "trackPollingEvent", "dataBindingMetadata", "Lcom/google/wireless/android/sdk/stats/DataBindingEvent$DataBindingPollMetadata;", "viewBindingMetaData", "Lcom/google/wireless/android/sdk/stats/DataBindingEvent$ViewBindingPollMetadata;", "runInBackground", "runnable", "Ljava/lang/Runnable;", "createStudioEventBuilder", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "kotlin.jvm.PlatformType", "TrackPollingMetadataTask", "intellij.android.databinding"})
public class LayoutBindingTracker
implements DataBindingTracker {
    @NotNull
    private final Project project;
    @NotNull
    private final LayoutBindingEnabledFacetsProvider enabledFacetsProvider;

    public LayoutBindingTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.enabledFacetsProvider = LayoutBindingEnabledFacetsProvider.Companion.getInstance(this.project);
    }

    @Override
    public void trackPolledMetaData() {
        if (!((Collection)this.enabledFacetsProvider.getAllBindingEnabledFacets()).isEmpty()) {
            this.runInBackground(new TrackPollingMetadataTask(this.project));
        }
    }

    @Override
    public void trackDataBindingCompletion(@NotNull DataBindingEvent.EventType eventType, @NotNull DataBindingEvent.DataBindingContext context) {
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.isDataBindingEnabled()) {
            this.trackUserEvent(eventType, context);
        }
    }

    private final boolean isDataBindingEnabled() {
        return !((Collection)this.enabledFacetsProvider.getDataBindingEnabledFacets()).isEmpty();
    }

    private final boolean isViewBindingEnabled() {
        return !((Collection)this.enabledFacetsProvider.getViewBindingEnabledFacets()).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final void trackUserEvent(DataBindingEvent.EventType eventType, DataBindingEvent.DataBindingContext context) {
        void $this$trackUserEvent_u24lambda_u240_u240;
        DataBindingEvent.Builder builder;
        AndroidStudioEvent.Builder builder2;
        AndroidStudioEvent.Builder $this$trackUserEvent_u24lambda_u240 = builder2 = this.createStudioEventBuilder();
        boolean bl = false;
        DataBindingEvent.Builder builder3 = builder = DataBindingEvent.newBuilder();
        AndroidStudioEvent.Builder builder4 = $this$trackUserEvent_u24lambda_u240;
        boolean bl2 = false;
        $this$trackUserEvent_u24lambda_u240_u240.setType(eventType);
        $this$trackUserEvent_u24lambda_u240_u240.setContext(context);
        builder4.setDataBindingEvent(builder.build());
        AndroidStudioEvent.Builder studioEventBuilder = builder2;
        Intrinsics.checkNotNull((Object)studioEventBuilder);
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(studioEventBuilder, this.project));
    }

    /*
     * WARNING - void declaration
     */
    private final void trackPollingEvent(DataBindingEvent.EventType eventType, DataBindingEvent.DataBindingPollMetadata dataBindingMetadata, DataBindingEvent.ViewBindingPollMetadata viewBindingMetaData) {
        void $this$trackPollingEvent_u24lambda_u240_u240;
        DataBindingEvent.Builder builder;
        AndroidStudioEvent.Builder builder2;
        AndroidStudioEvent.Builder $this$trackPollingEvent_u24lambda_u240 = builder2 = this.createStudioEventBuilder();
        boolean bl = false;
        DataBindingEvent.Builder builder3 = builder = DataBindingEvent.newBuilder();
        AndroidStudioEvent.Builder builder4 = $this$trackPollingEvent_u24lambda_u240;
        boolean bl2 = false;
        $this$trackPollingEvent_u24lambda_u240_u240.setType(eventType);
        $this$trackPollingEvent_u24lambda_u240_u240.setPollMetadata(dataBindingMetadata);
        $this$trackPollingEvent_u24lambda_u240_u240.setViewBindingMetadata(viewBindingMetaData);
        builder4.setDataBindingEvent(builder.build());
        AndroidStudioEvent.Builder studioEventBuilder = builder2;
        Intrinsics.checkNotNull((Object)studioEventBuilder);
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(studioEventBuilder, this.project));
    }

    protected void runInBackground(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        ApplicationManager.getApplication().executeOnPooledThread(runnable2);
    }

    private final AndroidStudioEvent.Builder createStudioEventBuilder() {
        return AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.DATA_BINDING);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/databinding/analytics/LayoutBindingTracker$TrackPollingMetadataTask;", "Ljava/lang/Runnable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/android/tools/idea/databinding/analytics/LayoutBindingTracker;Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "run", "", "intellij.android.databinding"})
    @SourceDebugExtension(value={"SMAP\nLayoutBindingTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutBindingTracker.kt\ncom/android/tools/idea/databinding/analytics/LayoutBindingTracker$TrackPollingMetadataTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,173:1\n1#2:174\n1#2:195\n1788#3,4:175\n1617#3,9:185\n1869#3:194\n1870#3:196\n1626#3:197\n12797#4,3:179\n12797#4,3:182\n*S KotlinDebug\n*F\n+ 1 LayoutBindingTracker.kt\ncom/android/tools/idea/databinding/analytics/LayoutBindingTracker$TrackPollingMetadataTask\n*L\n116#1:195\n133#1:175,4\n116#1:185,9\n116#1:194\n116#1:196\n116#1:197\n145#1:179,3\n147#1:182,3\n*E\n"})
    private final class TrackPollingMetadataTask
    implements Runnable {
        @NotNull
        private final Project project;

        public TrackPollingMetadataTask(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            void $this$run_u24lambda_u246;
            Module it;
            Module element$iv;
            int n;
            Module[] $this$count$iv;
            DataBindingEvent.DataBindingPollMetadata.Builder $this$run_u24lambda_u245;
            int n2;
            int n3;
            int n4;
            List bindingXmlData = (List)ReadAction.nonBlocking(() -> TrackPollingMetadataTask.run$lambda$0(this)).inSmartMode(this.project).executeSynchronously();
            Intrinsics.checkNotNull((Object)bindingXmlData);
            Sequence dataBindingLayouts = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)bindingXmlData), TrackPollingMetadataTask::run$lambda$1);
            int dataBindingLayoutCount = SequencesKt.count((Sequence)dataBindingLayouts);
            Sequence sequence = dataBindingLayouts;
            int n5 = 0;
            for (Object object : sequence) {
                Object it2;
                BindingXmlData bindingXmlData2 = (BindingXmlData)object;
                n4 = n5;
                boolean bl = false;
                n3 = ((BindingXmlData)it2).getImports().size();
                n5 = n4 + n3;
            }
            int importCount = n5;
            Sequence sequence2 = dataBindingLayouts;
            int n6 = 0;
            for (Object it2 : sequence2) {
                void it3;
                BindingXmlData bl = (BindingXmlData)it2;
                n4 = n6;
                boolean bl2 = false;
                n3 = it3.getVariables().size();
                n6 = n4 + n3;
            }
            int variableCount = n6;
            Iterable $this$count$iv2 = bindingXmlData;
            boolean $i$f$count = false;
            if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv2 : $this$count$iv2) {
                    BindingXmlData it4 = (BindingXmlData)element$iv2;
                    boolean bl = false;
                    if (!(it4.getLayoutType() == BindingLayoutType.PLAIN_LAYOUT && !it4.getViewBindingIgnore()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            int viewBindingLayoutCount = n2;
            DataBindingEvent.DataBindingPollMetadata.Builder builder = DataBindingEvent.DataBindingPollMetadata.newBuilder();
            LayoutBindingTracker layoutBindingTracker = LayoutBindingTracker.this;
            DataBindingEvent.DataBindingPollMetadata.Builder count$iv = builder;
            DataBindingEvent.EventType eventType = DataBindingEvent.EventType.DATA_BINDING_BUILD_EVENT;
            LayoutBindingTracker layoutBindingTracker2 = LayoutBindingTracker.this;
            boolean bl = false;
            $this$run_u24lambda_u245.setDataBindingEnabled(layoutBindingTracker.isDataBindingEnabled());
            $this$run_u24lambda_u245.setLayoutXmlCount(dataBindingLayoutCount);
            $this$run_u24lambda_u245.setImportCount(importCount);
            $this$run_u24lambda_u245.setVariableCount(variableCount);
            Module[] element$iv2 = ModuleManager.Companion.getInstance(this.project).getModules();
            void var12_30 = $this$run_u24lambda_u245;
            boolean $i$f$count2 = false;
            int count$iv2 = 0;
            int n7 = $this$count$iv.length;
            for (n = 0; n < n7; ++n) {
                it = element$iv = $this$count$iv[n];
                boolean bl3 = false;
                if (!(ModuleExtensionsKt.getAndroidFacet((Module)it) != null)) continue;
                ++count$iv2;
            }
            int n8 = count$iv2;
            var12_30.setModuleCount(n8);
            $this$count$iv = ModuleManager.Companion.getInstance(this.project).getModules();
            var12_30 = $this$run_u24lambda_u245;
            $i$f$count2 = false;
            count$iv2 = 0;
            n7 = $this$count$iv.length;
            for (n = 0; n < n7; ++n) {
                boolean bl4;
                it = element$iv = $this$count$iv[n];
                boolean bl5 = false;
                if (ModuleExtensionsKt.getAndroidFacet((Module)it) != null) {
                    AndroidFacet p0;
                    boolean bl6 = false;
                    bl4 = DataBindingUtil.isDataBindingEnabled(p0);
                } else {
                    bl4 = false;
                }
                if (!bl4) continue;
                ++count$iv2;
            }
            n8 = count$iv2;
            var12_30.setDataBindingEnabledModuleCount(n8);
            Unit unit = Unit.INSTANCE;
            DataBindingEvent.DataBindingPollMetadata dataBindingPollMetadata = builder.build();
            builder = DataBindingEvent.ViewBindingPollMetadata.newBuilder();
            layoutBindingTracker = LayoutBindingTracker.this;
            $this$run_u24lambda_u245 = builder;
            unit = dataBindingPollMetadata;
            boolean bl7 = false;
            $this$run_u24lambda_u246.setViewBindingEnabled(layoutBindingTracker.isViewBindingEnabled());
            $this$run_u24lambda_u246.setLayoutXmlCount(viewBindingLayoutCount);
            Unit unit2 = Unit.INSTANCE;
            layoutBindingTracker2.trackPollingEvent(eventType, (DataBindingEvent.DataBindingPollMetadata)unit, builder.build());
        }

        /*
         * WARNING - void declaration
         */
        private static final List run$lambda$0(TrackPollingMetadataTask this$0) {
            void $this$mapNotNullTo$iv$iv;
            Collection collection2 = FileTypeIndex.getFiles((FileType)((FileType)XmlFileType.INSTANCE), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this$0.project));
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getFiles(...)");
            Iterable $this$mapNotNull$iv = collection2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                BindingXmlData it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl2 = false;
                ProgressManager.checkCanceled();
                Project project = this$0.project;
                Intrinsics.checkNotNull((Object)it);
                if (BindingXmlIndex.Companion.getDataForFile(project, it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private static final boolean run$lambda$1(BindingXmlData it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getLayoutType() == BindingLayoutType.DATA_BINDING_LAYOUT;
        }
    }
}

